/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import java.util.Locale;

public final class ElapsedTimer {
    private long startTime = System.currentTimeMillis();
    private NumberFormat myDurationFormat = null;
    private MessageFormat myMsgFormat = null;
    private static NumberFormat gFormat = null;

    public static String elapsedTime(long start, long end) {
        return ElapsedTimer.diffTime(ElapsedTimer.getFormat(), start, end);
    }

    public static String elapsedTime(long start) {
        return ElapsedTimer.diffTime(ElapsedTimer.getFormat(), start, System.currentTimeMillis());
    }

    public ElapsedTimer() {
    }

    public ElapsedTimer(MessageFormat aMsgFmt) {
        this.myMsgFormat = aMsgFmt;
    }

    public ElapsedTimer(NumberFormat aNumFmt) {
        this.myDurationFormat = aNumFmt;
    }

    public ElapsedTimer(MessageFormat aMsgFmt, NumberFormat aNumFmt) {
        this.myMsgFormat = aMsgFmt;
        this.myDurationFormat = aNumFmt;
    }

    public ElapsedTimer(String pattern) {
        this.myMsgFormat = new MessageFormat(pattern);
    }

    public ElapsedTimer(String pattern, NumberFormat aNumFmt) {
        this.myMsgFormat = new MessageFormat(pattern);
        this.myDurationFormat = aNumFmt;
    }

    public final String toString() {
        long endTime = System.currentTimeMillis();
        String duration = ElapsedTimer.diffTime(this.myDurationFormat, this.startTime, endTime);
        if (this.myMsgFormat == null) {
            return duration;
        }
        return this.myMsgFormat.format(new Object[]{duration});
    }

    private static NumberFormat getFormat() {
        if (gFormat == null) {
            gFormat = new RuleBasedNumberFormat(Locale.US, 3);
        }
        return gFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String diffTime(NumberFormat fmt, long start, long end) {
        if (fmt == null) {
            fmt = ElapsedTimer.getFormat();
        }
        NumberFormat numberFormat = fmt;
        synchronized (numberFormat) {
            long age = end - start;
            long diff = age / 1000L;
            return fmt.format(diff);
        }
    }
}

