/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Joiner;
import com.ibm.icu.text.NumberFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter2;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateLanguageData {
    SupplementalDataInfo info = SupplementalDataInfo.getInstance(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
    Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
    CLDRFile english = this.cldrFactory.make("en", true);
    CLDRFile root = this.cldrFactory.make("root", true);
    StandardCodes sc = StandardCodes.make();
    NumberFormat nf = NumberFormat.getInstance();
    NumberFormat pf = NumberFormat.getPercentInstance();

    public static void main(String[] args) throws IOException {
        new GenerateLanguageData().run();
    }

    private void run() throws IOException {
        try (PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "langData/", "generatedLanguageData.txt");){
            Counter2<String> langToPopulation = new Counter2<String>();
            LanguageTagParser ltp = new LanguageTagParser();
            TreeMap<String, String> languageNameToCode = new TreeMap<String, String>();
            for (String string : this.info.getLanguages()) {
                languageNameToCode.put(this.english.getName(string), string);
            }
            out.println("\n@sheet:CLDR County Data");
            out.println("code\tgdp\tlit-pop\tpopulation\tliteracy");
            for (String string : this.info.getTerritoriesWithPopulationData()) {
                SupplementalDataInfo.PopulationData terrData = this.info.getPopulationDataForTerritory(string);
                out.println(string + "\t" + terrData.getGdp() + "\t" + terrData.getLiteratePopulation() + "\t" + terrData.getPopulation() + "\t" + terrData.getLiteratePopulationPercent() / 100.0);
            }
            out.flush();
            out.println("\n@sheet:CLDR Language Data");
            out.println("LC\tName\tCC\tName\tStatus\tLitPop");
            TreeMap<String, Counter2<String>> langToCountriesOfficial = new TreeMap<String, Counter2<String>>();
            for (String languageCode : this.info.getLanguages()) {
                Set<String> territories;
                String languageName = this.english.getName(languageCode);
                String baseLanguage = languageCode;
                ltp.set(languageCode);
                String script = ltp.getScript();
                if (script.length() != 0 && !script.startsWith("Han")) {
                    baseLanguage = ltp.getLanguage();
                }
                if ((territories = this.info.getTerritoriesForPopulationData(languageCode)) == null) continue;
                for (String territory : territories) {
                    double literatePopulationLangRegion;
                    SupplementalDataInfo.PopulationData terrData = this.info.getPopulationDataForTerritory(territory);
                    String territoryName = this.english.getName(2, territory);
                    SupplementalDataInfo.PopulationData data = this.info.getLanguageAndTerritoryPopulationData(languageCode, territory);
                    double pop = literatePopulationLangRegion = data.getLiteratePopulation();
                    langToPopulation.add(baseLanguage, pop);
                    SupplementalDataInfo.OfficialStatus status = data.getOfficialStatus();
                    if (status.compareTo(SupplementalDataInfo.OfficialStatus.official_minority) >= 0) {
                        Counter2<String> counter = (Counter2<String>)langToCountriesOfficial.get(baseLanguage);
                        if (counter == null) {
                            counter = new Counter2<String>();
                            langToCountriesOfficial.put(baseLanguage, counter);
                        }
                        counter.add(territory, literatePopulationLangRegion);
                    }
                    double populationRegion = terrData.getPopulation();
                    double literatePopulationRegion = terrData.getLiteratePopulation();
                    double factor = literatePopulationLangRegion / literatePopulationRegion;
                    out.println(this.fixLang(languageCode) + "\t" + languageName + "\t" + territory + "\t" + territoryName + "\t" + status + "\t" + literatePopulationLangRegion);
                }
            }
            out.flush();
            out.println("\n@sheet:CLDR Lang-Countries");
            out.println("LangCode\tRegionCode");
            TreeSet<String> treeSet = new TreeSet<String>(this.info.getLanguages());
            for (Map.Entry entry : langToCountriesOfficial.entrySet()) {
                Counter2 regions = (Counter2)entry.getValue();
                ArrayList top = new ArrayList(regions.getKeysetSortedByCount(false));
                String lang = (String)entry.getKey();
                out.println(this.fixLang(lang) + "\t" + (String)(top.size() < 6 ? Joiner.on(", ").join(top) : Joiner.on(", ").join(top.subList(0, 5)) + ", \u2026"));
                treeSet.remove(lang);
            }
            for (String lang : treeSet) {
                out.println(this.fixLang(lang) + "\tnone");
            }
        }
    }

    private String fixLang(String key) {
        return key.replace('_', '-');
    }
}

