/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.BitSet;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.PatternFixer;

public class UnicodeSetFormat
extends Format {
    static final int blockEnum = UCharacter.getPropertyEnum("block");
    private static final long serialVersionUID = 1L;
    private PatternFixer.Target target;
    private int options;
    private Extension[] extensions;
    private static final UnicodeSet toQuote = new UnicodeSet("[[:Cn:][:Default_Ignorable_Code_Point:][:patternwhitespace:]]").freeze();

    public UnicodeSetFormat(PatternFixer.Target target) {
        this.target = target;
    }

    public UnicodeSetFormat(PatternFixer.Target target, int patternOptions) {
        this.target = target;
        this.options = patternOptions;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int startPos = toAppendTo.length();
        TreeSet<String> strings = null;
        toAppendTo.append('[');
        UnicodeSetIterator it = new UnicodeSetIterator((UnicodeSet)obj);
        while (it.nextRange()) {
            if (it.codepoint == -1) {
                if (strings == null) {
                    strings = new TreeSet<String>();
                }
                strings.add(it.string);
                continue;
            }
            this.appendQuoted(toAppendTo, it.codepoint);
            if (it.codepointEnd == it.codepoint) continue;
            this.appendQuoted(toAppendTo.append('-'), it.codepointEnd);
        }
        toAppendTo.append(']');
        if (strings != null) {
            StringBuffer extras = new StringBuffer("(?:");
            for (String string : strings) {
                this.appendQuoted(extras, string).append('|');
            }
            toAppendTo.insert(startPos, extras);
            toAppendTo.append(')');
        }
        return toAppendTo;
    }

    private StringBuffer appendQuoted(StringBuffer target, int codePoint) {
        switch (codePoint) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                target.append('\\');
                break;
            }
            default: {
                if (!toQuote.contains(codePoint)) break;
                if (codePoint > 65535) {
                    target.append("\\u");
                    target.append(Utility.hex(UTF16.getLeadSurrogate(codePoint), 4));
                    codePoint = UTF16.getTrailSurrogate(codePoint);
                }
                target.append("\\u");
                target.append(Utility.hex(codePoint, 4));
                return target;
            }
        }
        UTF16.append(target, codePoint);
        return target;
    }

    private StringBuffer appendQuoted(StringBuffer target, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.appendQuoted(target, string.charAt(i));
        }
        return target;
    }

    @Override
    public final UnicodeSet parseObject(String pattern, ParsePosition pos) {
        return new UnicodeSet(pattern, pos, null);
    }

    public PatternFixer.Target getTarget() {
        return this.target;
    }

    public UnicodeSetFormat setTarget(PatternFixer.Target target) {
        this.target = target;
        return this;
    }

    public int getOptions() {
        return this.options;
    }

    public UnicodeSetFormat setOptions(int options) {
        this.options = options;
        return this;
    }

    public Extension[] getExtensions() {
        return this.extensions;
    }

    public UnicodeSetFormat setExtensions(Extension ... extensions) {
        this.extensions = extensions;
        return this;
    }

    public String formatWithProperties(UnicodeSet original, boolean addOthers, UnicodeSet expandBlockIgnorables, int ... properties) {
        int i;
        UnicodeSet remainder = new UnicodeSet().addAll(original);
        TreeSet<String> propSet = new TreeSet<String>();
        BitSet props = new BitSet();
        for (i = 0; i < properties.length; ++i) {
            this.reduceByProperty(original, expandBlockIgnorables, properties[i], remainder, propSet);
            props.set(i);
        }
        if (addOthers) {
            for (i = 4096; i < 4121; ++i) {
                if (props.get(i)) continue;
                this.reduceByProperty(original, expandBlockIgnorables, i, remainder, propSet);
            }
        }
        StringBuffer result = new StringBuffer("[ ");
        for (String prop : propSet) {
            result.append(prop).append(" ");
        }
        if (expandBlockIgnorables != null) {
            result.append("- ").append(expandBlockIgnorables.toPattern(true));
        }
        if (remainder.size() > 0) {
            result.append(" ").append(remainder.toPattern(true));
        }
        result.append("]");
        return result.toString();
    }

    private void reduceByProperty(UnicodeSet original, UnicodeSet expandBlockIgnorables, int property, UnicodeSet remainder, Set<String> result) {
        String propertyAlias = UCharacter.getPropertyName(property, 0);
        UnicodeSet valueChars = new UnicodeSet();
        for (int i = UCharacter.getIntPropertyMinValue(property); i <= UCharacter.getIntPropertyMaxValue(property); ++i) {
            UnicodeSet hasScript;
            String valueAlias = UCharacter.getPropertyValueName(property, i, 0);
            if (valueAlias == null) {
                valueAlias = UCharacter.getPropertyValueName(property, i, 1);
            }
            if (valueAlias == null) continue;
            valueChars.clear();
            valueChars.applyPropertyAlias(propertyAlias, valueAlias);
            if (!remainder.containsSome(valueChars)) continue;
            if (original.containsAll(valueChars)) {
                result.add("[:" + propertyAlias + "=" + valueAlias + ":]");
                remainder.removeAll(valueChars);
                continue;
            }
            if (property != blockEnum || expandBlockIgnorables == null || (hasScript = new UnicodeSet(valueChars).removeAll(expandBlockIgnorables)).size() <= 5 || !original.containsAll(hasScript)) continue;
            System.out.println("Broadening to block: " + valueAlias);
            result.add("[:" + propertyAlias + "=" + valueAlias + ":]");
            remainder.removeAll(valueChars);
        }
    }

    public abstract class Extension {
        public abstract String replaceVariable(String var1, ParsePosition var2);

        public abstract boolean getProperty(String var1, String var2, boolean var3, UnicodeSet var4);
    }
}

