/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.unicode.cldr.icu.ICUResourceWriter;
import org.unicode.cldr.icu.UDataInfo;
import org.unicode.cldr.util.CldrUtility;

public class LDML2ICUBinaryWriter {
    private static final String COPYRIGHT = CldrUtility.getCopyrightString();
    public static int written = 0;
    private static final byte MAGIC1 = -38;
    private static final byte MAGIC2 = 39;
    private static boolean INCLUDE_COPYRIGHT = false;
    private static final short BYTES_TAKEN_BY_MAGIC1 = 1;
    private static final short BYTES_TAKEN_BY_MAGIC2 = 1;
    private static final short BYTES_TAKEN_BY_HEADER_SIZE = 2;
    public static final String CHARSET8 = "UTF-8";
    public static final String CHARSET16 = "UTF-16BE";
    private static final int BYTES_PER_UTF8_CHAR = 1;
    private static final int SPECIAL_NONE = 0;
    private static final int SPECIAL_COLLATIONS = 1;
    private static final int SPECIAL_COLLATIONELEMENTS = 2;
    private static final int SPECIAL_DEPENDENCY = 3;
    private static final int SPECIAL_TRANSLITERATOR = 4;
    public static final int URES_NONE = -1;
    public static final int URES_STRING = 0;
    public static final int URES_BINARY = 1;
    public static final int URES_TABLE = 2;
    public static final int URES_ALIAS = 3;
    public static final int URES_TABLE32 = 4;
    public static final int URES_INT = 7;
    public static final int URES_ARRAY = 8;
    public static final int URES_INT_VECTOR = 14;
    public static final int URES_LIMIT = 16;
    private static final int URES_INDEX_LENGTH = 0;
    private static final int URES_INDEX_STRINGS_TOP = 1;
    private static final int URES_INDEX_RESOURCES_TOP = 2;
    private static final int URES_INDEX_BUNDLE_TOP = 3;
    private static final int URES_INDEX_MAX_TABLE_LENGTH = 4;
    private static final int URES_INDEX_TOP = 6;
    private static Hashtable<String, String> ruleStringsHash = null;

    public static void main() {
    }

    public static void writeBinaryFile(ICUResourceWriter.Resource resTop, String outDir, String outFile) {
        Object fileName = "";
        int usedOffset = 0;
        Object directoryPath = "";
        if (outFile.indexOf(46) > -1) {
            fileName = outFile.substring(0, outFile.indexOf(46));
            if (((String)fileName).length() == 0) {
                LDML2ICUBinaryWriter.printError(outFile + " is not a valid file name.");
                System.exit(1);
            }
            fileName = (String)fileName + ".res";
        } else {
            fileName = outFile + ".res";
        }
        directoryPath = outDir.replace('\\', '/');
        if (((String)directoryPath).charAt(((String)directoryPath).length() - 1) != '/') {
            directoryPath = (String)directoryPath + "/";
        }
        byte[] dataFormat = new byte[]{82, 101, 115, 66};
        byte[] formatVersion = new byte[]{1, 2, 0, 0};
        byte[] dataVersion = new byte[]{1, 4, 0, 0};
        try {
            System.out.println("Creating file: " + (String)directoryPath + (String)fileName);
            File f = new File((String)directoryPath, (String)fileName);
            FileOutputStream out = new FileOutputStream(f);
            UDataInfo info = new UDataInfo(UDataInfo.getSize(), 0, 1, 0, 2, 0, dataFormat, formatVersion, dataVersion);
            LDML2ICUBinaryWriter.dealWithSpecialElements(resTop, outDir);
            resTop.sort();
            LDML2ICUBinaryWriter.writeBinaryHeader(out, info, COPYRIGHT);
            usedOffset = LDML2ICUBinaryWriter.writeKeyString(out, resTop);
            usedOffset = resTop.writeBinary(out, usedOffset);
            byte[] padding = LDML2ICUBinaryWriter.createPadding(LDML2ICUBinaryWriter.pad32(usedOffset));
            if (padding != null) {
                out.write(padding);
                written += padding.length;
            }
            out.close();
            System.out.println("Finished writing binary.");
        }
        catch (FileNotFoundException e) {
            LDML2ICUBinaryWriter.printError((String)directoryPath + (String)fileName + " could not be opened, please ensure the correct path is given.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException e) {
            LDML2ICUBinaryWriter.printError("access denied: " + (String)directoryPath + (String)fileName);
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            LDML2ICUBinaryWriter.printError(e.getMessage());
            System.exit(1);
        }
    }

    private static int getSpecialType(ICUResourceWriter.Resource res) {
        if (!res.hasKey) {
            return 0;
        }
        if (res.name.equals("CollationElements") && res instanceof ICUResourceWriter.ResourceTable) {
            return 2;
        }
        if (res.name.equals("collations") && res instanceof ICUResourceWriter.ResourceTable) {
            return 1;
        }
        if (res.name.equals("depends") && res instanceof ICUResourceWriter.ResourceProcess) {
            return 3;
        }
        if (res instanceof ICUResourceWriter.ResourceProcess && ((ICUResourceWriter.ResourceProcess)res).ext.equals("transliaterator")) {
            return 4;
        }
        return 0;
    }

    private static void dealWithSpecialElements(ICUResourceWriter.Resource top, String outDir) {
        if (top instanceof ICUResourceWriter.ResourceTable) {
            ICUResourceWriter.Resource cur = top.first;
            while (cur != null) {
                switch (LDML2ICUBinaryWriter.getSpecialType(cur)) {
                    case 2: {
                        LDML2ICUBinaryWriter.addCollation(cur);
                        break;
                    }
                    case 1: {
                        LDML2ICUBinaryWriter.addCollationElements(cur);
                        break;
                    }
                    case 3: {
                        LDML2ICUBinaryWriter.addDependency((ICUResourceWriter.ResourceTable)top, (ICUResourceWriter.ResourceProcess)cur, outDir);
                        break;
                    }
                    case 4: {
                        LDML2ICUBinaryWriter.addTransliteration((ICUResourceWriter.ResourceTable)top, (ICUResourceWriter.ResourceProcess)cur);
                        break;
                    }
                    default: {
                        LDML2ICUBinaryWriter.dealWithSpecialElements(cur, outDir);
                    }
                }
                cur = cur.next;
            }
        }
    }

    public static void setRulesHash(Hashtable<String, String> hash) {
        ruleStringsHash = hash;
    }

    private static void addTransliteration(ICUResourceWriter.ResourceTable parent, ICUResourceWriter.ResourceProcess trans) {
        String dataString;
        if (ruleStringsHash == null) {
            System.err.println("If you are processing transliteration, you must set the Rules Hashtable.");
            System.exit(-1);
        }
        if ((dataString = ruleStringsHash.get(trans.val)) == null) {
            System.err.println("Could not find data for: " + trans.val);
            System.exit(-1);
        }
        dataString = LDML2ICUBinaryWriter.stripRules(dataString);
        ICUResourceWriter.ResourceString replacement = new ICUResourceWriter.ResourceString("Resource", dataString);
        ICUResourceWriter.Resource current = parent.first;
        if (current != trans) {
            while (current != null && current.next != trans) {
                current = current.next;
            }
            if (current != null) {
                replacement.next = trans.next;
                current.next = replacement;
            } else {
                System.err.println("An unexpected error has occured: Could not find Transliteration resource.");
                System.exit(-1);
            }
        } else {
            replacement.next = trans.next;
            parent.first = replacement;
        }
    }

    private static boolean isUWhiteSpace(char c) {
        return c >= '\t' && c <= '\u2029' && (c <= '\r' || c == ' ' || c == '\u0085' || c == '\u200e' || c == '\u200f' || c >= '\u2028');
    }

    private static boolean isNewLine(char c) {
        return c == '\r' || c == '\n';
    }

    private static boolean isPunctuation(char c) {
        int x = UCharacter.getType(c);
        switch (x) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private static boolean isControl(char c) {
        int x = UCharacter.getType(c);
        switch (x) {
            case 15: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String stripRules(String data) {
        Object newData = "";
        int currentIndex = 0;
        char curChar2 = '0';
        boolean needChar2 = false;
        boolean quoted = false;
        try {
            while (currentIndex < data.length()) {
                char curChar;
                block17: {
                    block18: {
                        block19: {
                            block16: {
                                needChar2 = false;
                                curChar = data.charAt(currentIndex);
                                if (curChar != '\'') break block16;
                                quoted = !quoted;
                                break block17;
                            }
                            if (quoted) break block17;
                            if (curChar == '#') break block18;
                            if (curChar != '\\') break block19;
                            do {
                                if (++currentIndex >= data.length()) continue;
                                curChar = data.charAt(currentIndex);
                            } while (LDML2ICUBinaryWriter.isNewLine(curChar) && currentIndex < data.length());
                            if (curChar != 'u' || data.length() - currentIndex < 4) break block17;
                            String hexString = data.substring(currentIndex + 1, currentIndex + 5);
                            int codeNum = Integer.parseInt(hexString, 16);
                            String temp = UTF16.valueOf(codeNum);
                            char tempChar = temp.charAt(0);
                            if (tempChar == '\uffffffff') {
                                System.err.println("Invalid character found while processing file.");
                                System.exit(-1);
                            }
                            if (!(LDML2ICUBinaryWriter.isUWhiteSpace(tempChar) || LDML2ICUBinaryWriter.isPunctuation(tempChar) || LDML2ICUBinaryWriter.isControl(tempChar))) {
                                curChar = tempChar;
                                currentIndex += 4;
                                if (temp.length() > 1) {
                                    curChar2 = temp.charAt(1);
                                    needChar2 = true;
                                }
                            }
                            break block17;
                        }
                        if (curChar == '\'') {
                            quoted = !quoted;
                        }
                        break block17;
                    }
                    while (((String)newData).length() > 0 && (LDML2ICUBinaryWriter.isNewLine(((String)newData).charAt(((String)newData).length() - 1)) || LDML2ICUBinaryWriter.isUWhiteSpace(((String)newData).charAt(((String)newData).length() - 1)))) {
                        if (((String)newData).length() == 1) {
                            newData = "";
                            continue;
                        }
                        newData = ((String)newData).substring(0, ((String)newData).length() - 2);
                    }
                    while (!LDML2ICUBinaryWriter.isNewLine(curChar) && currentIndex < data.length()) {
                        if (++currentIndex >= data.length()) continue;
                        curChar = data.charAt(currentIndex);
                    }
                    if (++currentIndex < data.length()) {
                        curChar = data.charAt(currentIndex);
                    }
                }
                if (LDML2ICUBinaryWriter.isNewLine(curChar)) {
                    quoted = false;
                } else {
                    newData = (String)newData + curChar;
                    ++currentIndex;
                    if (!needChar2) continue;
                    newData = (String)newData + curChar2;
                    continue;
                }
                while (currentIndex < data.length() && LDML2ICUBinaryWriter.isNewLine(curChar)) {
                    if (++currentIndex >= data.length()) continue;
                    curChar = data.charAt(currentIndex);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Had a problem...");
        }
        if (((String)newData).length() > data.length()) {
            return null;
        }
        return newData;
    }

    private static void addDependency(ICUResourceWriter.ResourceTable parent, ICUResourceWriter.ResourceProcess dep, String outDir) {
        File f;
        Object filename = outDir;
        if (outDir.charAt(outDir.length() - 1) != '/' && outDir.charAt(outDir.length() - 1) != '\\') {
            filename = (String)filename + "/";
        }
        if (!(f = new File((String)(filename = (String)filename + dep.val))).exists()) {
            System.err.println("WARNING: Could not find dependancy: " + (String)filename);
        }
        ICUResourceWriter.ResourceArray a = new ICUResourceWriter.ResourceArray();
        a.name = "%%DEPENDENCY";
        ICUResourceWriter.ResourceString str = new ICUResourceWriter.ResourceString(null, dep.val);
        a.first = str;
        dep.addAfter(a);
        ICUResourceWriter.ResourceString replacement = new ICUResourceWriter.ResourceString(dep.name, dep.val);
        ICUResourceWriter.Resource current = parent.first;
        while (current != null && current.next != dep) {
            current = current.next;
        }
        replacement.next = dep.next;
        current.next = replacement;
    }

    private static void addCollationElements(ICUResourceWriter.Resource elementTable) {
        ICUResourceWriter.Resource cur = elementTable.first;
        while (cur != null) {
            LDML2ICUBinaryWriter.addCollation(cur);
            cur = cur.next;
        }
    }

    private static void addCollation(ICUResourceWriter.Resource element) {
        ICUResourceWriter.Resource cur = element.first;
        while (cur != null) {
            if (cur.hasKey && cur instanceof ICUResourceWriter.ResourceString) {
                ICUResourceWriter.ResourceString strElement = (ICUResourceWriter.ResourceString)cur;
                if (strElement.name.equals("Sequence")) {
                    // empty if block
                }
            }
            cur = cur.next;
        }
    }

    private static void writeBinaryHeader(FileOutputStream out, UDataInfo info, String copyright) {
        short headSize = 0;
        byte[] magics = new byte[2];
        int pad = 0;
        headSize = (short)(headSize + (info.size + 2 + 1 + 1));
        if (copyright != null && INCLUDE_COPYRIGHT) {
            headSize = (short)(headSize + (copyright.length() + 1));
        }
        if ((pad = LDML2ICUBinaryWriter.pad16Bytes(headSize)) != 0) {
            headSize = (short)(headSize + pad);
        }
        magics[0] = -38;
        magics[1] = 39;
        try {
            out.write(LDML2ICUBinaryWriter.shortToBytes(headSize));
            written += LDML2ICUBinaryWriter.shortToBytes(headSize).length;
            out.write(magics);
            written += magics.length;
            out.write(info.getByteArray());
            written += info.getByteArray().length;
            if (copyright != null && INCLUDE_COPYRIGHT) {
                out.write((copyright + "\u0000").getBytes(CHARSET8));
                written += (copyright + "\u0000").getBytes(CHARSET8).length;
            }
            if (pad != 0) {
                byte[] padding = new byte[pad];
                for (int i = 0; i < padding.length; ++i) {
                    padding[i] = 0;
                }
                out.write(padding);
                written += padding.length;
            }
        }
        catch (IOException e) {
            LDML2ICUBinaryWriter.printError(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int writeKeyString(FileOutputStream out, ICUResourceWriter.Resource resTop) {
        int sizeOfIndexes;
        String keyList = "";
        byte[] padding = null;
        int padBytes = 0;
        int[] indexes = new int[6];
        byte[] indexBytes = new byte[24];
        resTop.isTop = true;
        int usedOffset = sizeOfIndexes = 28;
        keyList = LDML2ICUBinaryWriter.buildKeyList(keyList, resTop, usedOffset);
        int sizeOfIndexesAndKeys = sizeOfIndexes + keyList.length();
        usedOffset = sizeOfIndexesAndKeys + LDML2ICUBinaryWriter.pad32(sizeOfIndexesAndKeys);
        int end = sizeOfIndexesAndKeys + resTop.sizeOfChildren;
        padBytes = LDML2ICUBinaryWriter.pad32(sizeOfIndexesAndKeys);
        if (padBytes != 0 && (padding = LDML2ICUBinaryWriter.createPadding(padBytes)) != null) {
            usedOffset += padding.length;
            end += padding.length;
        }
        int tableID = ((ICUResourceWriter.ResourceTable)resTop).is32Bit() ? 0x40000000 : 0x20000000;
        int root = end >>> 2 | tableID;
        byte[] rootBytes = LDML2ICUBinaryWriter.intToBytes(root);
        end += resTop.size;
        end += LDML2ICUBinaryWriter.pad32(end);
        indexes[0] = 6;
        indexes[1] = usedOffset >>> 2;
        indexes[2] = end >> 2;
        indexes[3] = indexes[2];
        indexes[4] = ICUResourceWriter.maxTableLength;
        indexBytes = LDML2ICUBinaryWriter.intArrayToBytes(indexes);
        try {
            out.write(rootBytes);
            written += rootBytes.length;
            out.write(indexBytes);
            written += indexBytes.length;
            byte[] keyBytes = keyList.getBytes(CHARSET8);
            out.write(keyBytes);
            written += keyBytes.length;
            if (padding != null) {
                out.write(padding);
                written += padding.length;
            }
        }
        catch (IOException e) {
            LDML2ICUBinaryWriter.printError("Could not write key string to file. " + e.getMessage());
            System.exit(1);
        }
        return usedOffset;
    }

    private static String buildKeyList(String keyList, ICUResourceWriter.Resource resTop, int usedOffset) {
        ICUResourceWriter.Resource current = resTop.first;
        int x = 0;
        if (!resTop.isTop && resTop.hasKey) {
            if (resTop.name.indexOf("\"") >= 0) {
                resTop.name = LDML2ICUBinaryWriter.removeQuotes(resTop.name);
            }
            resTop.keyStringOffset = usedOffset + ((String)keyList).length() * 1;
            keyList = (String)keyList + resTop.name + "\u0000";
        }
        while (current != null) {
            if (resTop instanceof ICUResourceWriter.ResourceArray || resTop instanceof ICUResourceWriter.ResourceIntVector) {
                current.hasKey = false;
            }
            keyList = LDML2ICUBinaryWriter.buildKeyList((String)keyList, current, usedOffset);
            ++x;
            current = current.next;
        }
        resTop.setSize();
        resTop.numChildren = x;
        return keyList;
    }

    private static byte[] shortToBytes(short x) {
        byte[] b = new byte[2];
        b[1] = (byte)x;
        b[0] = (byte)(x >>> 8);
        return b;
    }

    private static byte[] intToBytes(int x) {
        byte[] b = new byte[4];
        b[3] = (byte)x;
        b[2] = (byte)(x >>>= 8);
        b[1] = (byte)(x >>>= 8);
        b[0] = (byte)(x >>>= 8);
        return b;
    }

    private static byte[] intArrayToBytes(int[] x) {
        byte[] b = new byte[x.length * 4];
        for (int i = 0; i < x.length; ++i) {
            byte[] temp = LDML2ICUBinaryWriter.intToBytes(x[i]);
            for (int z = 0; z < 4; ++z) {
                b[i * 4 + z] = temp[z];
            }
        }
        return b;
    }

    private static int pad32(int x) {
        return x % 4 == 0 ? 0 : 4 - x % 4;
    }

    private static int pad16Bytes(int x) {
        return x % 16 == 0 ? 0 : 16 - x % 16;
    }

    private static void printError(String message) {
        System.err.println("LDML2ICUBinaryWriter : ERROR : " + message);
    }

    private static byte[] createPadding(int length) {
        byte x = 0;
        byte[] b = new byte[length];
        if (length == 0) {
            return null;
        }
        for (int z = 0; z < b.length; ++z) {
            b[z] = x;
        }
        return b;
    }

    public static String removeQuotes(String s2) {
        Object temp = s2;
        while (((String)temp).indexOf("\"") >= 0) {
            int x = ((String)temp).indexOf("\"");
            Object temp2 = ((String)temp).substring(0, x);
            temp = temp2 = (String)temp2 + ((String)temp).substring(x + 1, ((String)temp).length());
        }
        return temp;
    }
}

