/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.posix.POSIXVariant;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.SupplementalDataInfo;

public class POSIX_LCMonetary {
    String int_curr_symbol;
    String currency_symbol;
    String mon_decimal_point;
    String mon_thousands_sep;
    String mon_grouping;
    String positive_sign;
    String negative_sign;
    String frac_digits;
    String p_cs_precedes;
    String p_sep_by_space;
    String p_sign_posn;
    String n_cs_precedes;
    String n_sep_by_space;
    String n_sign_posn;
    String int_frac_digits;
    String int_p_cs_precedes;
    String int_p_sep_by_space;
    String int_p_sign_posn;
    String int_n_cs_precedes;
    String int_n_sep_by_space;
    String int_n_sign_posn;
    String numsys;
    private static final int POSITIVE = 0;
    private static final int NEGATIVE = 1;

    public POSIX_LCMonetary(CLDRFile doc, SupplementalDataInfo supp, POSIXVariant variant) {
        String grouping_pattern = doc.getWinningValue("//ldml/numbers/currencyFormats/currencyFormatLength/currencyFormat[@type='standard']/pattern[@type='standard']");
        String[] monetary_formats = new String[2];
        if (grouping_pattern.indexOf(";") > 0) {
            monetary_formats = grouping_pattern.split(";", 2);
        } else {
            monetary_formats[0] = grouping_pattern;
            monetary_formats[1] = "-" + grouping_pattern;
        }
        this.mon_grouping = POSIXUtilities.POSIXGrouping(monetary_formats[0]);
        String territory = ULocale.getCountry(doc.getLocaleID());
        if (variant.currency.equals("default")) {
            Set<SupplementalDataInfo.CurrencyDateInfo> ci = supp.getCurrencyDateInfo(territory);
            Iterator<SupplementalDataInfo.CurrencyDateInfo> it = ci.iterator();
            SupplementalDataInfo.CurrencyDateInfo currentCI = null;
            while (!(!it.hasNext() || (currentCI = it.next()).isLegalTender() && currentCI.getEnd().equals(SupplementalDataInfo.CurrencyDateInfo.END_OF_TIME))) {
                currentCI = null;
            }
            this.int_curr_symbol = currentCI == null ? "XXX" : currentCI.getCurrency();
        } else {
            this.int_curr_symbol = variant.currency;
        }
        String symbolPath = "//ldml/numbers/currencies/currency[@type=\"" + this.int_curr_symbol + "\"]/symbol";
        String tmp_currency_symbol = doc.getWinningValue(symbolPath);
        if (tmp_currency_symbol.indexOf("|") >= 0) {
            String[] choices = tmp_currency_symbol.split("\\u007c");
            for (int i = choices.length - 1; i >= 0; --i) {
                Float ten;
                String[] numvalue = choices[i].split("[<\\u2264]", 2);
                Float num = Float.valueOf(numvalue[0]);
                if (num.compareTo(ten = new Float(10.0f)) > 0 && i != 0) continue;
                this.currency_symbol = POSIXUtilities.POSIXCharName(numvalue[1]);
                i = 0;
            }
        } else {
            this.currency_symbol = POSIXUtilities.POSIXCharName(tmp_currency_symbol);
        }
        this.numsys = doc.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        this.mon_decimal_point = doc.getWinningValue("//ldml/numbers/currencies/currency[@type='" + this.int_curr_symbol + "']/decimal");
        if (this.mon_decimal_point == null) {
            this.mon_decimal_point = doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/currencyDecimal");
        }
        if (this.mon_decimal_point == null) {
            this.mon_decimal_point = doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/decimal");
        }
        this.mon_decimal_point = POSIXUtilities.POSIXCharName(this.mon_decimal_point);
        this.mon_thousands_sep = doc.getWinningValue("//ldml/numbers/currencies/currency[@type='" + this.int_curr_symbol + "']/group");
        if (this.mon_thousands_sep == null) {
            this.mon_thousands_sep = doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/currencyGroup");
        }
        if (this.mon_thousands_sep == null) {
            this.mon_thousands_sep = doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/group");
        }
        this.mon_thousands_sep = POSIXUtilities.POSIXCharName(this.mon_thousands_sep);
        int fracDigits = supp.getCurrencyNumberInfo(this.int_curr_symbol).getDigits();
        this.int_frac_digits = this.frac_digits = Integer.toString(fracDigits);
        this.positive_sign = monetary_formats[0].indexOf(43) >= 0 ? POSIXUtilities.POSIXCharName(doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/plusSign")) : "";
        this.negative_sign = monetary_formats[1].indexOf(45) >= 0 ? POSIXUtilities.POSIXCharName(doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/minusSign")) : POSIXUtilities.POSIXCharName("-");
        int currency_symbol_position = monetary_formats[0].indexOf(164);
        int decimal_symbol_position = monetary_formats[0].indexOf(46);
        int sign_position = monetary_formats[0].indexOf(43);
        int leftparen_position = monetary_formats[0].lastIndexOf(40, decimal_symbol_position);
        int rightparen_position = monetary_formats[0].indexOf(41, decimal_symbol_position);
        int space_position = monetary_formats[0].indexOf(32);
        if (space_position == -1) {
            space_position = monetary_formats[0].indexOf(160);
        }
        this.p_cs_precedes = currency_symbol_position >= 0 ? (currency_symbol_position > decimal_symbol_position ? "0" : "1") : "-1";
        this.int_p_cs_precedes = this.p_cs_precedes;
        this.p_sign_posn = this.positive_sign == "" ? (leftparen_position < decimal_symbol_position && rightparen_position > decimal_symbol_position ? "0" : "1") : (sign_position < currency_symbol_position ? (sign_position < decimal_symbol_position ? "1" : "3") : (sign_position > decimal_symbol_position ? "2" : "4"));
        this.int_p_sign_posn = this.p_sign_posn;
        this.p_sep_by_space = "0";
        boolean currency_and_sign_are_adjacent = false;
        if (currency_symbol_position < decimal_symbol_position && sign_position < decimal_symbol_position || currency_symbol_position > decimal_symbol_position && sign_position > decimal_symbol_position) {
            currency_and_sign_are_adjacent = true;
        }
        if (currency_and_sign_are_adjacent && sign_position >= 0) {
            if (POSIXUtilities.isBetween(currency_symbol_position, space_position, decimal_symbol_position) && POSIXUtilities.isBetween(sign_position, space_position, decimal_symbol_position)) {
                this.p_sep_by_space = "1";
            }
            if (POSIXUtilities.isBetween(currency_symbol_position, space_position, sign_position)) {
                this.p_sep_by_space = "2";
            }
        } else {
            if (currency_symbol_position > decimal_symbol_position && space_position == currency_symbol_position - 1 || currency_symbol_position < decimal_symbol_position && space_position == currency_symbol_position + 1) {
                this.p_sep_by_space = "1";
            }
            if (sign_position > decimal_symbol_position && space_position == sign_position - 1 || sign_position < decimal_symbol_position && space_position == sign_position + 1) {
                this.p_sep_by_space = "2";
            }
        }
        this.int_p_sep_by_space = this.p_sep_by_space;
        currency_symbol_position = monetary_formats[1].indexOf(164);
        decimal_symbol_position = monetary_formats[1].indexOf(46);
        sign_position = monetary_formats[1].indexOf(45);
        leftparen_position = monetary_formats[1].lastIndexOf(40, decimal_symbol_position);
        rightparen_position = monetary_formats[1].indexOf(41, decimal_symbol_position);
        space_position = monetary_formats[1].indexOf(32);
        if (space_position == -1) {
            space_position = monetary_formats[1].indexOf(160);
        }
        this.n_cs_precedes = currency_symbol_position >= 0 ? (currency_symbol_position > decimal_symbol_position ? "0" : "1") : "-1";
        this.int_n_cs_precedes = this.n_cs_precedes;
        this.n_sign_posn = this.negative_sign == "" ? (leftparen_position < decimal_symbol_position && rightparen_position > decimal_symbol_position ? "0" : "1") : (sign_position < currency_symbol_position ? (sign_position < decimal_symbol_position ? "1" : "3") : (sign_position > decimal_symbol_position ? "2" : "4"));
        this.int_n_sign_posn = this.n_sign_posn;
        this.n_sep_by_space = "0";
        currency_and_sign_are_adjacent = false;
        if (currency_symbol_position < decimal_symbol_position && sign_position < decimal_symbol_position || currency_symbol_position > decimal_symbol_position && sign_position > decimal_symbol_position) {
            currency_and_sign_are_adjacent = true;
        }
        if (currency_and_sign_are_adjacent && sign_position >= 0) {
            if (POSIXUtilities.isBetween(currency_symbol_position, space_position, decimal_symbol_position) && POSIXUtilities.isBetween(sign_position, space_position, decimal_symbol_position)) {
                this.n_sep_by_space = "1";
            }
            if (POSIXUtilities.isBetween(currency_symbol_position, space_position, sign_position)) {
                this.n_sep_by_space = "2";
            }
        } else {
            if (currency_symbol_position > decimal_symbol_position && space_position == currency_symbol_position - 1 || currency_symbol_position < decimal_symbol_position && space_position == currency_symbol_position + 1) {
                this.n_sep_by_space = "1";
            }
            if (sign_position > decimal_symbol_position && space_position == sign_position - 1 || sign_position < decimal_symbol_position && space_position == sign_position + 1) {
                this.n_sep_by_space = "2";
            }
        }
        this.int_n_sep_by_space = this.n_sep_by_space;
    }

    public void write(PrintWriter out) {
        out.println("*************");
        out.println("LC_MONETARY");
        out.println("*************");
        out.println();
        out.print("int_curr_symbol       \"");
        out.println(POSIXUtilities.POSIXCharName(this.int_curr_symbol + " ") + "\"");
        out.println("currency_symbol       \"" + this.currency_symbol + "\"");
        out.println("mon_decimal_point     \"" + this.mon_decimal_point + "\"");
        out.println("mon_thousands_sep     \"" + this.mon_thousands_sep + "\"");
        out.println("mon_grouping          " + this.mon_grouping);
        out.println("positive_sign         \"" + this.positive_sign + "\"");
        out.println("negative_sign         \"" + this.negative_sign + "\"");
        out.println("int_frac_digits       " + this.int_frac_digits);
        out.println("frac_digits           " + this.frac_digits);
        out.println("p_cs_precedes         " + this.p_cs_precedes);
        out.println("p_sep_by_space        " + this.p_sep_by_space);
        out.println("n_cs_precedes         " + this.n_cs_precedes);
        out.println("n_sep_by_space        " + this.n_sep_by_space);
        out.println("p_sign_posn           " + this.p_sign_posn);
        out.println("n_sign_posn           " + this.n_sign_posn);
        out.println("int_p_cs_precedes     " + this.int_p_cs_precedes);
        out.println("int_p_sep_by_space    " + this.int_p_sep_by_space);
        out.println("int_n_cs_precedes     " + this.int_n_cs_precedes);
        out.println("int_n_sep_by_space    " + this.int_n_sep_by_space);
        out.println("int_p_sign_posn       " + this.int_p_sign_posn);
        out.println("int_n_sign_posn       " + this.int_n_sign_posn);
        out.println();
        out.println("END LC_MONETARY");
        out.println();
        out.println();
    }
}

