/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.lang.UCharacter;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;

public class CheckCurrencies
extends CheckCLDR {
    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (path.indexOf("/currency") < 0 || path.indexOf("/symbol") < 0) {
            return this;
        }
        if (value != null && value.length() > 5) {
            if (!this.getCldrFileToCheck().getSourceLocaleID(path, null).equals(this.getCldrFileToCheck().getLocaleID())) {
                return this;
            }
            int adjustedLength = value.length();
            for (int idx = 0; idx < value.length(); ++idx) {
                if (UCharacter.getType(value.charAt(idx)) != 16 || --adjustedLength > 5) continue;
                return this;
            }
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.currencySymbolTooWide).setMessage("Currency symbol length > 5"));
        }
        return this;
    }
}

