/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.Date;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.test.OutdatedPaths;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.tool.CldrVersion;
import org.unicode.cldr.util.AnnotationUtil;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;

public class CheckNew
extends FactoryCheckCLDR {
    private OutdatedPaths outdatedPaths = OutdatedPaths.getInstance();
    boolean isRoot;

    public CheckNew(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.isRoot = "root".equals(cldrFileToCheck.getLocaleID());
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        CldrVersion birth;
        boolean isOutdated;
        Date modified;
        CLDRFile cldrFileToCheck = this.getCldrFileToCheck();
        if (!this.isRoot && value != null && AnnotationUtil.pathIsAnnotation(path) && cldrFileToCheck.getUnresolved().getStringValue(path) != null && AnnotationUtil.matchesCode(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.valueMustBeOverridden).setMessage("This value must be a real translation, NOT the name/keyword placeholder."));
        }
        if ((modified = cldrFileToCheck.getLastModifiedDate(path)) != null) {
            return this;
        }
        boolean bl = isOutdated = this.outdatedPaths.isOutdated(cldrFileToCheck.getLocaleID(), path) || SubmissionLocales.pathAllowedInLimitedSubmission(path);
        if (!isOutdated) {
            return this;
        }
        if (this.hasCoverageError(result)) {
            return this;
        }
        String englishValue = this.getEnglishFile().getStringValue(path);
        String oldEnglishValue = this.outdatedPaths.getPreviousEnglish(path);
        if (!"\ufffd".equals(oldEnglishValue) && (birth = this.outdatedPaths.getEnglishBirth(path)) != null) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.modifiedEnglishValue).setMessage("In CLDR {2} the English value for this field changed from \u201c{0}\u201d to \u201c{1}\u201d, but the corresponding value for your locale didn't change.", oldEnglishValue, englishValue, birth.toString()));
        }
        return this;
    }

    private boolean hasCoverageError(List<CheckCLDR.CheckStatus> result) {
        for (CheckCLDR.CheckStatus resultItem : result) {
            if (resultItem.getCause().getClass() != CheckCoverage.class) continue;
            return true;
        }
        return false;
    }
}

