/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class QuickCheck {
    private static final Set<String> skipAttributes = new HashSet<String>(Arrays.asList("alt", "draft", "references"));
    private static String localeRegex;
    private static boolean showInfo;
    private static String commonDirectory;
    private static String mainDirectory;
    private static boolean resolved;
    private static Exception[] internalException;
    private static boolean verbose;
    static Matcher skipPaths;
    private static boolean pretty;
    static final Date SAMPLE_DATE;

    public static void main(String[] args) throws IOException {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        Factory factory = testInfo.getCldrFactory();
        QuickCheck.checkStock(factory);
    }

    private static void checkDtds() throws IOException {
        QuickCheck.checkDtds(commonDirectory + "supplemental");
        QuickCheck.checkDtds(commonDirectory + "collation");
        QuickCheck.checkDtds(commonDirectory + "main");
        QuickCheck.checkDtds(commonDirectory + "rbnf");
        QuickCheck.checkDtds(commonDirectory + "segments");
        QuickCheck.checkDtds(commonDirectory + "../test");
        QuickCheck.checkDtds(commonDirectory + "transforms");
    }

    private static void checkDtds(String directory) throws IOException {
        File directoryFile = new File(directory);
        File[] listFiles = directoryFile.listFiles();
        String normalizedPath = PathUtilities.getNormalizedPathString(directoryFile);
        if (listFiles == null) {
            throw new IllegalArgumentException("Empty directory: " + normalizedPath);
        }
        System.out.println("Checking files for DTD errors in: " + normalizedPath);
        for (File fileName : listFiles) {
            if (!fileName.toString().endsWith(".xml")) continue;
            QuickCheck.check(fileName);
        }
    }

    public static void check(File systemID) {
        try (InputStream fis = InputStreamFactory.createInputStream(systemID);){
            XMLReader xmlReader = XMLFileReader.createXMLReader(true);
            xmlReader.setErrorHandler(new MyErrorHandler());
            InputSource is = new InputSource(fis);
            is.setSystemId(systemID.toString());
            xmlReader.parse(is);
        }
        catch (IOException | SAXException e) {
            System.out.println("\tCan't read " + systemID);
            System.out.println("\t" + e.getClass() + "\t" + e.getMessage());
        }
    }

    private static void checkPaths() {
        Relation<String, String> distinguishing = Relation.of(new TreeMap(), TreeSet.class, null);
        Relation<String, String> nonDistinguishing = Relation.of(new TreeMap(), TreeSet.class, null);
        Factory cldrFactory = Factory.make(mainDirectory, localeRegex);
        CLDRFile english = cldrFactory.make("en", true);
        Relation<String, String> pathToLocale = Relation.of(new TreeMap(CLDRFile.getComparator(DtdType.ldml)), TreeSet.class, null);
        for (String locale : cldrFactory.getAvailable()) {
            CLDRFile file;
            try {
                file = cldrFactory.make(locale, resolved);
            }
            catch (Exception e) {
                System.out.println("\nfatalError: " + e.getMessage());
                continue;
            }
            if (file.isNonInheriting()) continue;
            DisplayAndInputProcessor displayAndInputProcessor = new DisplayAndInputProcessor(file, false);
            System.out.println(locale + "\t-\t" + english.getName(locale));
            DtdType dtdType = null;
            Iterator<String> it = file.iterator();
            while (it.hasNext()) {
                String nonAltPath;
                String sourceLocale;
                String path = it.next();
                if (path.endsWith("/alias")) continue;
                String value = file.getStringValue(path);
                if (value == null) {
                    throw new IllegalArgumentException(locale + "\tError: in null value at " + path);
                }
                String displayValue = displayAndInputProcessor.processForDisplay(path, value);
                if (!displayValue.equals(value)) {
                    System.out.println("\t" + locale + "\tdisplayAndInputProcessor changes display value <" + value + ">\t=>\t<" + displayValue + ">\t\t" + path);
                }
                String inputValue = displayAndInputProcessor.processInput(path, value, internalException);
                if (internalException[0] != null) {
                    System.out.println("\t" + locale + "\tdisplayAndInputProcessor internal error <" + value + ">\t=>\t<" + inputValue + ">\t\t" + path);
                    internalException[0].printStackTrace(System.out);
                }
                if (verbose && !inputValue.equals(value)) {
                    displayAndInputProcessor.processInput(path, value, internalException);
                    System.out.println("\t" + locale + "\tdisplayAndInputProcessor changes input value <" + value + ">\t=>\t<" + inputValue + ">\t\t" + path);
                }
                pathToLocale.put(path, locale);
                if (path.contains("/identity")) continue;
                if (path.contains("proposed") && locale.equals(sourceLocale = file.getSourceLocaleID(path, null)) && !path.equals(nonAltPath = CLDRFile.getNondraftNonaltXPath(path))) {
                    String nonAltLocale = file.getSourceLocaleID(nonAltPath, null);
                    String nonAltValue = file.getStringValue(nonAltPath);
                    if (nonAltValue == null || !locale.equals(nonAltLocale)) {
                        System.out.println("\t" + locale + "\tProblem alt=proposed <" + value + ">\t\t" + path);
                    }
                }
                String fullPath = file.getFullXPath(path);
                XPathParts parts = XPathParts.getFrozenInstance(fullPath);
                if (dtdType == null) {
                    dtdType = DtdType.valueOf(parts.getElement(0));
                }
                for (int i = 0; i < parts.size(); ++i) {
                    if (parts.getAttributeCount(i) == 0) continue;
                    String element = parts.getElement(i);
                    for (String attribute : parts.getAttributeKeys(i)) {
                        if (skipAttributes.contains(attribute)) continue;
                        if (CLDRFile.isDistinguishing(dtdType, element, attribute)) {
                            distinguishing.put(element, attribute);
                            continue;
                        }
                        nonDistinguishing.put(element, attribute);
                    }
                }
            }
        }
        System.out.println();
        System.out.format("Distinguishing Elements: %s\n", distinguishing);
        System.out.format("Nondistinguishing Elements: %s\n", nonDistinguishing);
        System.out.format("Skipped %s\n", skipAttributes);
        if (pretty) {
            if (showInfo) {
                System.out.println("\nShowing Path to PrettyPath mapping\n");
            }
            PrettyPath prettyPath = new PrettyPath().setShowErrors(true);
            TreeSet<String> badPaths = new TreeSet<String>();
            for (String path : pathToLocale.keySet()) {
                String prettied = prettyPath.getPrettyPath(path, false);
                if (showInfo) {
                    System.out.println(prettied + "\t\t" + path);
                }
                if (!prettied.contains("%%") || path.contains("/alias")) continue;
                badPaths.add(path);
            }
            if (showInfo) {
                System.out.println("\nShowing Paths not in root\n");
            }
            CLDRFile root = cldrFactory.make("root", true);
            Iterator<String> it = root.iterator();
            while (it.hasNext()) {
                pathToLocale.removeAll(it.next());
            }
            if (showInfo) {
                for (String path : pathToLocale.keySet()) {
                    if (skipPaths.reset(path).find()) continue;
                    System.out.println(path + "\t" + pathToLocale.getAll(path));
                }
            }
            if (badPaths.size() != 0) {
                System.out.println("Error: " + badPaths.size() + " Paths were not prettied: use -DSHOW and look for ones with %% in them.");
            }
        }
    }

    static void checkStock(Factory factory) {
        String[][] items = new String[][]{{"full", "yMMMMEEEEd", "jmmsszzzz"}, {"long", "yMMMMd", "jmmssz"}, {"medium", "yMMMd", "jmmss"}, {"short", "yMd", "jmm"}};
        String calendarID = "gregorian";
        String datetimePathPrefix = "//ldml/dates/calendars/calendar[@type=\"" + calendarID + "\"]/";
        int total = 0;
        int mismatch = 0;
        LanguageTagParser ltp = new LanguageTagParser();
        Set<String> locales = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
        for (String locale : locales) {
            if (!ltp.set(locale).getRegion().isEmpty()) continue;
            CLDRFile file = factory.make(locale, false);
            DateTimeFormats dtf = new DateTimeFormats();
            dtf.set(file, "gregorian", false);
            for (String[] stockInfo : items) {
                String length = stockInfo[0];
                String path = datetimePathPrefix + "dateFormats/dateFormatLength[@type=\"" + length + "\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
                String stockDatePattern = file.getStringValue(path);
                String flexibleDatePattern = dtf.getBestPattern(stockInfo[1]);
                mismatch += QuickCheck.showStatus(++total, locale, "date", length, stockInfo[1], stockDatePattern, flexibleDatePattern);
                path = datetimePathPrefix + "timeFormats/timeFormatLength[@type=\"" + length + "\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
                String stockTimePattern = file.getStringValue(path);
                String flexibleTimePattern = dtf.getBestPattern(stockInfo[2]);
                mismatch += QuickCheck.showStatus(++total, locale, "time", length, stockInfo[2], stockTimePattern, flexibleTimePattern);
            }
        }
        System.out.println("Mismatches:\t" + mismatch + "\tTotal:\t" + total);
    }

    private static int showStatus(int total, String locale, String type, String length, String skeleton, String stockPattern, String flexiblePattern) {
        ULocale ulocale = new ULocale(locale);
        DateFormatSymbols dfs = new DateFormatSymbols(ulocale);
        boolean areSame = Objects.equals(stockPattern, flexiblePattern);
        System.out.println(total + "\t" + (areSame ? "ok" : "diff") + "\t" + locale + "\t" + type + "\t" + length + "\t" + skeleton + "\t" + stockPattern + "\t" + (areSame ? "" : flexiblePattern) + "\t'" + new SimpleDateFormat(stockPattern, dfs, ulocale).format(SAMPLE_DATE) + "\t'" + (areSame ? "" : new SimpleDateFormat(flexiblePattern, dfs, ulocale).format(SAMPLE_DATE)));
        return areSame ? 0 : 1;
    }

    static {
        showInfo = false;
        internalException = new Exception[1];
        skipPaths = PatternCache.get("/identity|/alias|\\[@alt=\"proposed").matcher("");
        SAMPLE_DATE = new Date(113, 0, 29, 13, 59, 59);
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("\nerror: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("\nfatalError: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("\nwarning: " + XMLFileReader.showSAX(exception));
            throw exception;
        }
    }
}

