/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.VersionInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.SupplementalDataInfo;

public class ChartDtdDelta
extends Chart {
    private static final Splitter SPLITTER_SPACE = Splitter.on(' ');
    private static final String NEW_PREFIX = "+";
    private static final String DEPRECATED_PREFIX = "\u2296";
    private static final String UNDEPRECATED_PREFIX = "\u2299";
    private static final String ORDERED_SIGN = "\u21e3";
    private static final String UNORDERED_SIGN = "\u21df";
    private static final String TECHPREVIEW_SIGN = "\ud83c\udd5f";
    private static final String UNTECHPREVIEW_SIGN = "\u24df";
    private static final Set<String> OMITTED_ATTRIBUTES = Collections.singleton("\u2295");
    static final String NONE = " ";
    static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    static Set<DtdType> TYPES = EnumSet.allOf(DtdType.class);
    static final Map<DtdType, String> FIRST_VERSION;
    static final DtdType DEBUG_DTD;
    static final String DEBUG_ELEMENT = "lias";
    static final boolean SHOW = false;
    List<DiffElement> data = new ArrayList<DiffElement>();
    static final Set<String> SKIP_ELEMENTS;
    static final Multimap<DtdType, String> SKIP_TYPE_ELEMENTS;
    static final Set<String> SKIP_ATTRIBUTES;
    static final Multimap<String, String> SKIP_ATTRIBUTE_MATCHES;

    public static void main(String[] args) {
        new ChartDtdDelta().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return FormattedFileWriter.CHART_TARGET_DIR;
    }

    @Override
    public String getTitle() {
        return "DTD Deltas";
    }

    @Override
    public String getExplanation() {
        return "<p>Changes to the LDML DTDs over time.</p>\n<ul>\n<li>New elements or attributes are indicated with a + sign, and newly deprecated ones with a \u2296 sign.</li>\n<li>Element attributes are abbreviated as \u2295 where is no change to them, but the element is newly the child of another.</li>\n<li>LDML DTDs have augmented data:\n<ul><li>Attribute status is marked by: " + DtdData.AttributeStatus.distinguished.shortName + "=" + DtdData.AttributeStatus.distinguished + ", " + DtdData.AttributeStatus.value.shortName + "=" + DtdData.AttributeStatus.value + ", or " + DtdData.AttributeStatus.metadata.shortName + "=" + DtdData.AttributeStatus.metadata + ".</li>\n<li>Attribute value constraints are marked with \u27e8\u2026\u27e9 (for DTD constraints) and \u27ea\u2026\u27eb (for augmented constraints, added in v35.0).</li>\n<li>Changes in status or constraints are shown with \u27a0, with identical sections shown with \u2026.</li>\n<li>Newly ordered elements are indicated with \u21e3; newly unordered with \u21df.</li>\n<li>Newly tech-preview items are marked with \ud83c\udd5f; newly graduated from tech preview with \u24df.</li>\n<li>The following elements are skipped: " + SKIP_ELEMENTS + " and " + SKIP_TYPE_ELEMENTS + "</li>\n<li>The following attributes are skipped: " + SKIP_ATTRIBUTES + " and " + SKIP_ATTRIBUTE_MATCHES + "</li>\n</ul></li></ul>\n<p>For more information, see the LDML spec.</p>";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        TablePrinter tablePrinter = new TablePrinter().addColumn("Version", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setSortPriority(0).setSortAscending(false).setBreakSpans(true).addColumn("Dtd Type", "class='source'", null, "class='source'", true).setSortPriority(1).addColumn("Intermediate Path", "class='source'", null, "class='target'", true).setSortPriority(2).addColumn("Element", "class='target'", null, "class='target'", true).setSpanRows(false).addColumn("Attributes", "class='target'", null, "class='target'", true).setSpanRows(false);
        String last = null;
        for (String current : ToolConstants.CHART_STATUS != ToolConstants.ChartStatus.release ? ToolConstants.CLDR_RELEASE_AND_DEV_VERSION_SET : ToolConstants.CLDR_RELEASE_VERSION_SET) {
            System.out.println("DTD delta: " + current);
            boolean finalVersion = current.equals("44");
            String currentName = finalVersion ? ToolConstants.CHART_DISPLAY_VERSION : current;
            for (DtdType type : TYPES) {
                String firstVersion = type.firstVersion;
                if (firstVersion != null && current != null && current.compareTo(firstVersion) < 0) continue;
                DtdData dtdCurrent = null;
                try {
                    dtdCurrent = DtdData.getInstance(type, finalVersion ? null : current);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof FileNotFoundException)) {
                        throw e;
                    }
                    System.out.println(e.getMessage() + ", " + e.getCause().getMessage());
                    continue;
                }
                DtdData dtdLast = null;
                if (last != null && (firstVersion == null || last.compareTo(firstVersion) >= 0)) {
                    dtdLast = DtdData.getInstance(type, last);
                }
                this.diff(currentName, dtdLast, dtdCurrent);
            }
            last = current;
            if (!current.contentEquals(ToolConstants.CHART_VERSION)) continue;
            break;
        }
        for (DiffElement datum : this.data) {
            tablePrinter.addRow().addCell((Comparable)((Object)datum.getVersionString())).addCell((Comparable)((Object)datum.dtdType)).addCell((Comparable)((Object)datum.newPath)).addCell((Comparable)((Object)datum.newElement)).addCell((Comparable)((Object)datum.attributeNames)).finishRow();
        }
        pw.write(tablePrinter.toTable());
        pw.write(Utility.repeat("<br>", 50));
        try (PrintWriter tsvFile = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "/tsv/", "dtd_deltas.tsv");){
            tablePrinter.toTsv(tsvFile);
        }
    }

    private void diff(String prefix, DtdData dtdLast, DtdData dtdCurrent) {
        Map<String, DtdData.Element> oldNameToElement = dtdLast == null ? Collections.emptyMap() : dtdLast.getElementFromName();
        this.checkNames(prefix, dtdCurrent, dtdLast, oldNameToElement, "/", dtdCurrent.ROOT, new HashSet<DtdData.Element>(), false);
    }

    private void checkNames(String version, DtdData dtdCurrent, DtdData dtdLast, Map<String, DtdData.Element> oldNameToElement, String path, DtdData.Element element, HashSet<DtdData.Element> seen, boolean showAnyway) {
        String name = element.getName();
        if (SKIP_ELEMENTS.contains(name)) {
            return;
        }
        if (SKIP_TYPE_ELEMENTS.containsEntry((Object)dtdCurrent.dtdType, name)) {
            return;
        }
        String newPath = path + "/" + element.name;
        if (seen.contains(element)) {
            if (showAnyway) {
                this.addData(dtdCurrent, NEW_PREFIX + name, version, newPath, OMITTED_ATTRIBUTES);
            }
            return;
        }
        seen.add(element);
        if (DEBUG_DTD == dtdCurrent.dtdType && name.contains(DEBUG_ELEMENT)) {
            boolean bl = false;
        }
        DtdData.Element oldElement = null;
        boolean ordered = element.isOrdered();
        boolean currentTechPreview = element.isTechPreview();
        if (!oldNameToElement.containsKey(name)) {
            Set<String> attributeNames = ChartDtdDelta.getAttributeNames(dtdCurrent, dtdLast, name, Collections.emptyMap(), element.getAttributes());
            String prefix = NEW_PREFIX + (currentTechPreview ? TECHPREVIEW_SIGN : "");
            this.addData(dtdCurrent, prefix + name + (ordered ? ORDERED_SIGN : ""), version, newPath, attributeNames);
        } else {
            String previewStatus;
            String orderingStatus;
            String deprecatedStatus;
            boolean lastTechPreview;
            oldElement = oldNameToElement.get(name);
            boolean oldOrdered = oldElement.isOrdered();
            Set<String> attributeNames = ChartDtdDelta.getAttributeNames(dtdCurrent, dtdLast, name, oldElement.getAttributes(), element.getAttributes());
            boolean currentDeprecated = element.isDeprecated();
            boolean lastDeprecated = dtdLast == null ? false : oldElement.isDeprecated();
            boolean bl = lastTechPreview = dtdLast == null ? false : oldElement.isTechPreview();
            String string = currentDeprecated == lastDeprecated ? "" : (deprecatedStatus = currentDeprecated ? DEPRECATED_PREFIX : UNDEPRECATED_PREFIX);
            String string2 = ordered == oldOrdered || currentDeprecated ? "" : (orderingStatus = ordered ? ORDERED_SIGN : UNORDERED_SIGN);
            String string3 = currentTechPreview == lastTechPreview || currentDeprecated ? "" : (previewStatus = currentTechPreview ? TECHPREVIEW_SIGN : UNTECHPREVIEW_SIGN);
            if (!(orderingStatus.isEmpty() && previewStatus.isEmpty() && deprecatedStatus.isEmpty() && attributeNames.isEmpty())) {
                this.addData(dtdCurrent, deprecatedStatus + previewStatus + name + orderingStatus, version, newPath, attributeNames);
            }
        }
        if (element.getName().equals("coordinateUnit")) {
            System.out.println(version + "\toordinateUnit\t" + element.getChildren().keySet());
        }
        Set<DtdData.Element> oldChildren = oldElement == null ? Collections.emptySet() : oldElement.getChildren().keySet();
        for (DtdData.Element child : element.getChildren().keySet()) {
            showAnyway = true;
            for (DtdData.Element oldChild : oldChildren) {
                if (!oldChild.getName().equals(child.getName())) continue;
                showAnyway = false;
                break;
            }
            this.checkNames(version, dtdCurrent, dtdLast, oldNameToElement, newPath, child, seen, showAnyway);
        }
    }

    private void addData(DtdData dtdCurrent, String element, String prefix, String newPath, Set<String> attributeNames) {
        DiffElement item = new DiffElement(dtdCurrent, prefix, newPath, element, attributeNames);
        this.data.add(item);
    }

    private static Set<String> getAttributeNames(DtdData dtdCurrent, DtdData dtdLast, String elementName, Map<DtdData.Attribute, Integer> attributesOld, Map<DtdData.Attribute, Integer> attributes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (elementName.equals("coordinateUnit")) {
            boolean bl = false;
        }
        for (DtdData.Attribute attribute : attributes.keySet()) {
            String name = attribute.getName();
            if (SKIP_ATTRIBUTES.contains(name)) continue;
            String match = attribute.getMatchString();
            DtdData.AttributeStatus status = attribute.attributeStatus;
            String display = NEW_PREFIX + name;
            String oldMatch = "?";
            DtdData.Attribute attributeOld = attribute.getMatchingName(attributesOld);
            if (attributeOld == null) {
                if (SKIP_ATTRIBUTE_MATCHES.containsEntry(name, match)) continue;
                display = NEW_PREFIX + name + "\u00a0" + DtdData.AttributeStatus.getShortName(status) + "\u00a0" + match;
            } else if (attribute.isDeprecated() && !attributeOld.isDeprecated()) {
                display = DEPRECATED_PREFIX + name;
            } else {
                Object post;
                Object pre;
                oldMatch = attributeOld.getMatchString();
                DtdData.AttributeStatus oldStatus = attributeOld.attributeStatus;
                boolean matchEquals = match.equals(oldMatch);
                if (status != oldStatus) {
                    pre = DtdData.AttributeStatus.getShortName(oldStatus);
                    post = DtdData.AttributeStatus.getShortName(status);
                    if (!matchEquals) {
                        pre = (String)pre + "\u00a0" + oldMatch;
                        post = (String)post + "\u00a0" + match;
                    }
                } else {
                    if (matchEquals || oldMatch.isEmpty() && SKIP_ATTRIBUTE_MATCHES.containsEntry(name, match)) continue;
                    pre = oldMatch;
                    post = match;
                }
                display = name + "\u00a0" + ChartDtdDelta.diff((String)pre, (String)post);
            }
            names.add(display);
        }
        return names;
    }

    public static String diff(String pre, String post) {
        Matcher matcherPre = DtdData.Attribute.LEAD_TRAIL.matcher((CharSequence)pre);
        Matcher matcherPost = DtdData.Attribute.LEAD_TRAIL.matcher((CharSequence)post);
        if (matcherPre.matches() && matcherPost.matches()) {
            List<String> preParts = SPLITTER_SPACE.splitToList(matcherPre.group(2));
            List<String> postParts = SPLITTER_SPACE.splitToList(matcherPost.group(2));
            pre = matcherPre.group(1) + ChartDtdDelta.remove(preParts, postParts) + matcherPre.group(3);
            post = matcherPost.group(1) + ChartDtdDelta.remove(postParts, preParts) + matcherPost.group(3);
        }
        return (String)pre + "\u27a0" + (String)post;
    }

    private static String remove(List<String> main, List<String> toRemove) {
        ArrayList<String> result = new ArrayList<String>();
        boolean removed = false;
        for (String s2 : main) {
            if (toRemove.contains(s2)) {
                removed = true;
                continue;
            }
            if (removed) {
                result.add("\u2026");
                removed = false;
            }
            result.add(s2);
        }
        if (removed) {
            result.add("\u2026");
        }
        return Joiner.on(NONE).join(result);
    }

    static {
        TYPES.remove((Object)DtdType.ldmlICU);
        FIRST_VERSION = new EnumMap<DtdType, String>(DtdType.class);
        FIRST_VERSION.put(DtdType.ldmlBCP47, "1.7.2");
        FIRST_VERSION.put(DtdType.keyboard3, "22.1");
        DEBUG_DTD = null;
        SKIP_ELEMENTS = ImmutableSet.of("generation", "identity", "special");
        SKIP_TYPE_ELEMENTS = ImmutableMultimap.of(DtdType.ldml, "alias");
        SKIP_ATTRIBUTES = ImmutableSet.of("references", "standard", "draft");
        SKIP_ATTRIBUTE_MATCHES = ImmutableMultimap.of("alt", "", "alt", "\u27ealiteral/variant\u27eb");
    }

    private static class DiffElement {
        private static final String START_ATTR = "<div>";
        private static final String END_ATTR = "</div>";
        final VersionInfo version;
        final DtdType dtdType;
        final boolean isBeta;
        final String newPath;
        final String newElement;
        final String attributeNames;

        public DiffElement(DtdData dtdCurrent, String version, String newPath, String newElement, Set<String> attributeNames2) {
            this.isBeta = version.endsWith("\u03b2");
            try {
                this.version = this.isBeta ? VersionInfo.getInstance(version.substring(0, version.length() - 1)) : VersionInfo.getInstance(version);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            this.dtdType = dtdCurrent.dtdType;
            this.newPath = this.fix(newPath);
            this.attributeNames = attributeNames2.isEmpty() ? ChartDtdDelta.NONE : START_ATTR + Joiner.on("</div><div>").join(attributeNames2) + END_ATTR;
            this.newElement = newElement;
        }

        private String fix(String substring) {
            int base = substring.indexOf(47, 2);
            if (base < 0) {
                return "";
            }
            int last = substring.lastIndexOf(47);
            if (last <= base) {
                return "/";
            }
            substring = substring.substring(base, last);
            return substring.replace("/", "\u200b/") + "/";
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("version", this.getVersionString()).add("dtdType", (Object)this.dtdType).add("newPath", this.newPath).add("newElement", this.newElement).add("attributeNames", this.attributeNames).toString();
        }

        private String getVersionString() {
            return this.version.getVersionString(2, 4) + (this.isBeta ? "\u03b2" : "");
        }
    }

    static enum DiffType {
        Element,
        Attribute,
        AttributeValue;

    }
}

