/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.StandardCodes;

public class ChartLanguageGroups
extends Chart {
    private static final String SHOULD_NOT_BE_LEAF_NODE = "\ud83c\udf42";
    private static final String LEAF_NODES = "\ud83c\udf43";
    private static final String TREE_NODES = "\ud83c\udf32";
    static final Set<String> COLLECTIONS;
    Collator ENGLISH_ORDER = Collator.getInstance(ULocale.ENGLISH);

    public static void main(String[] args) {
        new ChartLanguageGroups().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return FormattedFileWriter.CHART_TARGET_DIR;
    }

    @Override
    public String getTitle() {
        return "Language Groups";
    }

    @Override
    public String getExplanation() {
        return "<p>This chart shows draft language groups based on data extracted from wikidata. The <b>Status</b> cell indicates the nature of the items in the adjacent <b>Contained</b> cell:<p><ul>\n<li>A \ud83c\udf32 indicates that the contained languages are tree nodes (contain other languages or langauge groups), and will be listed further down in the chart in a <b>Language Group</b> cell.</li>\n<li>A \ud83c\udf43 indicates that the contained languages are leaf nodes (contain nothing).</li>\n<li>A \ud83c\udf42 before an item <i>in</i> a <b>Contained</b> cell indicates a leaf node that shouldn\u2019t be \u2014 that is, its ISO 639 Scope is <a href='http://www-01.sil.org/iso639-3/scope.asp#C' target='_blank'>Collection</a>.</li>\n</ul>\n<p><b>Caveats:</b> Only the wikidata containment for <a href='http://unicode.org/reports/tr35/#unicode_language_subtag'>valid language codes</a> is used.The containment data is not complete: if a language doesn't appear in the chart it could be an isolate, or just be missing data.The data doesn't completely match wikipedia\u2019s; there are some patches for CLDR languages.</p>\n";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        Multimap<String, String> lg = CLDRConfig.getInstance().getSupplementalDataInfo().getLanguageGroups();
        TablePrinter tablePrinter = new TablePrinter().addColumn("Language Group", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setBreakSpans(true).addColumn("Name", "class='source'", null, "class='source'", true).addColumn("St.", "class='source'", null, "class='source'", true).addColumn("Contained", "class='source'", null, "class='target'", true).setBreakSpans(true);
        this.show(lg, "mul", tablePrinter);
        pw.write(tablePrinter.toTable());
    }

    private void show(Multimap<String, String> lg, String parent, TablePrinter tablePrinter) {
        Collection<String> children = lg.get(parent);
        if (children == null || children.isEmpty()) {
            return;
        }
        TreeSet<Pair<String, String>> nameAndCode = new TreeSet<Pair<String, String>>(new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                int diff = ChartLanguageGroups.this.ENGLISH_ORDER.compare(o1.getFirst(), o2.getFirst());
                if (diff != 0) {
                    return diff;
                }
                return o1.getSecond().compareTo(o2.getSecond());
            }
        });
        for (String lang : children) {
            nameAndCode.add(Pair.of(this.getLangName(lang), lang));
        }
        StringBuilder treeList = new StringBuilder();
        StringBuilder leafList = new StringBuilder();
        LinkedHashSet<Pair<String, String>> nameAndCodeWithChildren = new LinkedHashSet<Pair<String, String>>();
        for (Pair<String, String> pair : nameAndCode) {
            String code = pair.getSecond();
            if (lg.containsKey(code)) {
                this.addChildren(treeList, TREE_NODES, pair, false);
                nameAndCodeWithChildren.add(pair);
                continue;
            }
            if (code.equals("und")) continue;
            this.addChildren(leafList, LEAF_NODES, pair, true);
        }
        if (treeList.length() != 0) {
            this.addRow(parent, tablePrinter, TREE_NODES, treeList);
        }
        if (leafList.length() != 0) {
            this.addRow(parent, tablePrinter, LEAF_NODES, leafList);
        }
        for (Pair<String, String> pair : nameAndCodeWithChildren) {
            this.show(lg, pair.getSecond(), tablePrinter);
        }
    }

    private void addRow(String parent, TablePrinter tablePrinter, String marker, StringBuilder treeList) {
        tablePrinter.addRow().addCell((Comparable)((Object)parent)).addCell((Comparable)((Object)this.getLangName(parent))).addCell((Comparable)((Object)marker)).addCell((Comparable)((Object)treeList.toString())).finishRow();
    }

    private void addChildren(StringBuilder treeList, String marker, Pair<String, String> pair, boolean showCollections) {
        if (treeList.length() != 0) {
            treeList.append("; ");
        }
        treeList.append(this.getPairName(pair, showCollections));
    }

    private String getPairName(Pair<String, String> pair, boolean showCollection) {
        return (showCollection && COLLECTIONS.contains(pair.getSecond()) ? "\ud83c\udf42\u00a0" : "") + pair.getSecond() + "\u00a0\u201c" + pair.getFirst() + "\u201d";
    }

    private String getLangName(String langCode) {
        return langCode.equals("mul") ? "All" : (langCode.equals("zh") ? "Mandarin Chinese" : ENGLISH.getName(0, langCode).replace(" (Other)", "").replace(" languages", ""));
    }

    static {
        Map<String, Map<StandardCodes.LstrField, String>> languages = StandardCodes.getEnumLstreg().get((Object)StandardCodes.LstrType.language);
        ImmutableSet.Builder _collections = ImmutableSet.builder();
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> e : languages.entrySet()) {
            String scope = e.getValue().get((Object)StandardCodes.LstrField.Scope);
            if (scope == null || !"Collection".equalsIgnoreCase(scope)) continue;
            _collections.add(e.getKey());
        }
        COLLECTIONS = _collections.build();
    }
}

