/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CheckEnglishCurrencyNames {
    static SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static StandardCodes sc = StandardCodes.make();
    static Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
    static CLDRFile english = cldrFactory.make("en", true);

    public static void main(String[] args) {
        String currency;
        Object name;
        Date now = new Date();
        Set<String> currencyCodes = sc.getGoodAvailableCodes("currency");
        Relation<String, String> currencyCodesWithDates = Relation.of(new TreeMap(), TreeSet.class);
        Relation<String, String> modernCurrencyCodes2territory = Relation.of(new TreeMap(), TreeSet.class);
        TreeSet<String> territoriesWithoutModernCurrencies = new TreeSet<String>(sc.getGoodAvailableCodes("territory"));
        for (String territory : sc.getGoodAvailableCodes("territory")) {
            if (supplementalDataInfo.getContained(territory) != null) {
                territoriesWithoutModernCurrencies.remove(territory);
                continue;
            }
            System.out.println(territory);
            Set<SupplementalDataInfo.CurrencyDateInfo> currencyInfo = supplementalDataInfo.getCurrencyDateInfo(territory);
            if (currencyInfo == null) {
                System.out.println("\tNONE");
                continue;
            }
            for (SupplementalDataInfo.CurrencyDateInfo currencyDateInfo : currencyInfo) {
                if (!currencyDateInfo.isLegalTender()) continue;
                String currency2 = currencyDateInfo.getCurrency();
                Date start = currencyDateInfo.getStart();
                Date end = currencyDateInfo.getEnd();
                if (end.compareTo(now) >= 0) {
                    modernCurrencyCodes2territory.put(currency2, territory);
                    territoriesWithoutModernCurrencies.remove(territory);
                } else {
                    currencyCodesWithDates.put(currency2, territory);
                }
                System.out.println("\t" + currency2 + "\t" + start + "\t" + end);
            }
        }
        System.out.println("Modern Codes: " + modernCurrencyCodes2territory);
        for (String currency3 : modernCurrencyCodes2territory.keySet()) {
            name = english.getName(4, currency3).toLowerCase();
            if (!((String)name).contains("new") && !((String)name).contains("old")) continue;
            System.out.println(currency3 + "\t" + (String)name);
        }
        System.out.println("Non-Modern Codes (with dates): " + currencyCodesWithDates);
        for (String currency2 : currencyCodesWithDates.keySet()) {
            name = english.getName(4, currency2).toLowerCase();
            if (!((String)name).contains("new") && !((String)name).contains("old")) continue;
            System.out.println(currency2 + "\t" + (String)name);
        }
        TreeSet<String> remainder = new TreeSet<String>();
        remainder.addAll(currencyCodes);
        remainder.removeAll(currencyCodesWithDates.keySet());
        System.out.println("Currencies without Territories: " + remainder);
        System.out.println("Territories without Modern Currencies: " + territoriesWithoutModernCurrencies);
        Relation<String, String> territory2official = Relation.of(new TreeMap(), TreeSet.class);
        for (String language : supplementalDataInfo.getLanguagesForTerritoriesPopulationData()) {
            for (String territory : supplementalDataInfo.getTerritoriesForPopulationData(language)) {
                SupplementalDataInfo.PopulationData populationData = supplementalDataInfo.getLanguageAndTerritoryPopulationData(language, territory);
                SupplementalDataInfo.OfficialStatus status = populationData.getOfficialStatus();
                switch (status) {
                    case official: 
                    case de_facto_official: 
                    case recognized: {
                        territory2official.put(territory, language);
                    }
                }
            }
        }
        Relation<String, String> currency2symbols = Relation.of(new TreeMap(), TreeSet.class);
        TreeMap<String, Relation<String, CallSite>> currency2symbol2locales = new TreeMap<String, Relation<String, CallSite>>();
        System.out.format("Raw usage data\n", new Object[0]);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry currencyAndTerritories : modernCurrencyCodes2territory.keyValuesSet()) {
            currency = (String)currencyAndTerritories.getKey();
            Set territories = currencyAndTerritories.getValue();
            for (String territory : territories) {
                Set languages = territory2official.get(territory);
                if (languages == null) {
                    treeSet.add(territory);
                    continue;
                }
                for (String language : languages) {
                    CLDRFile nativeLanguage = null;
                    String locale = language + "_" + territory;
                    try {
                        nativeLanguage = cldrFactory.make(locale, true);
                    }
                    catch (Exception e) {
                        try {
                            nativeLanguage = cldrFactory.make(language, true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String symbol = nativeLanguage == null ? "N/A" : nativeLanguage.getName(5, currency);
                    System.out.println(currency + "\t" + english.getName(4, currency) + "\t" + territory + "\t" + english.getName(2, territory) + "\t" + language + "\t" + english.getName(language) + "\t" + symbol);
                    if (nativeLanguage == null) continue;
                    currency2symbols.put(currency, symbol);
                    Relation<String, CallSite> rel = (Relation<String, CallSite>)currency2symbol2locales.get(currency);
                    if (rel == null) {
                        rel = Relation.of(new TreeMap(), TreeSet.class);
                        currency2symbol2locales.put(currency, rel);
                    }
                    rel.put(symbol, (CallSite)((Object)locale));
                }
            }
        }
        System.out.format("No official languages\n", new Object[0]);
        for (String territory : treeSet) {
            System.out.println(territory + "\t" + english.getName(2, territory));
        }
        System.out.format("Collected usage data\n", new Object[0]);
        for (Map.Entry currencyAndSymbols : currency2symbols.keyValuesSet()) {
            currency = (String)currencyAndSymbols.getKey();
            Set symbols = currencyAndSymbols.getValue();
            System.out.println(currency + "\t" + english.getName(4, currency) + "\t" + symbols.size() + "\t" + symbols + "\t" + currency2symbol2locales.get(currency));
        }
    }
}

