/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.io.PrintWriter;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.XMLFileReader;

public class CompareHanTransliterators {
    public static void main(String[] args) throws IOException {
        XMLFileReader reader = new XMLFileReader();
        MyContentHandler handler = new MyContentHandler();
        reader.setHandler(handler);
        reader.read(CLDRPaths.COMMON_DIRECTORY + "transforms/Han-Latin.xml", XMLFileReader.CONTENT_HANDLER, false);
        UnicodeMap<String> trunk = handler.map;
        handler.map = new UnicodeMap();
        reader.read(CLDRPaths.LAST_RELEASE_DIRECTORY + "/common/transforms/Han-Latin.xml", XMLFileReader.CONTENT_HANDLER, false);
        UnicodeMap<String> old = handler.map;
        UnicodeSet merged = new UnicodeSet(trunk.keySet()).addAll(old.keySet());
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "han-transliterator-diff.txt");
        for (String s2 : merged) {
            String trunkValue;
            String oldValue = old.get(s2);
            if (oldValue == null || CharSequences.equals(trunkValue = trunk.get(s2), oldValue)) continue;
            out.println(Utility.hex(s2) + "\t" + s2 + "\t" + oldValue + "\t" + trunkValue);
        }
        out.close();
    }

    public static class MyContentHandler
    extends XMLFileReader.SimpleHandler {
        UnicodeMap<String> map = new UnicodeMap();

        @Override
        public void handlePathValue(String path, String value) {
            if (!path.contains("tRule")) {
                return;
            }
            int pos = value.indexOf(8594);
            if (pos < 0) {
                return;
            }
            String source = value.substring(0, pos).trim();
            String target = value.substring(pos + 1).trim();
            if (UnicodeSet.resemblesPattern(source, 0)) {
                this.map.putAll(new UnicodeSet(source), target);
            } else if (UCharacter.codePointCount(source, 0, source.length()) == 1) {
                this.map.put(source, target);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
}

