/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Objects;
import com.ibm.icu.impl.Row;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CompareSuppress {
    public static void main(String[] args) {
        CLDRConfig config = CLDRConfig.getInstance();
        Map<StandardCodes.LstrType, Map<String, Map<StandardCodes.LstrField, String>>> lstr = StandardCodes.getEnumLstreg();
        Map<String, Map<StandardCodes.LstrField, String>> langData = lstr.get((Object)StandardCodes.LstrType.language);
        LanguageTagParser ltp = new LanguageTagParser();
        TreeMap<String, String> langToSuppress = new TreeMap<String, String>();
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> entry : langData.entrySet()) {
            String lang = entry.getKey();
            Map<StandardCodes.LstrField, String> value = entry.getValue();
            String string = value.get((Object)StandardCodes.LstrField.Suppress_Script);
            if (string == null) continue;
            langToSuppress.put(lang, string);
        }
        TreeSet langs = new TreeSet(langToSuppress.keySet());
        SupplementalDataInfo sdi = config.getSupplementalDataInfo();
        Map<String, String> likely = sdi.getLikelySubtags();
        for (Map.Entry entry : likely.entrySet()) {
            ltp.set((String)entry.getValue());
            langs.add(ltp.getLanguage());
        }
        LikelySubtags likelyMaker = new LikelySubtags(likely);
        CLDRFile cLDRFile = config.getEnglish();
        Map<String, Row.R2<List<String>, String>> langAlias = sdi.getLocaleAliasInfo().get("language");
        for (Status status : Status.values()) {
            for (String base : langs) {
                String prefix;
                String suppressScript = (String)langToSuppress.get(base);
                String likelyScript = null;
                String max = likelyMaker.maximize(base);
                if (max != null) {
                    ltp.set(max);
                    likelyScript = ltp.getScript();
                }
                String string = prefix = langAlias.containsKey(base) ? "(dep) " : "";
                if (Objects.equal(suppressScript, likelyScript)) continue;
                switch (status) {
                    case difference: {
                        if (likelyScript == null || suppressScript == null) break;
                        System.out.println(prefix + status + "\t" + CompareSuppress.langAndName(cLDRFile, base) + "\tSuppress:\t" + CompareSuppress.scriptAndName(cLDRFile, suppressScript) + "\tLikely:   \t" + CompareSuppress.scriptAndName(cLDRFile, likelyScript));
                        break;
                    }
                    case missingLikely: {
                        if (likelyScript != null) break;
                        System.out.println(prefix + status + "\t" + CompareSuppress.langAndName(cLDRFile, base) + "\t" + CompareSuppress.scriptAndName(cLDRFile, suppressScript));
                        break;
                    }
                    case missingSuppress: {
                        if (suppressScript != null) break;
                        System.out.println(prefix + status + "\t" + CompareSuppress.langAndName(cLDRFile, base) + "\t" + CompareSuppress.scriptAndName(cLDRFile, likelyScript));
                    }
                }
            }
            System.out.println();
        }
    }

    public static String langAndName(CLDRFile english, String base) {
        return base + "\t" + english.getName(base);
    }

    public static String scriptAndName(CLDRFile english, String suppressScript) {
        return suppressScript + "\t" + english.getName(1, suppressScript);
    }

    static enum Status {
        missingSuppress,
        missingLikely,
        difference;

    }
}

