/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Validity;

@CLDRTool(description="Generate additional likely subtag data, see CLDR-16380", url="https://unicode-org.atlassian.net/browse/CLDR-16380", alias="generate-additional-likely")
public class GenerateAdditionalLikely {
    private static final String SIL = "sil1";
    private static final boolean ADD_SEED_EXEMPLARS = false;
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final Splitter UNDERBAR = Splitter.on('_');
    private static final Splitter TAB_SPLITTER = Splitter.on('\t');
    private static final Factory factory = CLDR_CONFIG.getExemplarsFactory();
    private static final CLDRFile english = CLDR_CONFIG.getEnglish();
    private static final LanguageTagParser ltpFull = new LanguageTagParser();
    private static final LanguageTagParser ltpTag = new LanguageTagParser();
    private static final Validity validity = Validity.getInstance();
    private static final Set<String> LANGUAGE_REGULAR = validity.getStatusToCodes(StandardCodes.LstrType.language).get((Object)Validity.Status.regular);
    private static final Set<String> SCRIPT_REGULAR = validity.getStatusToCodes(StandardCodes.LstrType.script).get((Object)Validity.Status.regular);
    private static final Set<String> REGION_REGULAR = validity.getStatusToCodes(StandardCodes.LstrType.region).get((Object)Validity.Status.regular);
    private static final Set<String> LIKELY_SPECIALS = ImmutableSet.of("in", "iw", "ji", "jw", "mo");
    private static final Set<String> FIX_VALIDITY = ImmutableSet.of("Zanb");
    private static final Set<String> FIX_COUNTRY = ImmutableSet.of("yi");
    static Multimap<String, String> langToRegion;
    static ImmutableMap<String, String> remap;
    static final Pattern fullTagMatch;

    private static boolean isOk(String lang, String script, String region, Map<StandardCodes.LstrType, Validity.Status> errors) {
        errors.clear();
        if (!LIKELY_SPECIALS.contains(lang)) {
            GenerateAdditionalLikely.check(StandardCodes.LstrType.language, lang, errors);
        }
        if (!FIX_VALIDITY.contains(script)) {
            GenerateAdditionalLikely.check(StandardCodes.LstrType.script, script, errors);
        }
        if (!region.equals("001") || Iso639Data.getType(lang) != Iso639Data.Type.Constructed) {
            GenerateAdditionalLikely.check(StandardCodes.LstrType.region, region, errors);
        }
        return errors.isEmpty();
    }

    private static void check(StandardCodes.LstrType lstrType, String lang, Map<StandardCodes.LstrType, Validity.Status> errors) {
        Validity.Status status = validity.getCodeToStatus(lstrType).get(lang);
        if (status != Validity.Status.regular) {
            errors.put(lstrType, status);
        }
    }

    public static void main(String[] args) {
        LSRSource lsrs;
        String source;
        TreeMap<String, LSRSource> result = new TreeMap<String, LSRSource>();
        TreeMap errors = new TreeMap();
        Errors processErrors = new Errors();
        langToRegion = GenerateAdditionalLikely.readWikidata(LikelySources.getSources());
        GenerateAdditionalLikely.readJson(LikelySources.getSources(), result, processErrors);
        processErrors.printAll();
        System.out.println();
        LinkedHashMultimap<String, String> defects = LinkedHashMultimap.create();
        for (Map.Entry entry : result.entrySet()) {
            source = (String)entry.getKey();
            lsrs = (LSRSource)entry.getValue();
            String tagLang = ltpTag.set(source).getLanguage();
            if (result.containsKey(tagLang)) continue;
            defects.put(source, tagLang);
            GenerateAdditionalLikely.showError("Missing lang record", source, lsrs.toString(), "Needs\t" + tagLang);
        }
        System.out.println("\nData to add: " + (result.entrySet().size() - defects.size()) + "\n");
        for (Map.Entry entry : result.entrySet()) {
            source = (String)entry.getKey();
            if (defects.containsKey(source)) continue;
            lsrs = (LSRSource)entry.getValue();
            System.out.println("\t\t" + lsrs.line(source));
        }
    }

    private static void list(String string) {
        for (String code : string.split(" ")) {
            ltpFull.set(code.replace("-", "_"));
            String lang = ltpFull.getLanguage();
            String cldrLang = remap.get(lang);
            if (cldrLang != null) {
                lang = cldrLang;
            }
            System.out.println(code + "\t" + english.getName(code) + "\t" + Iso639Data.getType(lang) + "\t" + Iso639Data.getScope(lang));
        }
        System.out.println();
    }

    public static void showSkip(String message, String source, String target, Map<StandardCodes.LstrType, Validity.Status> errors) {
        GenerateAdditionalLikely.showError(message, source, target, GenerateAdditionalLikely.infoFields(target) + "\t" + errors);
    }

    public static void showError(String message, String source, String target, String errors) {
        System.out.println(message + "\t" + source + " \u27a1 " + target + (String)(errors.isEmpty() ? "" : "\t" + errors));
    }

    private static String infoFields(String value) {
        int under = value.indexOf(95);
        String lang = under < 0 ? value : value.substring(0, under);
        return english.getName(value) + "\t" + Iso639Data.getScope(lang) + "\t" + Iso639Data.getType(lang);
    }

    private static Map<String, LSRSource> readJson(Set<String> alreadyLangs, Map<String, LSRSource> result, Errors processErrors) {
        Path path = Paths.get(CLDRPaths.BIRTH_DATA_DIR, "/../external/langtags.json");
        Matcher full = fullTagMatch.matcher("");
        TreeMap errors = new TreeMap();
        Output lastFull = new Output();
        try {
            Files.lines(path).forEach(x -> {
                if (full.reset((CharSequence)x).matches()) {
                    String key = full.group(1);
                    String value = full.group(2).replace("-", "_");
                    if (value.startsWith("aai")) {
                        boolean bl = false;
                    }
                    switch (key) {
                        case "full": {
                            lastFull.value = value;
                            break;
                        }
                        case "tag": {
                            try {
                                Collection<String> tempRegions;
                                String fullLang = ltpFull.set((String)lastFull.value).getLanguage();
                                if (alreadyLangs.contains(fullLang)) {
                                    processErrors.put(Errors.Type.already_CLDR, value, (String)lastFull.value, "");
                                    break;
                                }
                                if (GenerateAdditionalLikely.isIllFormed((String)lastFull.value, ltpFull) || GenerateAdditionalLikely.isIllFormed(value, ltpTag.set(value))) {
                                    processErrors.put(Errors.Type.ill_formed_tags, value, (String)lastFull.value, "");
                                    break;
                                }
                                Object reference = SIL;
                                String fullScript = ltpFull.getScript();
                                String fullRegion = ltpFull.getRegion();
                                if ((fullRegion.equals("ZZ") || fullRegion.equals("001")) && !(tempRegions = langToRegion.get(fullLang)).isEmpty()) {
                                    fullRegion = tempRegions.iterator().next();
                                    reference = (String)reference + " wikidata";
                                }
                                String tagLang = ltpTag.getLanguage();
                                String tagScript = ltpTag.getScript();
                                String tagRegion = ltpTag.getRegion();
                                if (!tagLang.equals(fullLang) || !tagScript.isEmpty() && !tagScript.equals(fullScript) || !tagRegion.isEmpty() && !tagRegion.equals(fullRegion)) {
                                    processErrors.put(Errors.Type.tag_not_in_full, value, (String)lastFull.value, "");
                                    break;
                                }
                                GenerateAdditionalLikely.addIfOk(result, value, fullLang, fullScript, fullRegion, (String)reference, errors);
                            }
                            catch (Exception e) {
                                processErrors.put(Errors.Type.exception, value, (String)lastFull.value, e.getMessage());
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            });
            return result;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static boolean isIllFormed(String source, LanguageTagParser languageTagParser) {
        return languageTagParser.getLanguage().isEmpty() || !languageTagParser.getVariants().isEmpty() || !languageTagParser.getExtensions().isEmpty() || !languageTagParser.getLocaleExtensions().isEmpty() || source.contains("@");
    }

    private static void addIfOk(Map<String, LSRSource> result, String source, String lang, String script, String region, String reference, Map<StandardCodes.LstrType, Validity.Status> errors) {
        if (GenerateAdditionalLikely.isOk(lang, script, region, errors)) {
            GenerateAdditionalLikely.add(result, source, lang, script, region, reference);
        } else {
            GenerateAdditionalLikely.showSkip("Skipping scope, SIL", source, ltpFull.toString(), errors);
        }
    }

    private static Multimap<String, String> readWikidata(Set<String> alreadyLangs) {
        TreeMultimap<String, String> result = TreeMultimap.create();
        Path path = Paths.get(CLDRPaths.BIRTH_DATA_DIR, "/../external/wididata_lang_region.tsv");
        try {
            Files.lines(path).forEach(x -> {
                if (!x.startsWith("#")) {
                    List<String> list = TAB_SPLITTER.splitToList((CharSequence)x);
                    String lang = list.get(1);
                    String region = list.get(3);
                    result.put(lang, region);
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return result;
    }

    private static void add(Map<String, LSRSource> result, String source, String lang, String script, String region, String reference) {
        LSRSource old = result.get(source);
        LSRSource newVersion = new LSRSource(lang, script, region, reference);
        if (old != null && !old.equals(newVersion)) {
            throw new IllegalArgumentException("Data already exists for " + source + ": old=" + old + ", new: " + newVersion);
        }
        result.put(source, newVersion);
    }

    private static String getScript(UnicodeSet exemplars) {
        for (String s2 : exemplars) {
            int scriptNum = UScript.getScript(s2.codePointAt(0));
            if (scriptNum == 0 || scriptNum == 1) continue;
            return UScript.getShortName(scriptNum);
        }
        return "Zxxx";
    }

    static {
        remap = ImmutableMap.of("iw", "he", "jw", "jv");
        fullTagMatch = Pattern.compile("\\s*\"(full|tag)\": \"([^\"]+)\",");
    }

    private static class Errors {
        public Multimap<Type, String> data = TreeMultimap.create();

        private Errors() {
        }

        public void put(Type illFormedTags, String tagValue, String fullValue, String errorMessage) {
            this.data.put(illFormedTags, tagValue + " \u27a1 " + fullValue + (String)(errorMessage == null || errorMessage.isEmpty() ? "" : "\t\u2014\t" + errorMessage));
        }

        public void printAll() {
            for (Map.Entry<Type, Collection<String>> entry : this.data.asMap().entrySet()) {
                Type type = entry.getKey();
                System.out.println();
                for (String message : entry.getValue()) {
                    System.out.println(type + "\t" + message);
                }
            }
        }

        public static enum Type {
            ill_formed_tags("Ill-formed tags"),
            already_CLDR("Language already in CLDR"),
            tag_not_in_full("tag \u2284 full"),
            exception("exception");

            private final String printable;

            private Type(String printable) {
                this.printable = printable;
            }
        }
    }

    private static class LikelySources {
        private static LikelySources SINGLETON = new LikelySources();
        final ImmutableSet<String> alreadyLangs;

        public static Set<String> getSources() {
            return LikelySources.SINGLETON.alreadyLangs;
        }

        private LikelySources() {
            TreeMap errors = new TreeMap();
            Map<String, String> likely = CLDR_CONFIG.getSupplementalDataInfo().getLikelySubtags();
            TreeSet<String> _alreadyLangs = new TreeSet<String>();
            _alreadyLangs.add("und");
            likely.forEach((key, value) -> {
                String lang = ltpFull.set((String)value).getLanguage();
                String script = ltpFull.set((String)value).getScript();
                String region = ltpFull.set((String)value).getRegion();
                _alreadyLangs.add(lang);
                if (!GenerateAdditionalLikely.isOk(lang, script, region, errors)) {
                    GenerateAdditionalLikely.showSkip("Skipping scope, CLDR", key, value, errors);
                }
            });
            System.out.println();
            this.alreadyLangs = ImmutableSet.copyOf(_alreadyLangs);
        }
    }

    static class LSRSource
    implements Comparable<LSRSource> {
        final Row.R4<String, String, String, String> data;

        LSRSource(String lang, String script, String region, String source) {
            if (script.contains("Soyo") || region.contains("Soyo")) {
                boolean bl = false;
            }
            this.data = Row.of(lang, script, region, source);
            this.data.freeze();
        }

        public String toString() {
            return LSRSource.combineLSR((String)this.data.get0(), (String)this.data.get1(), (String)this.data.get2()) + " // " + (String)this.data.get3();
        }

        @Override
        public int compareTo(LSRSource o) {
            return this.data.compareTo(o.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object obj) {
            return this.data.equals(obj);
        }

        public String line(String source) {
            String target = LSRSource.combineLSR((String)this.data.get0(), (String)this.data.get1(), (String)this.data.get2());
            String origin = (String)this.data.get3();
            String result = "<likelySubtag from=\"" + source + "\" to=\"" + target + (String)(origin.isBlank() ? "" : "\" origin=\"" + origin) + "\"/>\t<!-- " + english.getName(source) + " \u27a1\ufe0e " + english.getName(target) + " -->";
            return result;
        }

        public static String combineLSR(String lang, String script, String region) {
            return lang + (String)(script.isEmpty() ? "" : "_" + script) + (String)(region.isEmpty() ? "" : "_" + region);
        }
    }
}

