/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.UnicodeSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateAliases {
    public static void main(String[] args) {
        new Builder().getAliases();
    }

    static class Builder {
        Map<String, String> aliasMap = new LinkedHashMap<String, String>();
        Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        SupplementalDataInfo dataInfo = SupplementalDataInfo.getInstance();
        Set<String> defaultContents = this.dataInfo.getDefaultContentLocales();
        LikelySubtags likelySubtags = new LikelySubtags();
        Map<String, Map<String, Row.R2<List<String>, String>>> aliasInfo = this.dataInfo.getLocaleAliasInfo();
        Relation<String, String> goodToBadLanguages = this.getGoodToBad(this.aliasInfo, "language");
        Relation<String, String> goodToBadTerritories = this.getGoodToBad(this.aliasInfo, "territory");
        Relation<String, String> goodToBadScripts = this.getGoodToBad(this.aliasInfo, "script");
        LanguageTagParser ltp = new LanguageTagParser();
        final Set<String> available = this.factory.getAvailable();
        static final Set<String> HAS_MULTIPLE_SCRIPTS = org.unicode.cldr.util.Builder.with(new HashSet()).addAll("ha", "ku", "zh", "sr", "uz", "sh").freeze();
        static final UnicodeSet NUMBERS = new UnicodeSet("[0-9]");
        Map<String, Boolean> wholeAliasCache = new HashMap<String, Boolean>();

        /*
         * WARNING - void declaration
         */
        Builder() {
            for (String localeID : this.available) {
                void var3_3;
                String string = this.getDefaultContents(localeID);
                if (string == null) {
                    String string2 = localeID;
                }
                this.addAlias("deprecated", localeID, (String)var3_3);
                if (!localeID.startsWith("sr_Latn")) continue;
                this.addAlias("deprecated", "sh" + localeID.substring(7), localeID);
            }
            TreeMap<String, String> likely = new TreeMap<String, String>();
            for (String string : this.likelySubtags.getToMaximized().values()) {
                likely.put(string, this.getDefaultContents(string));
                this.ltp.set(string);
                this.ltp.setScript("");
                this.addToLikely(likely);
                this.ltp.set(string);
                this.ltp.setRegion("");
                this.addToLikely(likely);
                this.ltp.setScript("");
                this.addToLikely(likely);
            }
            for (Map.Entry entry : likely.entrySet()) {
                String base;
                String targetID;
                String localeID = (String)entry.getKey();
                if (localeID.equals(targetID = (String)entry.getValue()) || !this.available.contains(base = this.ltp.set(localeID).getLanguage()) || this.available.contains(localeID) && !this.isWholeAlias(this.factory, localeID)) continue;
                targetID = this.getDefaultContents(targetID);
                this.addAlias("default", localeID, targetID);
            }
            for (String string : this.available) {
                if (this.aliasMap.get(string) != null || !this.isWholeAlias(this.factory, string)) continue;
                System.out.println("missing\t" + string);
            }
        }

        private void addToLikely(Map<String, String> likely) {
            String parent;
            String partial = this.ltp.toString();
            String target = this.getDefaultContents(partial);
            if (target.equals(parent = LocaleIDParser.getSimpleParent(partial))) {
                return;
            }
            likely.put(partial, target);
        }

        private boolean hasMultipleScripts(String localeID) {
            LanguageTagParser ltp = new LanguageTagParser().set(localeID);
            return HAS_MULTIPLE_SCRIPTS.contains(ltp.getLanguage());
        }

        private String getDefaultContents(String localeID) {
            String parent;
            String targetID;
            String string = targetID = this.hasMultipleScripts(localeID) ? this.likelySubtags.maximize(localeID) : this.likelySubtags.minimize(localeID);
            if (targetID == null) {
                System.out.println("missingLikely\t" + localeID);
                return localeID;
            }
            while (this.defaultContents.contains(targetID) && (parent = LocaleIDParser.getSimpleParent(targetID)) != null && !parent.equals("root)")) {
                targetID = parent;
            }
            return targetID;
        }

        public Map<String, String> getAliases() {
            return this.aliasMap;
        }

        private Relation<String, String> getGoodToBad(Map<String, Map<String, Row.R2<List<String>, String>>> aliasInfo, String tag) {
            Relation<String, String> result = Relation.of(new TreeMap(), TreeSet.class);
            Map<String, Row.R2<List<String>, String>> map = aliasInfo.get(tag);
            for (Map.Entry<String, Row.R2<List<String>, String>> entity : map.entrySet()) {
                String key = entity.getKey();
                Row.R2<List<String>, String> listAndReason = entity.getValue();
                List list = (List)listAndReason.get0();
                String reason = (String)listAndReason.get1();
                if (reason.equals("overlong") || list == null || NUMBERS.containsAll(key)) continue;
                result.put((String)list.iterator().next(), key);
            }
            return result;
        }

        private void addAlias(String title, String localeID, String targetID) {
            this.ltp.set(localeID);
            Set<String> languages = this.addExtras(this.ltp.getLanguage(), this.goodToBadLanguages);
            Set<String> scripts = this.addExtras(this.ltp.getScript(), this.goodToBadScripts);
            Set<String> territories = this.addExtras(this.ltp.getRegion(), this.goodToBadTerritories);
            for (String language : languages) {
                try {
                    this.ltp.set(language);
                }
                catch (Exception e) {
                    continue;
                }
                if (!this.ltp.getVariants().isEmpty()) continue;
                for (String script : scripts) {
                    this.ltp.setScript(script);
                    for (String territory : territories) {
                        this.ltp.setRegion(territory);
                        String newTag = this.ltp.toString().replace('-', '_');
                        if (newTag.equals(targetID)) continue;
                        String old = this.aliasMap.get(newTag);
                        if (old != null) {
                            if (old.equals(targetID)) continue;
                            System.out.println(newTag + "\t\u2192\t" + targetID + "\tconflict with\t" + old);
                            continue;
                        }
                        boolean wholeAlias = this.isWholeAlias(this.factory, newTag);
                        if (this.available.contains(newTag) && !wholeAlias) continue;
                        System.out.println(title + "\t" + newTag + "\t\u2192\t" + targetID + (wholeAlias ? "\talias-already" : ""));
                        this.aliasMap.put(newTag, targetID);
                    }
                }
            }
        }

        private Set<String> addExtras(String language, Relation<String, String> goodToBadLanguages) {
            TreeSet<String> languages = new TreeSet<String>();
            languages.add(language);
            Set<String> badLanguages = goodToBadLanguages.get(language);
            if (badLanguages != null) {
                languages.addAll(badLanguages);
            }
            return languages;
        }

        private boolean isWholeAlias(Factory factory, String localeID) {
            CLDRFile cldrFile;
            Boolean result = this.wholeAliasCache.get(localeID);
            if (result != null) {
                return result;
            }
            try {
                cldrFile = factory.make(localeID, false);
            }
            catch (Exception e) {
                this.wholeAliasCache.put(localeID, false);
                return false;
            }
            for (String path : cldrFile) {
                if (path.startsWith("//ldml/identity")) continue;
                if (path.startsWith("//ldml/alias")) {
                    this.wholeAliasCache.put(localeID, true);
                    return true;
                }
                this.wholeAliasCache.put(localeID, false);
                return false;
            }
            this.wholeAliasCache.put(localeID, false);
            return false;
        }
    }
}

