/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.Transform;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class GenerateCoverageLevels {
    private static boolean SKIP_UNCONFIRMED = true;
    private static int SHOW_EXAMPLES = 5;
    private static final String FILES = ".*";
    private static final String MAIN_DIRECTORY = CLDRPaths.MAIN_DIRECTORY;
    private static final String COLLATION_DIRECTORY = CLDRPaths.COMMON_DIRECTORY + "/collation/";
    private static final String RBNF_DIRECTORY = CLDRPaths.COMMON_DIRECTORY + "/rbnf/";
    private static final String OUT_DIRECTORY = CLDRPaths.GEN_DIRECTORY + "/coverage/";
    private static final Factory cldrFactory = Factory.make(MAIN_DIRECTORY, ".*");
    private static final Comparator<String> attributeComparator = CLDRFile.getAttributeOrdering();
    private static final CLDRFile english = cldrFactory.make("en", true);
    private static SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
    private static Set<String> defaultContents = supplementalData.getDefaultContentLocales();
    private static Map<String, Row.R2<List<String>, String>> languageAliasInfo = supplementalData.getLocaleAliasInfo().get("language");
    private static LocaleFilter localeFilter = new LocaleFilter(true);
    private static BooleanLocaleFilter nonAliasLocaleFilter = new BooleanLocaleFilter();
    private static final long COLLATION_WEIGHT = 50L;
    private static final Level COLLATION_LEVEL = Level.POSIX;
    private static final long PLURALS_WEIGHT = 20L;
    private static final Level PLURALS_LEVEL = Level.MINIMAL;
    private static final long RBNF_WEIGHT = 20L;
    private static final Level RBNF_LEVEL = Level.MODERATE;
    static int totalCount = 0;

    public static void main(String[] args) throws IOException {
        throw new IllegalArgumentException("See ShowLocaleCoverage (TODO: merge these).");
    }

    private static void showEnglish(PrintWriter out) throws IOException {
        CLDRFile cldrFile = english;
        String locale = "en";
        Set sorted = Builder.with(new TreeSet()).addAll(cldrFile.iterator()).addAll((Iterable<String>)cldrFile.getExtraPaths()).get();
        TreeSet<Row.R3<Level, String, Inheritance>> items = new TreeSet<Row.R3<Level, String, Inheritance>>(new RowComparator());
        for (String path : sorted) {
            if (path.endsWith("/alias")) continue;
            String string = cldrFile.getSourceLocaleID(path, null);
            Inheritance inherited = !string.equals(locale) ? Inheritance.inherited : Inheritance.actual;
            Level level = CLDRConfig.getInstance().getCoverageInfo().getCoverageLevel(path, locale);
            items.add(Row.of(level, path, inherited));
        }
        PathStore store = new PathStore();
        for (Row.R3 r3 : items) {
            GenerateCoverageLevels.show(out, r3, store);
        }
        GenerateCoverageLevels.show(out, null, store);
    }

    private static void show(PrintWriter out, Row.R3<Level, String, Inheritance> next, PathStore store) {
        Row.R5<Level, Inheritance, Integer, String, TreeMap<String, Relation<String, String>>> results = store.add(next);
        if (results != null) {
            Level lastLevel = (Level)((Object)results.get0());
            int count = (Integer)results.get2();
            String path = (String)results.get3();
            totalCount += count;
            StringBuilder resultString = new StringBuilder();
            TreeMap types = (TreeMap)results.get4();
            for (String key : types.keySet()) {
                Relation attr_values = (Relation)types.get(key);
                for (String attr : attr_values.keySet()) {
                    resultString.append("\t").append(key + ":\u200b" + attr).append("=\u200b").append(attr_values.getAll(attr));
                }
            }
            out.println(lastLevel.ordinal() + "\t" + lastLevel + "\t" + count + "\t" + totalCount + "\t" + path + resultString);
        }
    }

    private static void summarizeCoverage(PrintWriter summary, PrintWriter samples2, PrintWriter counts) {
        Factory cldrFactory = Factory.make(MAIN_DIRECTORY, FILES);
        Factory collationFactory = Factory.make(COLLATION_DIRECTORY, FILES);
        Factory rbnfFactory = Factory.make(RBNF_DIRECTORY, FILES);
        NumberFormat percent = NumberFormat.getPercentInstance();
        NumberFormat decimal = NumberFormat.getInstance();
        decimal.setGroupingUsed(true);
        decimal.setMaximumFractionDigits(2);
        percent.setMaximumFractionDigits(2);
        NumberFormat integer = NumberFormat.getIntegerInstance();
        TreeSet<String> localesFound = new TreeSet<String>();
        LocaleLevelData mapLevelData = new LocaleLevelData();
        TreeSet<String> mainAvailableSource = new TreeSet<String>(cldrFactory.getAvailable());
        TreeSet<String> mainAvailable = new TreeSet<String>();
        Relation<String, String> localeToVariants = Relation.of(new HashMap(), HashSet.class);
        for (String locale : mainAvailableSource) {
            if (localeFilter.skipLocale(locale, localeToVariants)) continue;
            mainAvailable.add(locale);
        }
        System.out.println("gathering rbnf data");
        TreeSet<String> ordinals = new TreeSet<String>();
        TreeSet<String> spellout = new TreeSet<String>();
        localesFound.clear();
        for (String locale : rbnfFactory.getAvailable()) {
            if (localeFilter.skipLocale(locale, null)) continue;
            System.out.println(locale + "\t" + english.getName(locale));
            GenerateCoverageLevels.getRBNFData(locale, rbnfFactory.make(locale, true), ordinals, spellout, localesFound);
        }
        GenerateCoverageLevels.markData("RBNF-Ordinals", ordinals, mapLevelData, mainAvailable, RBNF_LEVEL, 20L, Row.of("//ldml/rbnf/ordinals", "?"));
        GenerateCoverageLevels.markData("RBNF-Spellout", spellout, mapLevelData, mainAvailable, RBNF_LEVEL, 20L, Row.of("//ldml/rbnf/spellout", "?"));
        if (localesFound.size() != 0) {
            System.out.println("Other rbnf found:\t" + localesFound);
        }
        System.out.println("gathering plural data");
        localesFound = new TreeSet<String>(supplementalData.getPluralLocales(SupplementalDataInfo.PluralType.cardinal));
        GenerateCoverageLevels.markData("Plurals", localesFound, mapLevelData, mainAvailable, PLURALS_LEVEL, 20L, Row.of("//supplementalData/plurals", "UCA"));
        System.out.println("gathering collation data");
        localesFound.clear();
        for (String locale : collationFactory.getAvailable()) {
            if (localeFilter.skipLocale(locale, null)) continue;
            System.out.println(locale + "\t" + english.getName(locale));
            GenerateCoverageLevels.getCollationData(locale, collationFactory.make(locale, true), localesFound);
        }
        GenerateCoverageLevels.markData("Collation", localesFound, mapLevelData, mainAvailable, COLLATION_LEVEL, 50L, Row.of("//ldml/collations", "UCA"));
        System.out.println("gathering main data");
        for (String locale : mainAvailable) {
            System.out.println(locale + "\t" + english.getName(locale));
            LevelData levelData = mapLevelData.get(locale);
            GenerateCoverageLevels.getMainData(locale, levelData, cldrFactory.make(locale, true));
        }
        System.out.println("printing data");
        String summaryLineHeader = "Code\tName\tWeighted Missing:\tFound:\tScore:";
        summary.println(summaryLineHeader);
        LanguageTagParser languageTagParser = new LanguageTagParser();
        StringBuilder header = new StringBuilder();
        for (String locale : mapLevelData.keySet()) {
            LevelData levelData = mapLevelData.get(locale);
            String max = LikelySubtags.maximize(locale, supplementalData.getLikelySubtags());
            String lang = languageTagParser.set(max).getLanguage();
            String script = languageTagParser.set(max).getScript();
            Counter<Level> missing = levelData.missing;
            Counter<Level> found = levelData.found;
            Relation<Level, Row.R2<String, String>> samples = levelData.samples;
            StringBuilder countLine = new StringBuilder(script + "\t" + english.getName(1, script) + "\t" + lang + "\t" + english.getName(0, lang));
            if (header != null) {
                header.append("Code\tScript\tCode\tLocale");
            }
            samples2.println();
            samples2.println(locale + "\t" + english.getName(locale));
            double weightedFound = 0.0;
            double weightedMissing = 0.0;
            long missingCountTotal = 0L;
            long foundCountTotal = 0L;
            for (Level level : Level.values()) {
                if (level == Level.UNDETERMINED) continue;
                long missingCount = missing.get(level);
                long foundCount = found.get(level);
                weightedFound += (double)(foundCount * (long)level.getValue());
                weightedMissing += (double)(missingCount * (long)level.getValue());
                countLine.append('\t').append(missingCountTotal += missingCount).append('\t').append(foundCountTotal += foundCount);
                if (header != null) {
                    header.append("\t" + level + "-Missing\tFound");
                }
                samples2.println(level + "\tMissing:\t" + integer.format(missingCount) + "\tFound:\t" + integer.format(foundCount) + "\tScore:\t" + percent.format((double)foundCount / (double)(foundCount + missingCount)) + "\tLevel-Value:\t" + level.getValue());
                Set<Row.R2<String, String>> samplesAlready = samples.getAll((Object)level);
                if (samplesAlready == null) continue;
                for (Row.R2<String, String> row : samplesAlready) {
                    samples2.println("\t" + row);
                }
                if (samplesAlready.size() < SHOW_EXAMPLES) continue;
                samples2.println("\t...");
            }
            int base = Level.POSIX.getValue();
            double foundCount = weightedFound / (double)base;
            double missingCount = weightedMissing / (double)base;
            String summaryLine = "Weighted Missing:\t" + decimal.format(missingCount) + "\tFound:\t" + decimal.format(foundCount) + "\tScore:\t" + percent.format(foundCount / (foundCount + missingCount));
            String summaryLine2 = "\t" + decimal.format(missingCount) + "\t" + decimal.format(foundCount) + "\t" + percent.format(foundCount / (foundCount + missingCount));
            samples2.println(summaryLine);
            summary.println(locale + "\t" + english.getName(locale) + "\t" + summaryLine2);
            if (header != null) {
                counts.println(header);
                header = null;
            }
            counts.println(countLine);
        }
    }

    private static void getRBNFData(String locale, CLDRFile cldrFile, Set<String> ordinals, Set<String> spellout, Set<String> others) {
        for (String path : cldrFile) {
            if (path.endsWith("/alias") || !path.contains("rulesetGrouping") || GenerateCoverageLevels.skipUnconfirmed(path)) continue;
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String ruleSetGrouping = parts.getAttributeValue(2, "type");
            if (ruleSetGrouping.equals("SpelloutRules")) {
                spellout.add(locale);
                continue;
            }
            if (ruleSetGrouping.equals("OrdinalRules")) {
                ordinals.add(locale);
                continue;
            }
            others.add(ruleSetGrouping);
        }
    }

    private static void markData(String title, Set<String> localesFound, LocaleLevelData mapLevelData, TreeSet<String> mainAvailable, Level level, long weight, Row.R2<String, String> samples) {
        if (!mainAvailable.containsAll(localesFound)) {
            Builder.CBuilder<String, TreeSet<String>> cb = Builder.with(new TreeSet());
            System.out.println(title + " Locales that are not in main: " + cb.addAll((Iterable<String>)localesFound).removeAll((Collection<String>)mainAvailable).filter(nonAliasLocaleFilter).get());
        }
        for (String locale : mainAvailable) {
            if (localesFound.contains(locale)) {
                mapLevelData.get((String)locale).found.add(level, weight);
                continue;
            }
            System.out.println(locale + "\t" + english.getName(locale) + "\tmissing " + title);
            mapLevelData.get((String)locale).missing.add(level, weight);
            mapLevelData.get((String)locale).samples.put(level, samples);
        }
    }

    private static void getCollationData(String locale, CLDRFile cldrFile, Set<String> localesFound) {
        for (String path : cldrFile) {
            String[] sublocales;
            XPathParts parts;
            String validSubLocales;
            if (path.endsWith("/alias") || !path.contains("collations") || GenerateCoverageLevels.skipUnconfirmed(path)) continue;
            localesFound.add(locale);
            String fullPath = cldrFile.getFullXPath(path);
            if (fullPath == null) {
                fullPath = path;
            }
            if ((validSubLocales = (parts = XPathParts.getFrozenInstance(fullPath)).getAttributeValue(1, "validSubLocales")) == null) break;
            for (String sublocale : sublocales = validSubLocales.split("\\s+")) {
                if (localeFilter.skipLocale(locale, null)) continue;
                localesFound.add(sublocale);
            }
        }
    }

    public static boolean skipUnconfirmed(String path) {
        return SKIP_UNCONFIRMED && (path.contains("unconfirmed") || path.contains("provisional"));
    }

    private static void getMainData(String locale, LevelData levelData, CLDRFile cldrFile) {
        CLDRFile.Status status = new CLDRFile.Status();
        Set sorted = Builder.with(new TreeSet()).addAll(cldrFile.iterator()).addAll((Iterable<String>)cldrFile.getExtraPaths()).get();
        CoverageInfo coverageInfo = CLDRConfig.getInstance().getCoverageInfo();
        for (String path : sorted) {
            Set<Row.R2<String, String>> samplesAlready;
            if (path.endsWith("/alias")) continue;
            String fullPath = cldrFile.getFullXPath(path);
            String source = cldrFile.getSourceLocaleID(path, status);
            Inheritance inherited = !source.equals(locale) || GenerateCoverageLevels.skipUnconfirmed(path) ? Inheritance.inherited : Inheritance.actual;
            Level level = coverageInfo.getCoverageLevel(fullPath, locale);
            if (inherited == Inheritance.actual) {
                levelData.found.add(level, 1L);
                continue;
            }
            levelData.missing.add(level, 1L);
            if (SHOW_EXAMPLES <= 0 || (samplesAlready = levelData.samples.getAll((Object)level)) != null && samplesAlready.size() >= SHOW_EXAMPLES) continue;
            levelData.samples.put(level, Row.of(path, cldrFile.getStringValue(path)));
        }
    }

    static class LocaleLevelData {
        Map<String, LevelData> locale_levelData = new TreeMap<String, LevelData>();

        LocaleLevelData() {
        }

        public LevelData get(String locale) {
            if (locale.equals("zh_Hans") || locale.equals("iw")) {
                throw new IllegalArgumentException();
            }
            LevelData result = this.locale_levelData.get(locale);
            if (result == null) {
                result = new LevelData();
                this.locale_levelData.put(locale, result);
            }
            return result;
        }

        public Set<String> keySet() {
            return this.locale_levelData.keySet();
        }
    }

    static class LevelData {
        Counter<Level> missing = new Counter();
        Relation<Level, Row.R2<String, String>> samples = Relation.of(new EnumMap(Level.class), LinkedHashSet.class);
        Counter<Level> found = new Counter();

        LevelData() {
        }
    }

    private static class BooleanLocaleFilter
    implements Transform<String, Boolean> {
        private final LocaleFilter filter = new LocaleFilter(false);

        private BooleanLocaleFilter() {
        }

        @Override
        public Boolean transform(String locale) {
            return this.filter.transform(locale) == LocaleStatus.BASE ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class LocaleFilter
    implements Transform<String, LocaleStatus> {
        private final LanguageTagParser ltp = new LanguageTagParser();
        private final boolean checkAliases;

        public LocaleFilter(boolean checkAliases) {
            this.checkAliases = checkAliases;
        }

        private boolean skipLocale(String locale, Relation<String, String> localeToVariants) {
            LocaleStatus result = this.transform(locale);
            if (localeToVariants != null) {
                localeToVariants.put(this.ltp.getLanguageScript(), this.ltp.getRegion());
            }
            return result != LocaleStatus.BASE;
        }

        @Override
        public LocaleStatus transform(String locale) {
            String language;
            this.ltp.set(locale);
            if (this.checkAliases && languageAliasInfo.get(language = this.ltp.getLanguage()) != null) {
                return LocaleStatus.ALIAS;
            }
            if (this.ltp.getRegion().length() != 0 || !this.ltp.getVariants().isEmpty()) {
                return LocaleStatus.VARIANT;
            }
            if (defaultContents.contains(locale)) {
                return LocaleStatus.DEFAULT_CONTENTS;
            }
            return LocaleStatus.BASE;
        }
    }

    static enum LocaleStatus {
        BASE,
        ALIAS,
        VARIANT,
        DEFAULT_CONTENTS;

    }

    static class PathStore {
        XPathParts lastParts = new XPathParts();
        XPathParts nextParts = new XPathParts();
        Level lastLevel;
        Inheritance lastInheritance;
        int count = 0;
        TreeMap<String, Relation<String, String>> differences = new TreeMap();

        PathStore() {
        }

        Row.R5<Level, Inheritance, Integer, String, TreeMap<String, Relation<String, String>>> add(Row.R3<Level, String, Inheritance> next) {
            ++this.count;
            boolean wasNull = this.lastLevel == null;
            Level level = null;
            String path = null;
            Inheritance inherited = null;
            if (next != null) {
                level = (Level)((Object)next.get0());
                path = (String)next.get1();
                inherited = (Inheritance)((Object)next.get2());
                this.nextParts = this.setNewParts(path);
                if (this.sameElements()) {
                    this.addDifferences();
                    return null;
                }
            }
            this.clean(this.differences);
            Row.R5<Level, Inheritance, Integer, String, TreeMap<String, Relation<String, String>>> results = Row.of(this.lastLevel, this.lastInheritance, this.count - 1, this.lastParts.toString().replace("/", "\u200b/"), this.differences);
            this.lastParts = this.nextParts;
            this.differences = new TreeMap();
            this.nextParts = new XPathParts();
            this.lastLevel = level;
            this.lastInheritance = inherited;
            this.count = 1;
            if (wasNull) {
                return null;
            }
            return results;
        }

        private void clean(TreeMap<String, Relation<String, String>> differences2) {
            for (int i = 0; i < this.lastParts.size(); ++i) {
                String element = this.lastParts.getElement(i);
                Relation<String, String> attr_values = differences2.get(element);
                if (attr_values == null) continue;
                for (String attr : attr_values.keySet()) {
                    this.lastParts.putAttributeValue(i, attr, "*");
                }
            }
        }

        private XPathParts setNewParts(String path) {
            XPathParts parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
            if (path.startsWith("//ldml/dates/timeZoneNames/metazone") || path.startsWith("//ldml/dates/timeZoneNames/zone")) {
                String element = this.nextParts.getElement(-1);
                this.nextParts.setElement(-1, "zoneChoice");
                this.nextParts.putAttributeValue(-1, "type", element);
                element = this.nextParts.getElement(-2);
                this.nextParts.setElement(-2, "zoneLength");
                this.nextParts.putAttributeValue(-2, "type", element);
            } else if (path.startsWith("//ldml/dates/calendars/calendar") && !"gregorian".equals(parts.getAttributeValue(3, "type"))) {
                for (int i = parts.size() - 1; i > 3; --i) {
                    parts.removeElement(i);
                }
                parts.addElement("*");
            }
            return parts;
        }

        private void addDifferences() {
            for (int i = 0; i < this.lastParts.size(); ++i) {
                Map<String, String> nextAttrs;
                Map<String, String> lastAttrs = this.lastParts.getAttributes(i);
                if (lastAttrs.equals(nextAttrs = this.nextParts.getAttributes(i))) continue;
                String element = this.lastParts.getElement(i);
                Relation<String, String> old = this.differences.get(element);
                if (old == null) {
                    old = Relation.of(new TreeMap(attributeComparator), TreeSet.class);
                    this.differences.put(element, old);
                }
                Set union = Builder.with(new TreeSet()).addAll((Iterable<String>)lastAttrs.keySet()).addAll((Iterable<String>)nextAttrs.keySet()).get();
                for (String key : union) {
                    String nextValue;
                    String lastValue = lastAttrs.get(key);
                    if (Objects.equals(lastValue, nextValue = nextAttrs.get(key))) continue;
                    if (lastValue != null) {
                        old.put(key, lastValue);
                    }
                    if (nextValue == null) continue;
                    old.put(key, nextValue);
                }
            }
        }

        private boolean sameElements() {
            if (this.lastParts.size() != this.nextParts.size()) {
                return false;
            }
            for (int i = 0; i < this.lastParts.size(); ++i) {
                if (this.lastParts.getElement(i).equals(this.nextParts.getElement(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class RowComparator
    implements Comparator<Row.R3<Level, String, Inheritance>> {
        private RowComparator() {
        }

        @Override
        public int compare(Row.R3<Level, String, Inheritance> o1, Row.R3<Level, String, Inheritance> o2) {
            int result = ((Level)((Object)o1.get0())).compareTo((Level)((Object)o2.get0()));
            if (result != 0) {
                return result;
            }
            result = CLDRFile.getComparator(DtdType.ldml).compare((String)o1.get1(), (String)o2.get1());
            if (result != 0) {
                return result;
            }
            result = ((Inheritance)((Object)o1.get2())).compareTo((Inheritance)((Object)o2.get2()));
            return result;
        }
    }

    static enum Inheritance {
        actual,
        inherited;

    }
}

