/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.CaseMap;
import java.io.IOException;
import java.util.Locale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.DTD2Markdown;
import org.unicode.cldr.util.DTD2XSD;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.TempPrintWriter;

@CLDRTool(alias="generate-dtd", description="BRS: Reformat all DTDs")
public class GenerateDtd {
    private static final CaseMap.Title TO_TITLE_WHOLE_STRING_NO_LOWERCASE = CaseMap.toTitle().wholeString().noLowercase();

    public static void main(String[] args) throws IOException {
        DTD2Markdown dtd2md = new DTD2Markdown();
        for (DtdType type : DtdType.values()) {
            if (type == DtdType.ldmlICU) continue;
            DtdData data = DtdData.getInstance(type);
            Object name = type.toString();
            if (!((String)name).startsWith("ldml") && ((String)(name = "ldml" + TO_TITLE_WHOLE_STRING_NO_LOWERCASE.apply(Locale.ROOT, null, (CharSequence)name))).endsWith("Data")) {
                name = ((String)name).substring(0, ((String)name).length() - 4);
            }
            String dtdPath = CLDRPaths.BASE_DIRECTORY + type.dtdPath;
            try (TempPrintWriter out = TempPrintWriter.openUTF8Writer(dtdPath);){
                out.println(data);
                System.err.println("Wrote DTD: " + dtdPath);
            }
            DTD2XSD.write(data, type);
            dtd2md.write(data, type);
        }
    }
}

