/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GenerateItemCounts {
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = CLDRConfig.getInstance().getSupplementalDataInfo();
    private static final boolean SKIP_ORDERING = true;
    private static final String OUT_DIRECTORY = CLDRPaths.GEN_DIRECTORY + "/itemcount/";
    private Map<String, List<StackTraceElement>> cantRead = new TreeMap<String, List<StackTraceElement>>();
    private static String[] DIRECTORIES;
    private static String TRUNK_VERSION;
    static boolean doChanges;
    static Relation<String, String> path2value;
    static final AttributeTypes ATTRIBUTE_TYPES;
    static final Option.Options myOptions;
    static Matcher DIR_FILE_MATCHER;
    static Matcher RAW_FILE_MATCHER;
    static boolean VERBOSE;
    static final Set<String> SKIP_ATTRIBUTES;
    static final Relation<String, DtdType> ELEMENTS_OCCURRING;
    static final Relation<String, DtdType> ELEMENTS_POSSIBLE;
    static final Relation<String, Row.R2<DtdType, String>> ATTRIBUTES_OCCURRING;
    static final Relation<String, Row.R2<DtdType, String>> ATTRIBUTES_POSSIBLE;
    static Pattern prefix;
    static final Pattern LOCALE_PATTERN;
    static final Set<String> ATTRIBUTES_TO_SKIP;
    static final Pattern skipPath;
    static final Set<String> SKIP_DIRS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.directory, args, true);
        DIR_FILE_MATCHER = PatternCache.get(MyOptions.directory.option.getValue()).matcher("");
        RAW_FILE_MATCHER = PatternCache.get(MyOptions.rawfilter.option.getValue()).matcher("");
        VERBOSE = MyOptions.verbose.option.doesOccur();
        if (MyOptions.summary.option.doesOccur()) {
            GenerateItemCounts.doSummary();
            System.out.println("DONE");
            return;
        }
        GenerateItemCounts main = new GenerateItemCounts();
        try {
            Relation<String, String> oldPath2value = null;
            for (String dir : DIRECTORIES) {
                String pathname = dir.equals("trunk") ? CLDRPaths.BASE_DIRECTORY : CLDRPaths.ARCHIVE_DIRECTORY + "/" + dir;
                boolean isFinal = dir == DIRECTORIES[DIRECTORIES.length - 1];
                String fulldir = PathUtilities.getNormalizedPathString(pathname, new String[0]);
                String prefix = MyOptions.rawfilter.option.doesOccur() ? "filtered_" : "";
                String fileKey = dir.replace("/", "_");
                try (PrintWriter summary = FileUtilities.openUTF8Writer(OUT_DIRECTORY, prefix + fileKey + "_count.txt");
                     PrintWriter changes = FileUtilities.openUTF8Writer(OUT_DIRECTORY, prefix + fileKey + "_changes.txt");
                     PrintWriter changesNew = FileUtilities.openUTF8Writer(OUT_DIRECTORY, prefix + fileKey + "_news.txt");
                     PrintWriter changesDeletes = FileUtilities.openUTF8Writer(OUT_DIRECTORY, prefix + fileKey + "_deletes.txt");
                     PrintWriter changesSummary = FileUtilities.openUTF8Writer(OUT_DIRECTORY, prefix + fileKey + "_changes_summary.txt");){
                    main.summarizeCoverage(summary, fulldir, isFinal);
                    if (!doChanges) continue;
                    if (oldPath2value != null) {
                        GenerateItemCounts.compare(summary, changes, changesNew, changesDeletes, changesSummary, oldPath2value, path2value);
                        GenerateItemCounts.checkBadAttributes(path2value, prefix + fileKey + "_dtd_check.txt");
                    }
                    oldPath2value = path2value;
                    path2value = Relation.of(new TreeMap(), TreeSet.class);
                }
            }
            ATTRIBUTE_TYPES.showStarred();
        }
        finally {
            if (main.cantRead.size() != 0) {
                System.out.println("Couldn't read:\t");
                for (String file : main.cantRead.keySet()) {
                    System.out.println(file + "\t" + main.cantRead.get(file));
                }
            }
            System.out.println("DONE");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkBadAttributes(Relation<String, String> path2value2, String outputFile) throws IOException {
        void var6_9;
        LinkedHashSet<CallSite> errors = new LinkedHashSet<CallSite>();
        SupplementalDataInfo supp = SUPPLEMENTAL_DATA_INFO;
        DtdType[] dtdTypeArray = DtdType.values();
        int n = dtdTypeArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            DtdType dtdType = dtdTypeArray[var6_9];
            if (dtdType != DtdType.ldmlICU) {
                DtdData data = DtdData.getInstance(dtdType);
                for (DtdData.Element element : data.getElements()) {
                    String string = element.name;
                    ELEMENTS_POSSIBLE.put(string, dtdType);
                    Set<DtdData.Element> children = element.getChildren().keySet();
                    boolean skipFinal = children.isEmpty() || children.size() == 1 && children.iterator().next().name.equals("special");
                    for (Map.Entry<DtdData.Attribute, Integer> attributeInt : element.getAttributes().entrySet()) {
                        DtdData.Attribute attribute = attributeInt.getKey();
                        String attributeName = attribute.name;
                        if (attribute.defaultValue != null) {
                            errors.add((CallSite)((Object)("Warning, default value \u00ab" + attribute.defaultValue + "\u00bb for: " + dtdType + "\t" + string + "\t" + attributeName)));
                        }
                        Row.R2<DtdType, String> attributeRow = Row.of(dtdType, string);
                        ATTRIBUTES_POSSIBLE.put(attributeName, attributeRow);
                        if (skipFinal || SKIP_ATTRIBUTES.contains(attributeName) || supp.isDeprecated(dtdType, string, attributeName, null) || CLDRFile.isDistinguishing(dtdType, string, attributeName)) continue;
                        String doesOccur = "";
                        Set<Row.R2<DtdType, String>> attributeRows = ATTRIBUTES_OCCURRING.get(attributeName);
                        if (attributeRows == null || !attributeRows.contains(attributeRow)) {
                            doesOccur = "\tNEVER";
                        }
                        errors.add((CallSite)((Object)("Warning, !disting, !leaf: " + dtdType + "\t" + string + "\t" + attributeName + "\t" + children + doesOccur)));
                    }
                }
            }
            ++var6_9;
        }
        try (PrintWriter out = FileUtilities.openUTF8Writer(OUT_DIRECTORY, outputFile);){
            TreeSet<Object> noOccur;
            TreeSet<Object> deprecated;
            Set<Object> possible;
            out.println("\nElements\tDeprecated\tOccurring\tPossible in DTD, but never occurs");
            for (Map.Entry<String, Set<DtdType>> entry : ELEMENTS_POSSIBLE.keyValuesSet()) {
                String element = entry.getKey();
                if (element.equals("#PCDATA") || element.equals("ANY") || element.equals("generation")) continue;
                possible = entry.getValue();
                deprecated = new TreeSet<Object>();
                for (DtdType dtdType : possible) {
                    if (!SUPPLEMENTAL_DATA_INFO.isDeprecated(dtdType, element, "*", "*")) continue;
                    deprecated.add((Object)dtdType);
                }
                TreeSet<DtdType> treeSet = new TreeSet<DtdType>(possible);
                treeSet.removeAll(deprecated);
                Set set = CldrUtility.ifNull(ELEMENTS_OCCURRING.get(element), Collections.EMPTY_SET);
                noOccur = new TreeSet<Object>(possible);
                noOccur.removeAll(set);
                if (!Collections.disjoint(deprecated, set)) {
                    Set intersection = CldrUtility.intersect(deprecated, set);
                    errors.add((CallSite)((Object)("Error: element \u00ab" + element + "\u00bb is deprecated in " + (deprecated.equals(possible) ? "EVERYWHERE" : intersection) + " but occurs in live data: " + intersection)));
                }
                if (!Collections.disjoint(treeSet, noOccur)) {
                    errors.add((CallSite)((Object)("Warning: element \u00ab" + element + "\u00bb doesn't occur in and is not deprecated in " + CldrUtility.intersect(treeSet, noOccur))));
                }
                out.println(element + "\t" + deprecated + "\t" + set + "\t" + noOccur);
            }
            out.println("\nAttributes\tDeprecated\tOccurring\tPossible in DTD, but never occurs");
            for (Map.Entry<String, Set<Object>> entry : ATTRIBUTES_POSSIBLE.keyValuesSet()) {
                String attribute = entry.getKey();
                if (attribute.equals("alt") || attribute.equals("draft") || attribute.equals("references")) continue;
                possible = entry.getValue();
                deprecated = new TreeSet();
                for (Row.R2 r2 : possible) {
                    String element;
                    DtdType dtdType = (DtdType)((Object)r2.get0());
                    if (!SUPPLEMENTAL_DATA_INFO.isDeprecated(dtdType, element = (String)r2.get1(), attribute, "*")) continue;
                    deprecated.add(r2);
                }
                TreeSet<Object> treeSet = new TreeSet<Object>(possible);
                treeSet.removeAll(deprecated);
                Set set = CldrUtility.ifNull(ATTRIBUTES_OCCURRING.get(attribute), Collections.EMPTY_SET);
                noOccur = new TreeSet<Object>(possible);
                noOccur.removeAll(set);
                if (!Collections.disjoint(deprecated, set)) {
                    Set intersection = CldrUtility.intersect(deprecated, set);
                    errors.add((CallSite)((Object)("Error: attribute \u00ab" + attribute + "\u00bb is deprecated in " + (deprecated.equals(possible) ? "EVERYWHERE" : intersection) + " but occurs in live data: " + intersection)));
                }
                if (!Collections.disjoint(treeSet, noOccur)) {
                    errors.add((CallSite)((Object)("Warning: attribute \u00ab" + attribute + "\u00bb doesn't occur in and is not deprecated in " + CldrUtility.intersect(treeSet, noOccur))));
                }
                out.println(attribute + "\t" + deprecated + "\t" + set + "\t" + noOccur);
            }
            out.println("\nERRORS/WARNINGS");
            out.println(Joiner.on("\n").join(errors));
        }
    }

    private static void compare(PrintWriter summary, PrintWriter changes, PrintWriter changesNew, PrintWriter changesDeletes, PrintWriter changesSummary, Relation<String, String> oldPath2value, Relation<String, String> path2value2) {
        Set union = Builder.with(new TreeSet()).addAll((Iterable<String>)oldPath2value.keySet()).addAll((Iterable<String>)path2value2.keySet()).get();
        long total = 0L;
        Matcher prefixMatcher = prefix.matcher("");
        Delta charCount = new Delta();
        Delta itemCount = new Delta();
        TreeSet<String> prefixes = new TreeSet<String>();
        for (String path : union) {
            if (!prefixMatcher.reset(path).find()) {
                throw new IllegalArgumentException();
            }
            String prefix = prefixMatcher.group(1);
            prefixes.add(prefix);
            String localPath = prefixMatcher.group(2);
            Set<String> set1 = oldPath2value.getAll(path);
            Set<String> set2 = path2value2.getAll(path);
            if (set2 != null) {
                total += (long)set2.size();
            }
            if (set1 == null) {
                changesNew.println(prefix + "\t\t" + set2 + "\t" + localPath);
                itemCount.newCount.add(prefix, set2.size());
                charCount.newCount.add(prefix, GenerateItemCounts.totalLength(set2));
                continue;
            }
            if (set2 == null) {
                changesDeletes.println(prefix + "\t" + set1 + "\t\t" + localPath);
                itemCount.deletedCount.add(prefix, -set1.size());
                charCount.deletedCount.add(prefix, -GenerateItemCounts.totalLength(set1));
                continue;
            }
            if (!set1.equals(set2)) {
                TreeSet<String> set1minus2 = Builder.with(new TreeSet()).addAll((Iterable<String>)set1).removeAll((Collection<String>)set2).get();
                TreeSet<String> set2minus1 = Builder.with(new TreeSet()).addAll((Iterable<String>)set2).removeAll((Collection<String>)set1).get();
                TreeSet<String> set2and1 = Builder.with(new TreeSet()).addAll((Iterable<String>)set2).retainAll((Collection<String>)set1).get();
                itemCount.changedCount.add(prefix, (set2minus1.size() + set1minus2.size() + 1) / 2);
                itemCount.unchangedCount.add(prefix, set2and1.size());
                charCount.changedCount.add(prefix, (GenerateItemCounts.totalLength(set2minus1) + GenerateItemCounts.totalLength(set1minus2) + 1L) / 2L);
                charCount.unchangedCount.add(prefix, GenerateItemCounts.totalLength(set2and1));
                changes.println(prefix + "\t" + set1minus2 + "\t" + set2minus1 + "\t" + localPath);
                continue;
            }
            itemCount.unchangedCount.add(prefix, set2.size());
            charCount.unchangedCount.add(prefix, GenerateItemCounts.totalLength(set2));
        }
        itemCount.print(changesSummary, prefixes);
        changesSummary.println();
        charCount.print(changesSummary, prefixes);
        summary.println("#Total:\t" + total);
    }

    private static long totalLength(Set<String> set2) {
        int result = 0;
        for (String s2 : set2) {
            result += s2.length();
        }
        return result;
    }

    public static void doSummary() throws IOException {
        VersionInfo vi;
        String releaseNum;
        Matcher releaseMatcher;
        String name;
        TreeMap key_release_count = new TreeMap();
        Matcher countryLocale = LOCALE_PATTERN.matcher("");
        ArrayList<String> releases = new ArrayList<String>();
        Pattern releaseNumber = PatternCache.get("count_(?:.*-(\\d+(\\.\\d+)*)|trunk)\\.txt");
        Relation<String, String> release_keys = Relation.of(new TreeMap(), TreeSet.class);
        Relation<CallSite, String> localesToPaths = Relation.of(new TreeMap(), TreeSet.class);
        TreeSet<CallSite> writtenLanguages = new TreeSet<CallSite>();
        TreeSet<String> countries = new TreeSet<String>();
        File[] listFiles = new File(OUT_DIRECTORY).listFiles();
        VersionInfo mostRecentVersion = VersionInfo.getInstance(0);
        for (File subdir : listFiles) {
            name = subdir.getName();
            releaseMatcher = releaseNumber.matcher(name);
            if (!releaseMatcher.matches()) {
                if (!name.startsWith("count_")) continue;
                throw new IllegalArgumentException("Bad match " + RegexUtilities.showMismatch(releaseMatcher, (CharSequence)name));
            }
            releaseNum = releaseMatcher.group(1);
            if (releaseNum == null) {
                releaseNum = TRUNK_VERSION;
            }
            if ((vi = VersionInfo.getInstance(releaseNum)).compareTo(mostRecentVersion) <= 0) continue;
            mostRecentVersion = vi;
        }
        for (File subdir : listFiles) {
            String line;
            name = subdir.getName();
            releaseMatcher = releaseNumber.matcher(name);
            if (!releaseMatcher.matches()) {
                if (!name.startsWith("count_")) continue;
                throw new IllegalArgumentException("Bad match " + RegexUtilities.showMismatch(releaseMatcher, (CharSequence)name));
            }
            releaseNum = releaseMatcher.group(1);
            if (releaseNum == null) {
                releaseNum = TRUNK_VERSION;
            }
            vi = VersionInfo.getInstance(releaseNum);
            boolean captureData = vi.equals(mostRecentVersion);
            releases.add(releaseNum);
            BufferedReader in = FileUtilities.openUTF8Reader("", PathUtilities.getNormalizedPathString(subdir));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                String[] parts = line.split("\t");
                try {
                    String file = parts[0];
                    if (file.startsWith("seed/") || !DIR_FILE_MATCHER.reset(file).find()) {
                        if (!VERBOSE) continue;
                        System.out.println("Skipping: " + RegexUtilities.showMismatch(DIR_FILE_MATCHER, (CharSequence)file));
                        continue;
                    }
                    if (VERBOSE) {
                        System.out.println("Including: " + file);
                    }
                    long valueCount = Long.parseLong(parts[1]);
                    long valueLen = Long.parseLong(parts[2]);
                    long attrCount = Long.parseLong(parts[3]);
                    long attrLen = Long.parseLong(parts[4]);
                    int lastSlash = file.lastIndexOf("/");
                    String key2 = file;
                    String path = file.substring(0, lastSlash);
                    String key = file.substring(lastSlash + 1);
                    if (countryLocale.reset(key).matches()) {
                        String lang = countryLocale.group(1);
                        String script = countryLocale.group(2);
                        String country = countryLocale.group(3);
                        String writtenLang = lang + (String)(script == null ? "" : "_" + script);
                        String locale = writtenLang + (String)(country == null ? "" : "_" + country);
                        if (captureData) {
                            localesToPaths.put((CallSite)((Object)locale), path);
                            writtenLanguages.add((CallSite)((Object)writtenLang));
                            if (country != null) {
                                countries.add(country);
                            }
                        }
                    }
                    if (valueCount + attrCount == 0L) continue;
                    release_keys.put(releaseNum, key2);
                    Row.R4 release_count = (Row.R4)key_release_count.get(key2);
                    if (release_count == null) {
                        release_count = Row.of(new Counter(), new Counter(), new Counter(), new Counter());
                        key_release_count.put(key2, release_count);
                    }
                    ((Counter)release_count.get0()).add(releaseNum, valueCount);
                    ((Counter)release_count.get1()).add(releaseNum, valueLen);
                    ((Counter)release_count.get2()).add(releaseNum, attrCount);
                    ((Counter)release_count.get3()).add(releaseNum, attrLen);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(line, e);
                }
            }
            in.close();
        }
        PrintWriter summary = FileUtilities.openUTF8Writer(OUT_DIRECTORY, (MyOptions.directory.option.doesOccur() ? "filtered-" : "") + "summary.txt");
        for (String file : releases) {
            summary.print("\t" + file + "\tlen");
        }
        summary.println();
        for (String key : key_release_count.keySet()) {
            summary.print(key);
            Row.R4 release_count = (Row.R4)key_release_count.get(key);
            for (String release2 : releases) {
                long count = ((Counter)release_count.get0()).get(release2) + ((Counter)release_count.get2()).get(release2);
                long len = ((Counter)release_count.get1()).get(release2) + ((Counter)release_count.get3()).get(release2);
                summary.print("\t" + count + "\t" + len);
            }
            summary.println();
        }
        for (String release : release_keys.keySet()) {
            System.out.println("Release:\t" + release + "\t" + release_keys.getAll(release).size());
        }
        summary.close();
        PrintWriter summary2 = FileUtilities.openUTF8Writer(OUT_DIRECTORY, (MyOptions.directory.option.doesOccur() ? "filtered-" : "") + "locales.txt");
        summary2.println("#Languages (inc. script):\t" + writtenLanguages.size());
        summary2.println("#Countries:\t" + countries.size());
        summary2.println("#Locales:\t" + localesToPaths.size());
        for (Map.Entry entry : localesToPaths.keyValuesSet()) {
            summary2.println((String)entry.getKey() + "\t" + Joiner.on("\t").join(entry.getValue()));
        }
        summary2.close();
    }

    static void capture(DtdType type2, XPathParts parts) {
        for (int i = 0; i < parts.size(); ++i) {
            String element = parts.getElement(i);
            ELEMENTS_OCCURRING.put(element, type2);
            for (String attribute : parts.getAttributes(i).keySet()) {
                ATTRIBUTES_OCCURRING.put(attribute, Row.of(type2, element));
            }
        }
    }

    private MyHandler check(String systemID, String name, boolean isFinal) {
        MyHandler myHandler = new MyHandler(name, isFinal);
        try {
            XMLFileReader reader = new XMLFileReader().setHandler(myHandler);
            reader.read(systemID, XMLFileReader.CONTENT_HANDLER, true);
        }
        catch (Exception e) {
            this.cantRead.put(name, Arrays.asList(e.getStackTrace()));
        }
        return myHandler;
    }

    private void summarizeCoverage(PrintWriter summary, String commonDir, boolean isFinal) {
        System.out.println(commonDir);
        summary.println("#name\tvalue-count\tvalue-len\tattr-count\tattr-len");
        File commonDirectory = new File(commonDir);
        if (!commonDirectory.exists()) {
            System.out.println("Doesn't exist:\t" + commonDirectory);
        }
        this.summarizeFiles(summary, commonDirectory, isFinal, 1);
    }

    public void summarizeFiles(PrintWriter summary, File directory, boolean isFinal, int level) {
        System.out.println("\t\t\t\t\t\t\t".substring(0, level) + directory);
        int count = 0;
        for (File file : directory.listFiles()) {
            String filename = file.getName();
            if (filename.startsWith(".")) continue;
            if (file.isDirectory()) {
                if (SKIP_DIRS.contains(filename)) continue;
                this.summarizeFiles(summary, file, isFinal, level + 1);
                continue;
            }
            if (filename.startsWith("#") || !filename.endsWith(".xml")) continue;
            Object name = new File(directory.getParent()).getName() + "/" + directory.getName() + "/" + file.getName();
            if (!RAW_FILE_MATCHER.reset((CharSequence)(name = ((String)name).substring(0, ((String)name).length() - 4))).find()) continue;
            if (VERBOSE) {
                System.out.println((String)name);
            } else {
                System.out.print(".");
                if (++count > 100) {
                    count = 0;
                    System.out.println();
                }
                System.out.flush();
            }
            MyHandler handler = this.check(file.toString(), (String)name, isFinal);
            summary.println((String)name + "\t" + handler.valueCount + "\t" + handler.valueLen + "\t" + handler.attributeCount + "\t" + handler.attributeLen);
        }
        System.out.println();
    }

    static {
        System.err.println("Probably obsolete tool");
        DIRECTORIES = new String[]{"cldr-27.0", "trunk"};
        TRUNK_VERSION = "26.0";
        doChanges = true;
        path2value = Relation.of(new TreeMap(), TreeSet.class);
        ATTRIBUTE_TYPES = new AttributeTypes();
        myOptions = new Option.Options();
        SKIP_ATTRIBUTES = new HashSet<String>(Arrays.asList("draft", "references", "validSubLocales"));
        ELEMENTS_OCCURRING = Relation.of(new TreeMap(), TreeSet.class);
        ELEMENTS_POSSIBLE = Relation.of(new TreeMap(), TreeSet.class);
        ATTRIBUTES_OCCURRING = Relation.of(new TreeMap(), TreeSet.class);
        ATTRIBUTES_POSSIBLE = Relation.of(new TreeMap(), TreeSet.class);
        prefix = PatternCache.get("([^/]+/[^/]+)(.*)");
        LOCALE_PATTERN = PatternCache.get("([a-z]{2,3})(?:[_-]([A-Z][a-z]{3}))?(?:[_-]([a-zA-Z0-9]{2,3}))?([_-][a-zA-Z0-9]{1,8})*");
        ATTRIBUTES_TO_SKIP = Builder.with(new HashSet()).addAll("version", "references", "standard", "draft").freeze();
        skipPath = PatternCache.get("\\[\\@alt=\"[^\"]*proposed|^//(ldml(\\[[^/]*)?/identity|(ldmlBCP47|supplementalData|keyboard)(\\[[^/]*)?/(generation|version))");
        SKIP_DIRS = new HashSet<String>(Arrays.asList("specs", "tools", "seed", "exemplars"));
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("\nerror: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("\nfatalError: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("\nwarning: " + XMLFileReader.showSAX(exception));
            throw exception;
        }
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        long valueCount;
        long valueLen;
        long attributeCount;
        long attributeLen;
        Matcher skipPathMatcher = skipPath.matcher("");
        Splitter lines = Splitter.onPattern("\n+").omitEmptyStrings().trimResults();
        String prefix;
        int orderedCount;
        DtdType type;
        private final boolean isFinal;

        MyHandler(String prefix, boolean isFinal) {
            this.prefix = prefix;
            this.isFinal = isFinal;
        }

        @Override
        public void handlePathValue(String path, String value) {
            int i;
            Collection<String> attributes;
            if (this.type == null) {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                this.type = DtdType.valueOf(parts.getElement(0));
            }
            ATTRIBUTE_TYPES.add(path);
            if (this.skipPathMatcher.reset(path).find()) {
                return;
            }
            String pathKey = null;
            if (doChanges) {
                pathKey = this.fixKeyPath(path);
            }
            int len = value.length();
            if ((value = value.trim()).isEmpty() && len > 0) {
                value = " ";
            }
            if (value.length() != 0) {
                List<String> valueLines = this.lines.splitToList(value);
                if (valueLines.size() == 1) {
                    ++this.valueCount;
                    this.valueLen += (long)value.length();
                    if (doChanges) {
                        path2value.put(pathKey, value);
                    }
                } else {
                    int count = 0;
                    for (String v : valueLines) {
                        ++this.valueCount;
                        this.valueLen += (long)v.length();
                        if (!doChanges) continue;
                        path2value.put(pathKey + "/_q" + count++, v);
                    }
                }
            }
            XPathParts parts = XPathParts.getFrozenInstance(path);
            if (this.isFinal) {
                GenerateItemCounts.capture(this.type, parts);
            }
            if (path.contains("[@") && (attributes = parts.getAttributeKeys(i = parts.size() - 1)).size() != 0) {
                String element = parts.getElement(i);
                for (String attribute : attributes) {
                    if (ATTRIBUTES_TO_SKIP.contains(attribute) || CLDRFile.isDistinguishing(this.type, element, attribute)) continue;
                    String valuePart = parts.getAttributeValue(i, attribute);
                    ++this.attributeCount;
                    this.attributeLen += (long)valuePart.length();
                    if (!doChanges) continue;
                    path2value.put(pathKey + "/_" + attribute, valuePart);
                }
            }
        }

        private String fixKeyPath(String path) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            for (int i = 0; i < parts.size(); ++i) {
                String string = parts.getElement(i);
            }
            return this.prefix + CLDRFile.getDistinguishingXPath(parts.toString(), null);
        }
    }

    static class Delta {
        Counter<String> newCount = new Counter();
        Counter<String> deletedCount = new Counter();
        Counter<String> changedCount = new Counter();
        Counter<String> unchangedCount = new Counter();

        Delta() {
        }

        void print(PrintWriter changesSummary, Set<String> prefixes) {
            changesSummary.println("Total\t" + this.unchangedCount.getTotal() + "\t" + this.deletedCount.getTotal() + "\t" + this.changedCount.getTotal() + "\t" + this.newCount.getTotal());
            changesSummary.println("Directory\tSame\tRemoved\tChanged\tAdded");
            for (String prefix : prefixes) {
                changesSummary.println(prefix + "\t" + this.unchangedCount.get(prefix) + "\t" + this.deletedCount.get(prefix) + "\t" + this.changedCount.get(prefix) + "\t" + this.newCount.get(prefix));
            }
        }
    }

    static class AttributeTypes {
        Relation<String, String> elementPathToAttributes = Relation.of(new TreeMap(), TreeSet.class);
        final PathStarrer PATH_STARRER = new PathStarrer().setSubstitutionPattern("*");
        final Set<String> STARRED_PATHS = new TreeSet<String>();
        StringBuilder elementPath = new StringBuilder();

        AttributeTypes() {
        }

        public void add(String path) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            this.elementPath.setLength(0);
            for (int i = 0; i < parts.size(); ++i) {
                String element = parts.getElement(i);
                this.elementPath.append('/').append(element);
                this.elementPathToAttributes.putAll(this.elementPath.toString().intern(), parts.getAttributeKeys(i));
            }
        }

        public void showStarred() throws IOException {
            PrintWriter starred = FileUtilities.openUTF8Writer(OUT_DIRECTORY, "starred.txt");
            for (Map.Entry<String, Set<String>> entry : this.elementPathToAttributes.keyValuesSet()) {
                Set<String> attributes = entry.getValue();
                if (attributes.size() == 0) continue;
                String path = entry.getKey();
                String[] elements = path.split("/");
                DtdType type = DtdType.valueOf(elements[1]);
                String finalElement = elements[elements.length - 1];
                starred.print(path);
                for (String attribute : attributes) {
                    if (CLDRFile.isDistinguishing(type, finalElement, attribute)) {
                        starred.print("[@" + attribute + "='disting.']");
                        continue;
                    }
                    starred.print("[@" + attribute + "='DATA']");
                }
                starred.println();
            }
            starred.close();
        }
    }

    static enum MyOptions {
        summary(null, null, "if present, summarizes data already collected. Run once with, once without."),
        directory(".*", ".*", "if summary, creates filtered version (eg -d main): does a find in the name, which is of the form dir/file"),
        verbose(null, null, "verbose debugging messages"),
        rawfilter(".*", ".*", "filter the raw files (non-summary, mostly for debugging)");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

