/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.Transform;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateLanguageMatches {
    private static final CLDRFile ENGLISH = CLDRConfig.getInstance().getEnglish();
    private static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    static final Transform<String, String> MENU = new Transform<String, String>(){

        @Override
        public String transform(String source) {
            return "menu";
        }
    };

    public static void main(String[] args) {
        Map<String, Map<StandardCodes.LstrField, String>> lstr = StandardCodes.getLstregEnumRaw().get((Object)StandardCodes.LstrType.language);
        Set<String> locales = CLDRConfig.getInstance().getFullCldrFactory().getAvailableLanguages();
        List<Row.R4<String, String, Integer, Boolean>> matchData = SDI.getLanguageMatcherData("written_new");
        HashMultimap<String, String> desiredToSupported = HashMultimap.create();
        for (Row.R4<String, String, Integer, Boolean> item : matchData) {
            desiredToSupported.put((String)item.get0(), (String)item.get1());
            if (((Boolean)item.get3()).booleanValue()) continue;
            desiredToSupported.put((String)item.get1(), (String)item.get0());
        }
        Set<String> languageAliases = SDI.getLocaleAliasInfo().get("language").keySet();
        TreeMultimap<String, String> macroToEncompassed = TreeMultimap.create();
        for (Map.Entry<String, Map<StandardCodes.LstrField, String>> localeInfo : lstr.entrySet()) {
            Map<StandardCodes.LstrField, String> data;
            String macroLanguage;
            String locale = localeInfo.getKey();
            if (locale.contains("_") || languageAliases.contains(locale) || (macroLanguage = (data = localeInfo.getValue()).get((Object)StandardCodes.LstrField.Macrolanguage)) == null || !locales.contains(macroLanguage) || desiredToSupported.containsEntry(locale, macroLanguage)) continue;
            macroToEncompassed.put(macroLanguage, locale);
        }
        String last = "";
        System.out.println("<!-- START generated by GenerateLanguageMatches.java: don't manually change -->");
        for (Map.Entry entry : macroToEncompassed.entries()) {
            String macroLanguage = (String)entry.getKey();
            if (macroLanguage.equals("ku")) continue;
            if (!last.contentEquals(macroLanguage)) {
                System.out.println("<!-- Encompassed by " + GenerateLanguageMatches.getName(macroLanguage) + " -->");
            }
            String encompassed = (String)entry.getValue();
            System.out.println("\t\t\t<languageMatch desired=\"" + encompassed + "\" supported=\"" + macroLanguage + "\" distance=\"10\" oneway=\"true\"/>\t<!-- " + GenerateLanguageMatches.getName(encompassed) + " -->");
            last = macroLanguage;
        }
        System.out.println("<!-- END generated by GenerateLanguageMatches.java -->");
    }

    private static String getName(String lang) {
        return ENGLISH.getName(0, lang, MENU);
    }
}

