/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.TreeMultimap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.Validity;

public class GenerateLikelyTestData {
    private static final String DUMMY_SCRIPT = "Egyp";
    private static final String DUMMY_REGION = "AQ";
    static CLDRConfig config = CLDRConfig.getInstance();
    static Map<String, String> data = config.getSupplementalDataInfo().getLikelySubtags();
    static LikelySubtags likely = new LikelySubtags();
    private static final Validity VALIDITY = Validity.getInstance();
    static Set<String> okRegions = VALIDITY.getStatusToCodes(StandardCodes.LstrType.region).get((Object)Validity.Status.regular);
    private static Set<String> ALLOWED_WITH_MACROREGION = Set.of("ar_001", "en_001", "en_150", "es_419");

    public static void main(String[] args) {
        try (TempPrintWriter pw = TempPrintWriter.openUTF8Writer(CLDRPaths.TEST_DATA + "localeIdentifiers", "likelySubtags.txt");){
            pw.println("# Test data for Likely Subtags\n" + CldrUtility.getCopyrightString("#  ") + "\n#\n# Test data for https://www.unicode.org/reports/tr35/tr35.html#Likely_Subtags\n#\n# Format:\n");
            GenerateLikelyTestData.showLine(pw, "# Source", "AddLikely", "RemoveFavorScript", "RemoveFavorRegion");
            pw.println("#   Source: a locale to which the following operations are applied.\n#   AddLikely: the result of the Add Likely Subtags.\n#                      If Add Likely Subtags fails, then \u201cFAIL\u201d.\n#   RemoveFavorScript: Remove Likely Subtags, when the script is favored.\n#                      Only included when different than AddLikely.\n#   RemoveFavorRegion: Remove Likely Subtags, when the region is favored.\n#                      Only included when different than RemoveFavorScript.\n#\n# Generation: GenerateLikelyTestData.java\n");
            Set<String> testCases = GenerateLikelyTestData.getTestCases(data);
            for (String testRaw : testCases) {
                String test;
                String maximize;
                if (testRaw.startsWith("qaa")) {
                    boolean bl = false;
                }
                if ((maximize = likely.maximize(test = CLDRLocale.getInstance(testRaw).toLanguageTag())) == null) {
                    GenerateLikelyTestData.showLine(pw, test, "FAIL", "FAIL", "FAIL");
                    continue;
                }
                String max = CLDRLocale.getInstance(maximize).toLanguageTag();
                if (max.isEmpty()) {
                    throw new IllegalArgumentException("Empty max: " + test);
                }
                String minScript = CLDRLocale.getInstance(likely.setFavorRegion(false).minimize(test)).toLanguageTag();
                String minRegion = CLDRLocale.getInstance(likely.setFavorRegion(true).minimize(test)).toLanguageTag();
                GenerateLikelyTestData.showLine(pw, test, max, minScript, minRegion);
            }
        }
    }

    public static void check(String test0) {
        String check = likely.maximize(test0);
        System.out.println(test0 + " \u2192 " + check);
    }

    public static Set<String> getTestCases(Map<String, String> data) {
        String lang;
        CalculatedCoverageLevels coverage = CalculatedCoverageLevels.getInstance();
        TreeSet<String> skipping = new TreeSet<String>();
        TreeSet<String> testCases = new TreeSet<String>();
        TreeMultimap<String, String> combinations = TreeMultimap.create();
        for (String string : config.getCldrFactory().getAvailable()) {
            Level level = coverage.getEffectiveCoverageLevel(string);
            if (level == null || level.compareTo(Level.BASIC) < 0 || string.equals("root")) continue;
            CLDRLocale locale = CLDRLocale.getInstance(string);
            lang = locale.getLanguage();
            CLDRLocale max = CLDRLocale.getInstance(likely.maximize(string));
            if (!okRegions.contains(max.getCountry()) && !ALLOWED_WITH_MACROREGION.contains(string)) {
                skipping.add(string);
                continue;
            }
            combinations.put(lang, max.getScript());
            combinations.put(lang, max.getCountry());
            combinations.put(lang, DUMMY_REGION);
            combinations.put(lang, DUMMY_SCRIPT);
            combinations.put(lang, "");
        }
        TreeSet undCombinations = new TreeSet();
        for (Map.Entry entry : combinations.asMap().entrySet()) {
            undCombinations.addAll(entry.getValue());
        }
        combinations.putAll("und", undCombinations);
        LanguageTagParser languageTagParser = new LanguageTagParser();
        for (Map.Entry entry : combinations.asMap().entrySet()) {
            lang = (String)entry.getKey();
            TreeSet items = new TreeSet(entry.getValue());
            LinkedHashSet<String> scripts = new LinkedHashSet<String>();
            LinkedHashSet<String> regions = new LinkedHashSet<String>();
            for (String scriptOrRegion : items) {
                languageTagParser.set(lang);
                if (scriptOrRegion.length() == 4) {
                    languageTagParser.setScript(scriptOrRegion);
                    scripts.add(scriptOrRegion);
                } else {
                    languageTagParser.setRegion(scriptOrRegion);
                    if (!scriptOrRegion.isBlank()) {
                        regions.add(scriptOrRegion);
                    }
                }
                testCases.add(CLDRLocale.getInstance(languageTagParser.toString()).toLanguageTag());
            }
            scripts.remove(DUMMY_REGION);
            scripts.remove(DUMMY_SCRIPT);
            if (lang.equals("und")) continue;
            languageTagParser.set("und");
            for (String script : scripts) {
                languageTagParser.setScript(script);
                for (String region : regions) {
                    languageTagParser.setRegion(region);
                    testCases.add(CLDRLocale.getInstance(languageTagParser.toString()).toLanguageTag());
                }
            }
        }
        testCases.add("qaa");
        testCases.add("qaa_Cyrl");
        testCases.add("qaa_CH");
        testCases.add("qaa_Cyrl_CH");
        System.out.println("Skipping " + skipping);
        return testCases;
    }

    public static void showLine(TempPrintWriter tempWriter, String test, String max, String minScript, String minRegion) {
        tempWriter.println(test + " ;\t" + (max.equals(test) ? "" : max) + " ;\t" + (minScript.equals(max) ? "" : minScript) + " ;\t" + (minRegion.equals(minScript) ? "" : minRegion));
    }
}

