/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LsrvCanonicalizer;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;

public class GenerateLocaleIDTestData {
    private static final LsrvCanonicalizer rrs = LsrvCanonicalizer.getInstance();
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final CLDRFile ENGLISH = CLDR_CONFIG.getEnglish();

    public static void main(String[] args) throws IOException {
        try (TempPrintWriter pw = TempPrintWriter.openUTF8Writer(CLDRPaths.TEST_DATA + "localeIdentifiers", "localeCanonicalization.txt");){
            pw.println("# Test data for locale identifier canonicalization");
            pw.println(CldrUtility.getCopyrightString("#  "));
            pw.println("#\n# Format:\n# <source locale identifier>\t;\t<expected canonicalized locale identifier>\n#\n# The data lines are divided into 4 sets:\n#   " + LsrvCanonicalizer.TestDataTypes.explicit + ":    a short list of explicit test cases.\n#   " + LsrvCanonicalizer.TestDataTypes.fromAliases + ": test cases generated from the alias data.\n#   " + LsrvCanonicalizer.TestDataTypes.decanonicalized + ": test cases generated by reversing the normalization process.\n#   " + LsrvCanonicalizer.TestDataTypes.withIrrelevants + ": test cases generated from the others by adding irrelevant fields where possible,\n#                           to ensure that the canonicalization implementation is not sensitive to irrelevant fields. These include:\n#     Language: " + rrs.getIrrelevantField(StandardCodes.LstrType.language) + "\n#     Script:   " + rrs.getIrrelevantField(StandardCodes.LstrType.script) + "\n#     Region:   " + rrs.getIrrelevantField(StandardCodes.LstrType.region) + "\n#     Variant:  " + rrs.getIrrelevantField(StandardCodes.LstrType.variant) + "\n######\n\n");
            for (Map.Entry<LsrvCanonicalizer.TestDataTypes, Map<String, String>> mainEntry : rrs.getTestData(null).entrySet()) {
                LsrvCanonicalizer.TestDataTypes type = mainEntry.getKey();
                pw.println("\n# " + type + "\n");
                for (Map.Entry<String, String> entry : mainEntry.getValue().entrySet()) {
                    String toTest = entry.getKey();
                    String expected = entry.getValue();
                    pw.println(toTest + "\t;\t" + expected);
                }
            }
        }
        pw = TempPrintWriter.openUTF8Writer(CLDRPaths.TEST_DATA + "localeIdentifiers", "localeDisplayName.txt");
        try {
            pw.println("# Test data for locale display name generation\n" + CldrUtility.getCopyrightString("#  ") + "\n# Format:\n# @locale=<locale to display in>\n# @compound=<whether to form compounds like \"Flemish\" for nl_BE>\n# <locale to display> ; <expected display name>\n\n@locale=en\n@compound=false\n");
            pw.println("\n# Simple cases: Language, script, region, variants\n");
            GenerateLocaleIDTestData.showDisplayNames(pw, "es", "es-419", "es-Cyrl-MX", "hi-Latn");
            pw.println("\n#Note that the order of the variants is alphabetized before generating names\n");
            GenerateLocaleIDTestData.showDisplayNames(pw, "en-Latn-GB-scouse-fonipa");
            pw.println("\n# Add extensions, and verify their order\n");
            GenerateLocaleIDTestData.showDisplayNames(pw, "en-u-nu-thai-ca-islamic-civil", "hi-u-nu-latn-t-en-h0-hybrid", "en-u-nu-deva-t-de");
            pw.println("\n# Test ordering of extensions (include well-formed but invalid cases)\n");
            GenerateLocaleIDTestData.showDisplayNames(pw, "fr-z-zz-zzz-v-vv-vvv-u-uu-uuu-t-ru-Cyrl-s-ss-sss-a-aa-aaa-x-u-x");
            pw.println("\n# Comprehensive list (mostly comprehensive: currencies, subdivisions, timezones have abbreviated lists)\n");
            SupplementalDataInfo SDI = CLDR_CONFIG.getSupplementalDataInfo();
            Relation<String, String> extensionToKeys = SDI.getBcp47Extension2Keys();
            TreeMultimap<String, String> keyToExtensions = TreeMultimap.create();
            for (Map.Entry<String, String> entry : extensionToKeys.entrySet()) {
                keyToExtensions.put(entry.getValue(), entry.getKey());
            }
            Relation<String, String> keyToValues = SDI.getBcp47Keys();
            Map<Row.R2<String, String>, String> deprecated = SDI.getBcp47Deprecated();
            ImmutableMultimap<String, String> overrides = ImmutableMultimap.builder().putAll("cu", "eur", "jpy", "usd", "chf").putAll("rg", (String[])new String[]{"gbsct", "gbeng"}).putAll("sd", (String[])new String[]{"gbsct", "gbwls"}).putAll("tz", (String[])new String[]{"uslax", "gblon", "chzrh"}).putAll("dx", (String[])new String[]{"thai"}).putAll("vt", (String[])new String[]{"abcd"}).putAll("x0", (String[])new String[]{"foobar2"}).putAll("kr", (String[])new String[]{"arab", "digit-deva-latn", "currency", "digit", "punct", "space", "symbol"}).build();
            UnicodeSet upper = new UnicodeSet("[A-Z]").freeze();
            for (String key : keyToValues.keySet()) {
                if ("true".equals(deprecated.get(Row.of(key, "")))) continue;
                for (String extension : keyToExtensions.get(key)) {
                    ImmutableSortedSet<String> values = overrides.containsKey(key) ? overrides.get((Object)key) : ImmutableSortedSet.copyOf(keyToValues.get(key));
                    for (String value : values) {
                        if ("true".equals(deprecated.get(Row.of(key, value)))) continue;
                        String sampleLocale = "en-" + extension + "-" + key + "-" + value;
                        if (upper.containsSome(value)) {
                            System.err.println("** FIX NAME: " + sampleLocale);
                            continue;
                        }
                        GenerateLocaleIDTestData.showDisplayNames(pw, sampleLocale);
                    }
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static void showDisplayNames(TempPrintWriter pw, String ... locales) {
        GenerateLocaleIDTestData.showDisplayNames(pw, Arrays.asList(locales));
    }

    private static void showDisplayNames(TempPrintWriter pw, Collection<String> locales) {
        for (String locale : locales) {
            String name = ENGLISH.getName(locale, true);
            if (name.contains("null")) {
                System.err.println("** REPLACE: " + locale + "; " + name);
                continue;
            }
            pw.println(locale + "; " + name);
        }
    }
}

