/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.XMLFileReader;

public class GenerateTransform {
    private static final String TRANSFORM_DIRECTORY = CLDRPaths.COMMON_DIRECTORY + "transforms" + File.separator;
    private final Set<Pair<String, String>> pairs = new TreeSet<Pair<String, String>>(new MyComparator(ULocale.ROOT));
    private final Map<String, String> source_target = new LinkedHashMap<String, String>();
    private final Map<String, String> target_source = new LinkedHashMap<String, String>();
    private final UnicodeContext addDotBetween = new UnicodeContext();
    private final UnicodeContext removeDot = new UnicodeContext();
    private final Map<String, String> target_retarget = new LinkedHashMap<String, String>();
    private boolean sourceCased = false;
    private boolean targetCased = false;
    private static final String FALLOFFS = "\u0323\u0324\u0325\u0326\u0317\u0330\u0331";
    static final Transliterator fixup = Transliterator.getInstance("[:Mn:]any-hex/java");

    public void add(String sourceIn, String targetIn) {
        this.add(sourceIn, targetIn, -1);
        if (this.isCased(sourceIn)) {
            this.sourceCased = true;
        }
        if (this.isCased(targetIn)) {
            this.targetCased = true;
        }
    }

    private boolean isCased(String sourceIn) {
        if (UCharacter.toUpperCase(ULocale.ENGLISH, sourceIn).equals(sourceIn)) {
            return true;
        }
        return UCharacter.toLowerCase(ULocale.ENGLISH, sourceIn).equals(sourceIn);
    }

    public GenerateTransform add(String sourceIn, String targetIn, int falloff) {
        String target;
        if (sourceIn.length() == 0 || targetIn.length() == 0) {
            this.throwException(sourceIn, targetIn, "both source and target must be nonempty");
        }
        String source = Normalizer.decompose(sourceIn, false);
        String string = target = falloff < 0 ? Normalizer.decompose(targetIn, false) : Normalizer.decompose(targetIn + FALLOFFS.charAt(falloff), false);
        if (this.source_target.containsKey(source)) {
            this.throwException(sourceIn, targetIn, "source occurs twice");
        }
        if (this.target_source.containsKey(target)) {
            if (falloff >= FALLOFFS.length()) {
                this.throwException(sourceIn, targetIn, "target occurs twice");
            } else {
                return this.add(sourceIn, targetIn, falloff + 1);
            }
        }
        this.source_target.put(source, target);
        this.target_source.put(target, source);
        this.pairs.add(Pair.of(source, target));
        return this;
    }

    private void throwException(String source, String target, String title) {
        throw new IllegalArgumentException(title + ": " + source + " => " + target);
    }

    public String toRules(UnicodeSet sourceSet, UnicodeSet targetSet) {
        StringBuilder result = new StringBuilder();
        if (this.sourceCased && !this.targetCased) {
            result.append("::lowerCase ;\n");
        }
        UnicodeSet missingSource = this.decomposeAndRemoveMarks(sourceSet);
        UnicodeSet missingTarget = this.decomposeAndRemoveMarks(targetSet);
        for (String string : this.target_source.keySet()) {
            String string2 = this.target_source.get(string);
            missingSource.remove(string2);
            missingTarget.remove(string);
            for (String longerTarget : this.target_source.keySet()) {
                String prefixTarget;
                String prefixSource;
                int prefixLength = longerTarget.length() - string.length();
                if (prefixLength <= 0 || !longerTarget.endsWith(string) || (prefixSource = this.target_source.get(prefixTarget = longerTarget.substring(0, prefixLength))) == null) continue;
                this.addDotBetween.add(prefixSource, string);
                this.removeDot.add(prefixTarget, string2);
            }
        }
        Set<UnicodeSet[]> items = this.addDotBetween.get();
        if (items.size() != 0) {
            result.append("# Sequences requiring insertion of hyphenation point for disambiguation\n");
            for (UnicodeSet[] unicodeSetArray : items) {
                result.append(this.show(unicodeSetArray[0]) + " {} " + this.show(unicodeSetArray[1]) + " \u2192 \u2027 ;\n");
            }
        }
        result.append("# Main rules\n");
        for (Pair<String, String> pair : this.pairs) {
            if (pair.getFirst().length() == 0) continue;
            result.append(pair.getFirst() + " \u2194 " + pair.getSecond() + " ;\n");
        }
        items = this.removeDot.get();
        if (items.size() != 0) {
            result.append("# Removal of hyphenation point for disambiguation\n");
            for (UnicodeSet[] unicodeSetArray : items) {
                result.append(" \u2190 " + this.show(unicodeSetArray[0]) + " {\u2027} " + this.show(unicodeSetArray[1]) + " ;\n");
            }
        }
        if (this.target_retarget.size() != 0) {
            result.append("# Retargetting items for completeness\n");
            for (String string : this.target_retarget.keySet()) {
                result.append("|" + this.target_retarget.get(string) + " \u2190 " + string + " ;\n");
                missingTarget.remove(string);
            }
        }
        if (missingSource.size() != 0) {
            result.append("# Missing Source: " + missingSource.size() + " - " + missingSource.toPattern(false) + "\n");
        }
        if (missingTarget.size() != 0) {
            result.append("# Missing Target: " + missingTarget.size() + " - " + missingTarget.toPattern(false) + "\n");
        }
        if (!this.sourceCased && this.targetCased) {
            result.append("::(lowerCase) ;\n");
        }
        String string = result.toString();
        return string;
    }

    private UnicodeSet decomposeAndRemoveMarks(UnicodeSet sourceSet) {
        UnicodeSet result = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(sourceSet);
        while (it.next()) {
            String decompose = Normalizer.decompose(it.getString(), true);
            decompose = UCharacter.foldCase(decompose, true);
            result.addAll(Normalizer.decompose(decompose, true));
        }
        return result;
    }

    private String show(UnicodeSet unicodeSet) {
        if (unicodeSet.size() == 1) {
            UnicodeSetIterator it = new UnicodeSetIterator(unicodeSet);
            it.next();
            return it.getString();
        }
        return unicodeSet.toPattern(false);
    }

    public void addFallback(String target, String retarget) {
        this.target_retarget.put(target, retarget);
    }

    public List<String> getCldrTransformNames() {
        return Arrays.asList(new File(TRANSFORM_DIRECTORY).list());
    }

    public GenerateTransform addFromCldrFile(String transformName, int dir) {
        String rules = this.transformFromCldrFile(transformName);
        Transliterator trans = Transliterator.createFromRules(transformName, rules, dir);
        UnicodeSet sourceSet = trans.getSourceSet();
        UnicodeSetIterator it = new UnicodeSetIterator(sourceSet);
        while (it.next()) {
            String source = it.getString();
            this.add(source, trans.transform(source));
        }
        return this;
    }

    public String transformFromCldrFile(String transformName) {
        MyHandler myHandler = new MyHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(TRANSFORM_DIRECTORY + transformName + ".xml", XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
        return myHandler.toString();
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        private StringBuilder output = new StringBuilder();

        MyHandler() {
        }

        public void clear() {
            this.output.setLength(0);
        }

        public String toString() {
            return this.output.toString();
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (path.indexOf("/comment") >= 0) {
                if (!((String)value).trim().startsWith("#")) {
                    value = (String)value + "# ";
                }
                this.output.append((String)value).append("\n");
            } else if (path.indexOf("/tRule") >= 0) {
                value = fixup.transliterate((String)value);
                this.output.append((String)value).append("\n");
            } else if (path.indexOf("/version") < 0 && path.indexOf("/generation") < 0) {
                throw new IllegalArgumentException("Unknown element: " + path + "\t " + (String)value);
            }
        }
    }

    static class UnicodeContext {
        Map<String, UnicodeSet> first_second = new LinkedHashMap<String, UnicodeSet>();

        UnicodeContext() {
        }

        void add(String a, String b) {
            UnicodeSet second = this.first_second.get(a);
            if (second == null) {
                second = new UnicodeSet();
                this.first_second.put(a, second);
            }
            second.add(b);
        }

        Set<UnicodeSet[]> get() {
            LinkedHashMap<UnicodeSet, UnicodeSet> second_first = new LinkedHashMap<UnicodeSet, UnicodeSet>();
            for (String first : this.first_second.keySet()) {
                UnicodeSet second = this.first_second.get(first);
                UnicodeSet firstSet = (UnicodeSet)second_first.get(second);
                if (firstSet == null) {
                    firstSet = new UnicodeSet();
                    second_first.put(second, firstSet);
                }
                firstSet.add(first);
            }
            LinkedHashSet<UnicodeSet[]> result = new LinkedHashSet<UnicodeSet[]>();
            for (UnicodeSet second : second_first.keySet()) {
                UnicodeSet first = (UnicodeSet)second_first.get(second);
                result.add(new UnicodeSet[]{first, second});
            }
            return result;
        }
    }

    static class MyComparator
    implements Comparator<Pair<String, String>> {
        private Collator collator;

        public MyComparator(ULocale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(15);
        }

        @Override
        public int compare(Pair<String, String> arg0, Pair<String, String> arg1) {
            int result = arg0.getFirst().length() - arg1.getFirst().length();
            if (result != 0) {
                return -result;
            }
            result = arg0.getSecond().length() - arg1.getSecond().length();
            if (result != 0) {
                return -result;
            }
            result = this.collator.compare(arg0.getFirst(), arg1.getFirst());
            return result;
        }
    }
}

