/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;

public class CldrXmlWriter {
    private static final boolean WRITE_COMMENTS_THAT_NO_LONGER_HAVE_BASE = false;
    private final Set<String> orderedSet;
    private final Map<String, ?> options;
    private final PrintWriter pw;
    private final CLDRFile cldrFile;
    private final Set<String> identitySet;
    private final Predicate<String> skipTest;
    private final boolean isResolved;
    private final XPathParts.Comments tempComments;
    private final XMLSource xmlSource;
    private String firstFullPath = null;
    private XPathParts firstFullPathParts = null;
    private DtdType dtdType = DtdType.ldml;
    private boolean suppressInheritanceMarkers = false;
    private XPathParts last = null;
    private static final Splitter LINE_SPLITTER = Splitter.on('\n');

    public CldrXmlWriter(CLDRFile cldrFile, PrintWriter pw, Map<String, ?> options) {
        this.options = options;
        this.pw = pw;
        this.cldrFile = cldrFile;
        this.xmlSource = cldrFile.dataSource;
        this.orderedSet = new TreeSet<String>(cldrFile.getComparator());
        this.xmlSource.forEach(this.orderedSet::add);
        if (this.orderedSet.size() > 0) {
            String firstPath = this.orderedSet.iterator().next();
            this.firstFullPath = cldrFile.getFullXPath(firstPath);
            this.firstFullPathParts = XPathParts.getFrozenInstance(this.firstFullPath);
            this.dtdType = DtdType.valueOf(this.firstFullPathParts.getElement(0));
        }
        this.identitySet = new TreeSet<String>(cldrFile.getComparator());
        this.isResolved = this.xmlSource.isResolving();
        this.tempComments = (XPathParts.Comments)this.xmlSource.getXpathComments().clone();
        this.skipTest = (Predicate)options.get("SKIP_PATH");
    }

    public void write() {
        this.start();
        this.firstLoop();
        this.secondLoop();
        this.finish();
    }

    private void start() {
        this.pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        if (!this.options.containsKey("DTD_OMIT")) {
            String fixedPath = "../../" + this.dtdType.dtdPath;
            if (this.options.containsKey("DTD_DIR")) {
                String dtdDir = this.options.get("DTD_DIR").toString();
                fixedPath = dtdDir + this.dtdType + ".dtd";
            }
            this.pw.println("<!DOCTYPE " + this.dtdType + " SYSTEM \"" + fixedPath + "\">");
        }
        if (this.options.containsKey("COMMENT")) {
            this.pw.println("<!-- " + this.options.get("COMMENT") + " -->");
        }
        if (this.options.containsKey("SUPPRESS_IM")) {
            this.suppressInheritanceMarkers = true;
        }
        if (!this.cldrFile.isNonInheriting()) {
            this.initializeIdentity();
        }
        String initialComment = this.fixInitialComment(this.xmlSource.getXpathComments().getInitialComment());
        XPathParts.writeComment(this.pw, 0, initialComment, true);
    }

    private void initializeIdentity() {
        String[] variants;
        Object ldml_identity = "//ldml/identity";
        if (this.firstFullPath != null) {
            ldml_identity = this.firstFullPath.contains("/identity") ? this.firstFullPathParts.toString(2) : this.firstFullPathParts.toString(1) + "/identity";
        }
        this.identitySet.add((String)ldml_identity + "/version[@number=\"$Revision$\"]");
        LocaleIDParser lip = new LocaleIDParser();
        lip.set(this.xmlSource.getLocaleID());
        this.identitySet.add((String)ldml_identity + "/language[@type=\"" + lip.getLanguage() + "\"]");
        if (lip.getScript().length() != 0) {
            this.identitySet.add((String)ldml_identity + "/script[@type=\"" + lip.getScript() + "\"]");
        }
        if (lip.getRegion().length() != 0) {
            this.identitySet.add((String)ldml_identity + "/territory[@type=\"" + lip.getRegion() + "\"]");
        }
        for (String variant : variants = lip.getVariants()) {
            this.identitySet.add((String)ldml_identity + "/variant[@type=\"" + variant + "\"]");
        }
    }

    private void firstLoop() {
        for (String xpath : this.identitySet) {
            if (this.isResolved && xpath.contains("/alias")) continue;
            XPathParts current = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
            current.writeDifference(this.pw, current, this.last, "", this.tempComments);
            this.last = current;
        }
    }

    private void secondLoop() {
        for (String xpath : this.orderedSet) {
            XPathParts currentFiltered;
            String v;
            if (this.skipTest != null && this.skipTest.test(xpath) || this.isResolved && xpath.contains("/alias") || (v = this.cldrFile.getStringValue(xpath)) == null || this.suppressInheritanceMarkers && CldrUtility.INHERITANCE_MARKER.equals(v) || (currentFiltered = XPathParts.getFrozenInstance(xpath).cloneAsThawed()).size() >= 2 && currentFiltered.getElement(1).equals("identity")) continue;
            XPathParts current = XPathParts.getFrozenInstance(this.cldrFile.getFullXPath(xpath)).cloneAsThawed();
            current.writeDifference(this.pw, currentFiltered, this.last, v, this.tempComments);
            this.last = current;
        }
        this.last.writeLast(this.pw);
    }

    private void finish() {
        String finalComment = this.xmlSource.getXpathComments().getFinalComment();
        XPathParts.writeComment(this.pw, 0, finalComment, true);
    }

    private String fixInitialComment(String initialComment) {
        if (initialComment == null || initialComment.isEmpty()) {
            return CldrUtility.getCopyrightString();
        }
        boolean fe0fNote = false;
        StringBuilder sb = new StringBuilder(CldrUtility.getCopyrightString()).append("\n");
        for (String line : LINE_SPLITTER.split(initialComment)) {
            if (line.startsWith("Warnings: All cp values have U+FE0F characters removed.")) {
                fe0fNote = true;
                continue;
            }
            if (line.contains("Copyright") || line.contains("\u00a9") || line.contains("trademark") || line.startsWith("CLDR data files are interpreted") || line.startsWith("SPDX-License-Identifier") || line.startsWith("For terms of use") || line.startsWith("according to the LDML specification") || line.startsWith("terms of use, see http://www.unicode.org/copyright.html")) continue;
            sb.append("\n").append(line);
        }
        if (fe0fNote) {
            sb.append("\n");
            sb.append("Warnings: All cp values have U+FE0F characters removed. See /annotationsDerived/ for derived annotations.");
            sb.append("\n");
        }
        return sb.toString();
    }
}

