/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import java.util.Locale;

public enum CodePointEscaper {
    TAB(9, "tab"),
    LF(10, "line feed"),
    CR(13, "carriage return"),
    SP(32, "space", "ASCII space"),
    NSP(8201, "narrow/thin space", "Also known as \u2018thin space\u2019"),
    NBSP(160, "no-break space", "Same as space, but doesn\u2019t line wrap."),
    NNBSP(8239, "narrow/thin no-break space", "Same as narrow space, but doesn\u2019t line wrap."),
    WNJ(8203, "allow line wrap after, aka ZWSP", "Invisible character allowing a line-wrap afterwards. Also known as \u2018ZWSP\u2019."),
    WJ(8288, "prevent line wrap", "Keeps adjacent characters from line-wrapping. Also known as \u2018word-joiner\u2019."),
    SHY(173, "soft hyphen", "Invisible character allowing a line-wrap afterwards, but appears like a hyphen in most languages."),
    ZWNJ(8204, "cursive non-joiner", "Breaks cursive connections, where possible."),
    ZWJ(8205, "cursive joiner", "Forces cursive connections, if possible."),
    ALM(1564, "Arabic letter mark", "For BIDI, invisible character that behaves like Arabic letter."),
    LRM(8206, "left-right mark", "For BIDI, invisible character that behaves like Hebrew letter."),
    RLM(8207, "right-left mark", "For BIDI, invisible character that behaves like Latin letter."),
    LRO(8237, "left-right override"),
    RLO(8238, "right-left override"),
    PDF(8236, "end override"),
    BOM(65279, "byte-order mark"),
    ANS(1536, "Arabic number sign"),
    ASNS(1537, "Arabic sanah sign"),
    AFM(1538, "Arabic footnote marker"),
    ASFS(1539, "Arabic safha sign"),
    SAM(1807, "Syriac abbreviation mark"),
    KIAQ(6068, "Khmer inherent aq"),
    KIAA(6069, "Khmer inherent aa"),
    RANGE(10134, "range syntax mark", "heavy minus sign"),
    ESCS(10096, "escape start", "heavy open angle bracket"),
    ESCE(10097, "escape end", "heavy close angle bracket");

    public static final char RANGE_SYNTAX;
    public static final char ESCAPE_START;
    public static final char ESCAPE_END;
    private static final UnicodeMap<CodePointEscaper> _fromCodePoint;
    public static final UnicodeSet EMOJI_INVISIBLES;
    public static final UnicodeSet FORCE_ESCAPE;
    public static final UnicodeSet NON_SPACING;
    public static final UnicodeSet FORCE_ESCAPE_WITH_NONSPACING;
    private final int codePoint;
    private final String shortName;
    private final String description;
    private static final String HAS_NAME = " \u2261 ";

    private CodePointEscaper(int codePoint, String shortName) {
        this.codePoint = codePoint;
        this.shortName = shortName;
        this.description = "";
    }

    private CodePointEscaper(int codePoint, String shortName, String description) {
        this.codePoint = codePoint;
        this.shortName = shortName;
        this.description = description;
    }

    public static final UnicodeSet getNamedEscapes() {
        return _fromCodePoint.keySet().freeze();
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public String codePointToEscaped() {
        return ESCAPE_START + CodePointEscaper.rawCodePointToEscaped(this.codePoint) + ESCAPE_END;
    }

    public static int escapedToCodePoint(String value) {
        if (value.codePointAt(0) != ESCAPE_START || value.codePointAt(value.length() - 1) != ESCAPE_END) {
            throw new IllegalArgumentException("Must be of the form " + ESCAPE_START + "\u2026" + ESCAPE_END);
        }
        return CodePointEscaper.rawEscapedToCodePoint(value.substring(1, value.length() - 1));
    }

    public static String codePointToEscaped(int codePoint) {
        return ESCAPE_START + CodePointEscaper.rawCodePointToEscaped(codePoint) + ESCAPE_END;
    }

    public static String toEscaped(String unescaped) {
        return CodePointEscaper.toEscaped(unescaped, FORCE_ESCAPE);
    }

    public static String toEscaped(String unescaped, UnicodeSet toEscape) {
        StringBuilder result = new StringBuilder();
        unescaped.codePoints().forEach(cp -> {
            if (!toEscape.contains(cp)) {
                result.appendCodePoint(cp);
            } else {
                result.append(CodePointEscaper.codePointToEscaped(cp));
            }
        });
        return result.toString();
    }

    public static String toUnescaped(String value) {
        StringBuilder result = null;
        int donePart = 0;
        int found = value.indexOf(ESCAPE_START);
        while (found >= 0) {
            int foundEnd = value.indexOf(ESCAPE_END, found);
            if (foundEnd < 0) {
                throw new IllegalArgumentException("Malformed escaped string, missing: " + ESCAPE_END);
            }
            if (result == null) {
                result = new StringBuilder();
            }
            result.append(value, donePart, found);
            donePart = ++foundEnd;
            result.appendCodePoint(CodePointEscaper.escapedToCodePoint(value.substring(found, foundEnd)));
            found = value.indexOf(ESCAPE_START, foundEnd);
        }
        return donePart == 0 ? value : result.append(value, donePart, value.length()).toString();
    }

    public static String toExample(int codePoint) {
        CodePointEscaper cpe = _fromCodePoint.get(codePoint);
        if (cpe == null) {
            return CodePointEscaper.codePointToEscaped(codePoint) + HAS_NAME + UCharacter.getName(codePoint).toLowerCase();
        }
        return CodePointEscaper.codePointToEscaped(cpe.codePoint) + HAS_NAME + cpe.shortName;
    }

    public static int rawEscapedToCodePoint(CharSequence value) {
        try {
            return CodePointEscaper.valueOf((String)value.toString().toUpperCase((Locale)Locale.ROOT)).codePoint;
        }
        catch (Exception exception) {
            int codePoint;
            try {
                codePoint = Integer.parseInt(value.toString(), 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Not a named or hex escape: \u2770" + value + "\u274c\u2771");
            }
            if (codePoint < 0 || codePoint > 0x10FFFF) {
                throw new IllegalArgumentException("Illegal code point: \u2770" + value + "\u274c\u2771");
            }
            return codePoint;
        }
    }

    public static String rawCodePointToEscaped(int codePoint) {
        CodePointEscaper result = _fromCodePoint.get(codePoint);
        return result == null ? Integer.toString(codePoint, 16).toUpperCase(Locale.ROOT) : result.toString();
    }

    static {
        RANGE_SYNTAX = (char)RANGE.getCodePoint();
        ESCAPE_START = (char)ESCS.getCodePoint();
        ESCAPE_END = (char)ESCE.getCodePoint();
        _fromCodePoint = new UnicodeMap();
        for (CodePointEscaper abbr : CodePointEscaper.values()) {
            CodePointEscaper oldValue = _fromCodePoint.get(abbr.codePoint);
            if (oldValue != null) {
                throw new IllegalArgumentException("Abbreviation code points collide: " + oldValue.name() + ", " + abbr.name());
            }
            _fromCodePoint.put(abbr.codePoint, abbr);
        }
        _fromCodePoint.freeze();
        EMOJI_INVISIBLES = new UnicodeSet("[\\uFE0F\\U000E0020-\\U000E007F]").freeze();
        FORCE_ESCAPE = new UnicodeSet("[[:DI:][:Pat_WS:][:WSpace:][:C:][:Z:]]").addAll(CodePointEscaper.getNamedEscapes()).removeAll(EMOJI_INVISIBLES).freeze();
        NON_SPACING = new UnicodeSet("[[:Mn:][:Me:]]").freeze();
        FORCE_ESCAPE_WITH_NONSPACING = new UnicodeSet(FORCE_ESCAPE).addAll(NON_SPACING).freeze();
    }
}

