/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Row;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CldrUtility;

public class Counter<T>
implements Iterable<T>,
Comparable<Counter<T>> {
    Map<T, RWLong> map;
    Comparator<T> comparator;

    public Counter() {
        this(null);
    }

    public Counter(boolean naturalOrdering) {
        this(naturalOrdering ? new CldrUtility.ComparableComparator() : null);
    }

    public Counter(Comparator<T> comparator) {
        if (comparator != null) {
            this.comparator = comparator;
            this.map = new TreeMap<T, RWLong>(comparator);
        } else {
            this.map = new LinkedHashMap<T, RWLong>();
        }
    }

    public Counter<T> add(T obj, long countValue) {
        RWLong count = this.map.get(obj);
        if (count == null) {
            count = new RWLong();
            this.map.put(obj, count);
        }
        count.value += countValue;
        count.time = 0L;
        return this;
    }

    public Counter<T> add(T obj, long countValue, long time) {
        RWLong count = this.map.get(obj);
        if (count == null) {
            count = new RWLong();
            this.map.put(obj, count);
        }
        count.value += countValue;
        count.time = time;
        return this;
    }

    public Counter<T> add(T obj, long countValue, boolean boo) {
        RWLong count = this.map.get(obj);
        if (count == null) {
            count = new RWLong();
            this.map.put(obj, count);
        }
        count.value = countValue;
        count.time = 0L;
        return this;
    }

    public long getCount(T obj) {
        return this.get(obj);
    }

    public long get(T obj) {
        RWLong count = this.map.get(obj);
        return count == null ? 0L : count.value;
    }

    public final long getTime(T obj) {
        RWLong count = this.map.get(obj);
        return count == null ? 0L : count.time;
    }

    public Counter<T> clear() {
        this.map.clear();
        return this;
    }

    public long getTotal() {
        long count = 0L;
        for (T item : this.map.keySet()) {
            count += this.map.get(item).value;
        }
        return count;
    }

    public int getItemCount() {
        return this.size();
    }

    public Set<T> getKeysetSortedByCount(boolean ascending) {
        return this.getKeysetSortedByCount(ascending, null);
    }

    public Set<T> getKeysetSortedByCount(boolean ascending, Comparator<T> byValue) {
        TreeSet<T> count_key = new TreeSet<T>(new EntryComparator<T>(ascending, byValue));
        int counter = 0;
        for (T key : this.map.keySet()) {
            count_key.add(new Entry<T>(this.map.get(key), key, counter++));
        }
        LinkedHashSet result = new LinkedHashSet();
        for (Entry entry : count_key) {
            result.add(entry.value);
        }
        return result;
    }

    public Set<Row.R2<Long, T>> getEntrySetSortedByCount(boolean ascending, Comparator<T> byValue) {
        TreeSet<T> count_key = new TreeSet<T>(new EntryComparator<T>(ascending, byValue));
        int counter = 0;
        for (T key : this.map.keySet()) {
            count_key.add(new Entry<T>(this.map.get(key), key, counter++));
        }
        LinkedHashSet<Row.R2<Long, T>> result = new LinkedHashSet<Row.R2<Long, T>>();
        for (Entry entry : count_key) {
            result.add(Row.of(entry.count.value, entry.value));
        }
        return result;
    }

    public Set<T> getKeysetSortedByKey() {
        TreeSet<T> s2 = new TreeSet<T>(this.comparator);
        s2.addAll(this.map.keySet());
        return s2;
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    public Map<T, RWLong> getMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public Counter<T> addAll(Collection<T> keys, int delta) {
        for (T key : keys) {
            long time = this.getTime(key);
            this.add(key, (long)delta, time);
        }
        return this;
    }

    public Counter<T> addAll(Counter<T> keys) {
        for (T key : keys) {
            long time = this.getTime(key);
            this.add(key, keys.getCount(key), time);
        }
        return this;
    }

    @Override
    public int compareTo(Counter<T> o) {
        T jj;
        long jv;
        T ii;
        long iv;
        Iterator<T> i = this.map.keySet().iterator();
        Iterator<T> j = o.map.keySet().iterator();
        do {
            boolean goti = i.hasNext();
            boolean gotj = j.hasNext();
            if (!goti || !gotj) {
                return goti ? 1 : (gotj ? -1 : 0);
            }
            ii = i.next();
            int result = ((Comparable)ii).compareTo(jj = i.next());
            if (result == 0) continue;
            return result;
        } while ((iv = this.map.get(ii).value) == (jv = o.map.get(jj).value));
        return iv < jv ? -1 : 0;
    }

    public Counter<T> increment(T key) {
        return this.add(key, 1L, this.getTime(key));
    }

    public boolean containsKey(T key) {
        return this.map.containsKey(key);
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Counter<T> remove(T key) {
        this.map.remove(key);
        return this;
    }

    private static class EntryComparator<T>
    implements Comparator<Entry<T>> {
        int countOrdering;
        Comparator<T> byValue;

        public EntryComparator(boolean ascending, Comparator<T> byValue) {
            this.countOrdering = ascending ? 1 : -1;
            this.byValue = byValue;
        }

        @Override
        public int compare(Entry<T> o1, Entry<T> o2) {
            if (o1.count.value < o2.count.value) {
                return -this.countOrdering;
            }
            if (o1.count.value > o2.count.value) {
                return this.countOrdering;
            }
            if (this.byValue != null) {
                return this.byValue.compare(o1.value, o2.value);
            }
            return o1.uniqueness - o2.uniqueness;
        }
    }

    private static class Entry<T> {
        RWLong count;
        T value;
        int uniqueness;

        public Entry(RWLong count, T value, int uniqueness) {
            this.count = count;
            this.value = value;
            this.uniqueness = uniqueness;
        }
    }

    private static final class RWLong
    implements Comparable<RWLong> {
        static int uniqueCount;
        public long value;
        private final int forceUnique;
        public long time;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RWLong() {
            Class<RWLong> clazz = RWLong.class;
            synchronized (RWLong.class) {
                this.forceUnique = uniqueCount++;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(RWLong that) {
            if (that.value < this.value) {
                return -1;
            }
            if (that.value > this.value) {
                return 1;
            }
            if (this == that) {
                return 0;
            }
            RWLong rWLong = this;
            synchronized (rWLong) {
                if (that.forceUnique < this.forceUnique) {
                    return -1;
                }
            }
            return 1;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

