/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CldrUtility;

public final class Counter2<T>
implements Iterable<T>,
Comparable<Counter2<T>> {
    Map<T, Double> map;
    Comparator<T> comparator;
    public static Double ZERO = new Double(0.0);
    public static Double ONE = new Double(1.0);

    public Counter2() {
        this(null);
    }

    public Counter2(boolean naturalOrdering) {
        this(naturalOrdering ? new CldrUtility.ComparableComparator() : null);
    }

    public Counter2(Comparator<T> comparator) {
        if (comparator != null) {
            this.comparator = comparator;
            this.map = new TreeMap<T, Double>(comparator);
        } else {
            this.map = new LinkedHashMap<T, Double>();
        }
    }

    public Counter2<T> add(T obj, Double one2) {
        Double count = this.map.get(obj);
        if (count == null) {
            this.map.put(obj, one2);
        } else {
            this.map.put(obj, this.addN(count, one2));
        }
        return this;
    }

    public Counter2<T> put(T obj, Double one2) {
        this.map.put(obj, one2);
        return this;
    }

    private Double addN(Double count, Double countValue) {
        return count + countValue;
    }

    private int compare(Double a, Double b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public Double getCount(T obj) {
        Double count = this.map.get(obj);
        return count == null ? ZERO : count;
    }

    public Counter2<T> clear() {
        this.map.clear();
        return this;
    }

    public Number getTotal() {
        Double count = ZERO;
        for (T item : this.map.keySet()) {
            count = this.addN(count, this.map.get(item));
        }
        return count;
    }

    public int getItemCount() {
        return this.map.size();
    }

    public Set<T> getKeysetSortedByCount(boolean ascending) {
        return this.getKeysetSortedByCount(ascending, null);
    }

    public Set<T> getKeysetSortedByCount(boolean ascending, Comparator<T> byValue) {
        TreeSet<T> count_key = new TreeSet<T>(new EntryComparator<T>(ascending, byValue));
        int counter = 0;
        for (T key : this.map.keySet()) {
            count_key.add(new Entry<T>(this.map.get(key), key, counter++));
        }
        LinkedHashSet result = new LinkedHashSet();
        for (Entry entry : count_key) {
            result.add(entry.value);
        }
        return result;
    }

    public Set<T> getKeysetSortedByKey() {
        TreeSet<T> s2 = new TreeSet<T>(this.comparator);
        s2.addAll(this.map.keySet());
        return s2;
    }

    public Set<T> keySet() {
        return this.map.keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    public Map<T, Double> getMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public Counter2<T> addAll(Collection<T> keys, Double delta) {
        for (T key : keys) {
            this.add(key, delta);
        }
        return this;
    }

    public Counter2<T> addAll(Counter2<T> keys) {
        for (T key : keys) {
            this.add(key, keys.getCount(key));
        }
        return this;
    }

    @Override
    public int compareTo(Counter2<T> o) {
        T jj;
        Double jv;
        T ii;
        Double iv;
        int comp;
        Iterator<T> i = this.map.keySet().iterator();
        Iterator<T> j = o.map.keySet().iterator();
        do {
            boolean goti = i.hasNext();
            boolean gotj = j.hasNext();
            if (!goti || !gotj) {
                return goti ? 1 : (gotj ? -1 : 0);
            }
            ii = i.next();
            int result = ((Comparable)ii).compareTo(jj = i.next());
            if (result == 0) continue;
            return result;
        } while ((comp = this.compare(iv = this.map.get(ii), jv = o.map.get(jj))) == 0);
        return comp;
    }

    public Counter2<T> increment(T key) {
        return this.add(key, ONE);
    }

    private static class EntryComparator<T>
    implements Comparator<Entry<T>> {
        int countOrdering;
        Comparator<T> byValue;

        public EntryComparator(boolean ascending, Comparator<T> byValue) {
            this.countOrdering = ascending ? 1 : -1;
            this.byValue = byValue;
        }

        @Override
        public int compare(Entry<T> o1, Entry<T> o2) {
            if (o1.count != o2.count) {
                if (o1.count < o2.count) {
                    return -this.countOrdering;
                }
                return this.countOrdering;
            }
            if (this.byValue != null) {
                return this.byValue.compare(o1.value, o2.value);
            }
            return o1.uniqueness - o2.uniqueness;
        }
    }

    private static class Entry<T> {
        double count;
        T value;
        int uniqueness;

        public Entry(Double count, T value, int uniqueness) {
            this.count = count;
            this.value = value;
            this.uniqueness = uniqueness;
        }
    }
}

