/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.unicode.cldr.util.CharSource;
import org.unicode.cldr.util.CharUtilities;

public abstract class Dictionary<T> {
    public static final Comparator<CharSequence> CHAR_SEQUENCE_COMPARATOR = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return CharUtilities.compare(o1, o2);
        }
    };

    public abstract Iterator<Map.Entry<CharSequence, T>> getMapping();

    public String debugShow() {
        return this.toString();
    }

    public abstract Matcher<T> getMatcher();

    public static <A, B> Map<A, B> load(Iterator<Map.Entry<A, B>> input, Map<A, B> output) {
        while (input.hasNext()) {
            Map.Entry<A, B> entry = input.next();
            output.put(entry.getKey(), entry.getValue());
        }
        return output;
    }

    public static class DictionaryCharList<T extends CharSequence>
    extends CharUtilities.CharSourceWrapper<T> {
        protected boolean failOnLength = false;
        protected StringBuilder buffer = new StringBuilder();
        protected int[] sourceOffsets;
        protected Matcher<T> matcher;
        protected boolean atEnd;

        public DictionaryCharList(Dictionary<T> dictionary, T source) {
            super(source);
            this.matcher = dictionary.getMatcher().setText((CharSequence)source);
            this.atEnd = source.length() == 0;
            this.sourceOffsets = new int[source.length()];
        }

        @Override
        public boolean hasCharAt(int index) {
            if (index >= this.buffer.length()) {
                if (this.atEnd) {
                    return false;
                }
                this.growToOffset(index + 1);
                return index < this.buffer.length();
            }
            return true;
        }

        @Override
        public char charAt(int index) {
            if (!this.atEnd && index >= this.buffer.length()) {
                this.growToOffset(index + 1);
            }
            return this.buffer.charAt(index);
        }

        private void growToOffset(int offset) {
            int length = this.buffer.length();
            while (length < offset && !this.atEnd) {
                Matcher.Status status = this.matcher.next(Matcher.Filter.LONGEST_MATCH);
                int currentOffset = this.matcher.getOffset();
                int matchEnd = this.matcher.getMatchEnd();
                if (status == Matcher.Status.MATCH) {
                    CharSequence replacement = (CharSequence)this.matcher.getMatchValue();
                    this.setOffsets(length + 1, replacement.length(), matchEnd);
                    this.buffer.append(replacement);
                    length = this.buffer.length();
                    this.matcher.setOffset(matchEnd);
                } else {
                    this.setOffsets(length + 1, 1, currentOffset + 1);
                    this.buffer.append(this.source.charAt(currentOffset));
                    length = this.buffer.length();
                    this.matcher.nextOffset();
                }
                this.atEnd = this.matcher.getOffset() >= this.source.length();
            }
        }

        private void setOffsets(int start, int count, int value) {
            int length = start + count;
            if (this.sourceOffsets.length < length) {
                int newCapacity = this.sourceOffsets.length * 2 + 1;
                if (newCapacity < length + 50) {
                    newCapacity = length + 50;
                }
                int[] temp = new int[newCapacity];
                System.arraycopy(this.sourceOffsets, 0, temp, 0, this.sourceOffsets.length);
                this.sourceOffsets = temp;
            }
            for (int i = start; i < length; ++i) {
                this.sourceOffsets[i] = value;
            }
        }

        @Override
        public int fromSourceOffset(int offset) {
            return Arrays.binarySearch(this.sourceOffsets, offset);
        }

        @Override
        public int toSourceOffset(int offset) {
            if (offset > this.buffer.length()) {
                this.growToOffset(offset);
                if (offset > this.buffer.length()) {
                    throw new ArrayIndexOutOfBoundsException(offset);
                }
            }
            return this.sourceOffsets[offset];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (!this.atEnd && end > this.buffer.length()) {
                this.growToOffset(end);
            }
            return this.buffer.subSequence(start, end);
        }

        @Override
        public CharSequence sourceSubSequence(int start, int end) {
            return this.source.subSequence(this.toSourceOffset(start), this.toSourceOffset(end));
        }

        @Override
        public int getKnownLength() {
            return this.buffer.length();
        }
    }

    public static abstract class Matcher<T> {
        protected CharSource text;
        protected int offset;
        protected int matchEnd;
        protected T matchValue;

        public boolean hasCharAt(int index) {
            return this.text.hasCharAt(index);
        }

        public Matcher<T> setText(CharSource text) {
            this.text = text;
            return this.setOffset(0);
        }

        public Matcher<T> setText(CharSequence text) {
            this.text = new CharUtilities.CharSourceWrapper<CharSequence>(text);
            return this.setOffset(0);
        }

        public CharSource getText() {
            return this.text;
        }

        public Matcher<T> setOffset(int offset) {
            this.offset = offset;
            this.matchEnd = offset;
            return this;
        }

        public int getOffset() {
            return this.offset;
        }

        public T getMatchValue() {
            return this.matchValue;
        }

        public int getMatchEnd() {
            return this.matchEnd;
        }

        public CharSource getMatchText() {
            return this.text.sublist(this.offset, this.matchEnd);
        }

        public abstract Status next();

        public Status next(Filter filter) {
            if (filter == Filter.ALL) {
                return this.next();
            }
            Status lastStatus = Status.NONE;
            Object lastValue = null;
            int lastEnd = -1;
            while (true) {
                Status status;
                if ((status = this.next()) == Status.NONE) {
                    if (lastValue == null) {
                        return status;
                    }
                    this.matchEnd = lastEnd;
                    this.matchValue = lastValue;
                    return lastStatus;
                }
                if (status != Status.MATCH && (status != Status.PARTIAL || filter != Filter.LONGEST && (filter != Filter.LONGEST_UNIQUE || !this.nextUniquePartial()) && (filter != Filter.LONGEST_WITH_FINAL_PARTIAL || this.text.hasCharAt(this.matchEnd)))) continue;
                if (filter == Filter.MATCHES) {
                    return status;
                }
                lastStatus = status;
                lastValue = this.getMatchValue();
                lastEnd = this.matchEnd;
            }
        }

        public abstract boolean nextUniquePartial();

        public T get(CharSource text) {
            this.setText(text);
            do {
                Status next1;
                if ((next1 = this.next()) == Status.MATCH) continue;
                return null;
            } while (text.hasCharAt(this.getMatchEnd()));
            return this.getMatchValue();
        }

        public Status find(Filter filter) {
            Status status;
            while ((status = this.next(filter)) == Status.NONE) {
                if (!this.text.hasCharAt(this.getMatchEnd())) {
                    return status;
                }
                this.nextOffset();
            }
            return status;
        }

        public Matcher nextOffset() {
            return this.setOffset(++this.offset);
        }

        public Appendable convert(Appendable target) {
            try {
                while (this.text.hasCharAt(this.offset)) {
                    Status status = this.next();
                    if (status != Status.MATCH) {
                        target.append(this.text.charAt(this.getOffset()));
                        this.nextOffset();
                        continue;
                    }
                    target.append(this.getMatchValue().toString());
                    this.setOffset(this.getMatchEnd());
                }
                return target;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException("Internal error", e);
            }
        }

        public String toString() {
            return "{offset: " + this.offset + ", end: " + this.matchEnd + ", value: " + this.matchValue + ", text: \"" + this.text.subSequence(0, this.text.getKnownLength()) + (this.text.hasCharAt(this.text.getKnownLength()) ? "..." : "") + "\"}";
        }

        public abstract Dictionary<T> getDictionary();

        public boolean hasMore() {
            return this.text.hasCharAt(this.offset);
        }

        public static enum Filter {
            ALL,
            MATCHES,
            LONGEST_MATCH,
            LONGEST,
            LONGEST_UNIQUE,
            LONGEST_WITH_FINAL_PARTIAL;

        }

        public static enum Status {
            NONE,
            PARTIAL,
            MATCH;

        }
    }

    public static interface DictionaryBuilder<T> {
        public Dictionary<T> make(Map<CharSequence, T> var1);
    }
}

