/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;

public enum DtdType {
    ldml("common/dtd/ldml.dtd", null, null, "main", "annotations", "annotationsDerived", "casing", "collation", "rbnf", "segments", "subdivisions"),
    ldmlICU("common/dtd/ldmlICU.dtd", ldml),
    supplementalData("common/dtd/ldmlSupplemental.dtd", null, null, "supplemental", "supplemental-temp", "transforms", "validity"),
    ldmlBCP47("common/dtd/ldmlBCP47.dtd", "1.7.2", null, "bcp47"),
    keyboard3("keyboards/dtd/ldmlKeyboard3.dtd", "44.0", null, "../keyboards/3.0"),
    keyboardTest3("keyboards/dtd/ldmlKeyboardTest3.dtd", "44.0", null, "../keyboards/test");

    public static final Set<DtdType> STANDARD_SET;
    static Pattern FIRST_ELEMENT;
    public final String dtdPath;
    public final DtdType rootType;
    public final String firstVersion;
    public final Set<String> directories;

    private DtdType(String dtdPath) {
        this(dtdPath, null, null, new String[0]);
    }

    private DtdType(String dtdPath, DtdType realType) {
        this(dtdPath, null, realType, new String[0]);
    }

    private DtdType(String dtdPath, String firstVersion, DtdType realType, String ... directories) {
        this.dtdPath = dtdPath;
        this.rootType = realType == null ? this : realType;
        this.firstVersion = firstVersion;
        this.directories = ImmutableSet.copyOf(directories);
    }

    public static DtdType fromPath(String elementOrPath) {
        Matcher m4 = FIRST_ELEMENT.matcher(elementOrPath);
        m4.lookingAt();
        return DtdType.fromElement(m4.group(1));
    }

    public static DtdType fromElement(String element) {
        return DtdType.valueOf(element);
    }

    public String header(Class<?> generatedBy) {
        Object gline = "";
        if (generatedBy != null) {
            gline = "\n\tGENERATED DATA \u2014 do not manually update!\n\t\tGenerated by tool:\t" + generatedBy.getSimpleName() + "\n";
            for (Annotation annotation : generatedBy.getAnnotations()) {
                if (!(annotation instanceof CLDRTool)) continue;
                gline = (String)gline + "\t\tTool documented on:\t" + ((CLDRTool)annotation).url() + "\n";
                break;
            }
        }
        return "<?xml version='1.0' encoding='UTF-8' ?>\n<!DOCTYPE " + this.rootElement() + " SYSTEM '../../" + this.dtdPath + "'>\n<!--\n" + CldrUtility.getCopyrightString("\t") + (String)gline + " -->\n<" + this.rootElement() + ">\n";
    }

    public String rootElement() {
        if (this.rootType != null) {
            return this.rootType.name();
        }
        return this.name();
    }

    public String getXsdPath() {
        return this.dtdPath.replaceAll("\\.dtd$", ".xsd");
    }

    static {
        STANDARD_SET = ImmutableSet.of(ldmlBCP47, supplementalData, ldml, keyboard3);
        FIRST_ELEMENT = PatternCache.get("//([^/\\[]*)");
    }
}

