/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableList;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LocaleIDParser {
    private String language;
    private String script;
    private String region;
    private String[] variants;
    static final UnicodeSet letters = new UnicodeSet("[a-zA-Z]");
    static final UnicodeSet digits = new UnicodeSet("[0-9]");
    public static final ImmutableList<String> FALLBACK_CHAIN = ImmutableList.of();
    public static final ImmutableList<String> ROOT_PARENT_CHAIN = ImmutableList.of("root");

    public String getLanguage() {
        return this.language;
    }

    public String getLanguageScript() {
        if (this.script.length() != 0) {
            return this.language + "_" + this.script;
        }
        return this.language;
    }

    public static Set<String> getLanguageScript(Collection<String> in) {
        return LocaleIDParser.getLanguageScript(in, null);
    }

    public static Set<String> getLanguageScript(Collection<String> in, Set<String> output) {
        if (output == null) {
            output = new TreeSet<String>();
        }
        LocaleIDParser lparser = new LocaleIDParser();
        Iterator<String> it = in.iterator();
        while (it.hasNext()) {
            output.add(lparser.set(it.next()).getLanguageScript());
        }
        return output;
    }

    public String getRegion() {
        return this.region;
    }

    public String getScript() {
        return this.script;
    }

    public String[] getVariants() {
        return (String[])this.variants.clone();
    }

    public LocaleIDParser set(String localeID) {
        this.script = "";
        this.region = "";
        this.variants = new String[0];
        String[] pieces = new String[100];
        Utility.split(localeID, '_', pieces);
        int i = 0;
        this.language = pieces[i++];
        if (i >= pieces.length) {
            return this;
        }
        if (pieces[i].length() == 4) {
            this.script = pieces[i++];
            if (i >= pieces.length) {
                return this;
            }
        }
        if (pieces[i].length() == 2 && letters.containsAll(pieces[i]) || pieces[i].length() == 3 && digits.containsAll(pieces[i])) {
            this.region = pieces[i++];
            if (i >= pieces.length) {
                return this;
            }
        }
        ArrayList<String> al = new ArrayList<String>();
        while (i < pieces.length && pieces[i].length() > 0) {
            al.add(pieces[i++]);
        }
        this.variants = new String[al.size()];
        al.toArray(this.variants);
        return this;
    }

    public static final String getParent(String localeName) {
        return LocaleIDParser.getParent(localeName, false);
    }

    public static String getParent(String localeName, boolean ignoreParentLocale) {
        String explicitParent;
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
        if (!ignoreParentLocale && (explicitParent = sdi.getExplicitParentLocale(localeName)) != null) {
            return explicitParent;
        }
        int pos = localeName.lastIndexOf(95);
        if (pos >= 0) {
            String defaultScript;
            String script;
            String truncated = localeName.substring(0, pos);
            int pos2 = LocaleIDParser.getScriptPosition(localeName);
            if (pos2 > 0 && !ignoreParentLocale && !(script = localeName.substring(pos + 1)).equals(defaultScript = sdi.getDefaultScript(truncated))) {
                return "root";
            }
            if (truncated.length() == 0) {
                return "root";
            }
            return truncated;
        }
        if (localeName.equals("root")) {
            return null;
        }
        return "root";
    }

    public static String getSimpleBaseLanguage(String localeID) {
        int pos = localeID.indexOf(95);
        if (pos >= 0) {
            return localeID.substring(0, pos);
        }
        return localeID;
    }

    public static int getScriptPosition(String locale) {
        int pos2;
        int pos = locale.indexOf(95);
        if (pos >= 0 && pos + 5 == locale.length() && (pos2 = locale.indexOf(95, pos + 1)) < 0) {
            return pos;
        }
        return -1;
    }

    public static String getSimpleParent(String localeName) {
        int pos = localeName.lastIndexOf(95);
        if (pos >= 0) {
            return localeName.substring(0, pos);
        }
        if (localeName.equals("root") || localeName.equals("supplementalData")) {
            return null;
        }
        return "root";
    }

    public LocaleIDParser setLanguage(String language) {
        this.language = language;
        return this;
    }

    public LocaleIDParser setRegion(String region) {
        this.region = region;
        return this;
    }

    public LocaleIDParser setScript(String script) {
        this.script = script;
        return this;
    }

    public LocaleIDParser setVariants(String[] variants) {
        this.variants = (String[])variants.clone();
        return this;
    }

    public Set<Level> getLevels() {
        EnumSet<Level> result = EnumSet.of(Level.Language);
        if (this.getScript().length() != 0) {
            result.add(Level.Script);
        }
        if (this.getRegion().length() != 0) {
            result.add(Level.Region);
        }
        if (this.getVariants().length != 0) {
            result.add(Level.Variants);
        }
        return result;
    }

    public Set<String> getSiblings(Set<String> set) {
        Set<Level> myLevel = this.getLevels();
        String localeID = this.toString();
        String parentID = LocaleIDParser.getParent(localeID);
        String prefix = parentID == null || "root".equals(parentID) ? "" : parentID + "_";
        TreeSet<String> siblings = new TreeSet<String>();
        for (String id : set) {
            if (!id.startsWith(prefix) || !this.set(id).getLevels().equals(myLevel)) continue;
            siblings.add(id);
        }
        this.set(localeID);
        return siblings;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.language);
        if (this.script.length() != 0) {
            result.append('_').append(this.script);
        }
        if (this.region.length() != 0) {
            result.append('_').append(this.region);
        }
        if (this.variants != null) {
            for (int i = 0; i < this.variants.length; ++i) {
                result.append('_').append(this.variants[i]);
            }
        }
        return result.toString();
    }

    public static List<String> getParentChain(String localeID) {
        if ("root".equals(localeID)) {
            return FALLBACK_CHAIN;
        }
        ArrayList<String> result = null;
        while (true) {
            String parent;
            if ((parent = LocaleIDParser.getParent(localeID)).equals("root")) {
                if (result == null) {
                    return ROOT_PARENT_CHAIN;
                }
                result.addAll(ROOT_PARENT_CHAIN);
                return ImmutableList.copyOf(result);
            }
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(parent);
            localeID = parent;
        }
    }

    public static boolean isL1(String localeId) {
        return "root".equals(LocaleIDParser.getParent(localeId));
    }

    public static enum Level {
        Language,
        Script,
        Region,
        Variants,
        Other;

    }
}

