/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.LocaleSet;

public class LocaleNormalizer {
    public static final String NO_LOCALES = "none";
    public static final String ALL_LOCALES = "*";
    public static final LocaleSet ALL_LOCALES_SET = new LocaleSet(true);
    private static LocaleSet knownLocales = null;
    private Map<String, LocaleRejection> messages = null;

    public static boolean isAllLocales(String localeList) {
        return localeList != null && (localeList.contains(ALL_LOCALES) || localeList.trim().equals("all"));
    }

    public static void setKnownLocales(Set<CLDRLocale> localeListSet) {
        knownLocales = new LocaleSet();
        knownLocales.addAll(localeListSet);
    }

    public String normalize(String list) {
        return LocaleNormalizer.norm(this, list, null);
    }

    public static String normalizeQuietly(String list) {
        return LocaleNormalizer.norm(null, list, null);
    }

    public String normalizeForSubset(String list, LocaleSet orgLocaleSet) {
        return LocaleNormalizer.norm(this, list, orgLocaleSet);
    }

    private static String norm(LocaleNormalizer locNorm, String list, LocaleSet orgLocaleSet) {
        if (list == null) {
            return "";
        }
        if ((list = list.trim()).isEmpty() || NO_LOCALES.equals(list)) {
            return "";
        }
        if (LocaleNormalizer.isAllLocales(list)) {
            return ALL_LOCALES;
        }
        LocaleSet locSet = LocaleNormalizer.setFromString(locNorm, list, orgLocaleSet);
        return locSet.toString();
    }

    private void addMessage(String locale, LocaleRejection rejection) {
        if (this.messages == null) {
            this.messages = new TreeMap<String, LocaleRejection>();
        }
        this.messages.put(locale, rejection);
    }

    public boolean hasMessage() {
        return this.messages != null && !this.messages.isEmpty();
    }

    public String getMessagePlain() {
        return String.join((CharSequence)"\n", this.getMessageArrayPlain());
    }

    public String getMessageHtml() {
        return String.join((CharSequence)"<br />\n", this.getMessageArrayPlain());
    }

    public String[] getMessageArrayPlain() {
        return this.getMessagesPlain().toArray(new String[0]);
    }

    public Collection<String> getMessagesPlain() {
        return this.getMessages().entrySet().stream().map(e -> e.getValue() + ": " + (String)e.getKey()).collect(Collectors.toList());
    }

    public Map<String, LocaleRejection> getMessages() {
        if (this.messages == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.messages);
    }

    public static LocaleSet setFromStringQuietly(String locales, LocaleSet orgLocaleSet) {
        return LocaleNormalizer.setFromString(null, locales, orgLocaleSet);
    }

    private static LocaleSet setFromString(LocaleNormalizer locNorm, String localeList, LocaleSet orgLocaleSet) {
        String[] array;
        if (LocaleNormalizer.isAllLocales(localeList)) {
            if (orgLocaleSet == null || orgLocaleSet.isAllLocales()) {
                return ALL_LOCALES_SET;
            }
            return LocaleNormalizer.intersectKnownWithOrgLocales(orgLocaleSet);
        }
        LocaleSet newSet = new LocaleSet();
        if (localeList == null || (localeList = localeList.trim()).length() == 0) {
            return newSet;
        }
        for (String s2 : array = localeList.split("[, \t\u00a0\\s]+")) {
            CLDRLocale locale = CLDRLocale.getInstance(s2);
            if (knownLocales == null || knownLocales.contains(locale)) {
                if (orgLocaleSet == null || orgLocaleSet.containsLocaleOrParent(locale)) {
                    newSet.add(locale);
                    continue;
                }
                if (locNorm == null) continue;
                locNorm.addMessage(locale.getBaseName(), LocaleRejection.outside_org_coverage);
                continue;
            }
            if (locNorm == null) continue;
            locNorm.addMessage(locale.getBaseName(), LocaleRejection.unknown);
        }
        return newSet;
    }

    private static LocaleSet intersectKnownWithOrgLocales(LocaleSet orgLocaleSet) {
        if (knownLocales == null) {
            LocaleSet orgSetCopy = new LocaleSet();
            orgSetCopy.addAll(orgLocaleSet.getSet());
            return orgSetCopy;
        }
        LocaleSet intersection = new LocaleSet();
        for (CLDRLocale locale : knownLocales.getSet()) {
            if (!orgLocaleSet.containsLocaleOrParent(locale)) continue;
            intersection.add(locale);
        }
        return intersection;
    }

    public static enum LocaleRejection {
        outside_org_coverage("Outside org. coverage"),
        unknown("Unknown");

        final String message;

        private LocaleRejection(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

