/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.LocaleNormalizer;
import org.unicode.cldr.util.LocaleSet;
import org.unicode.cldr.util.StandardCodes;

public enum Organization {
    adlam("Winden Jangen Adlam", new String[0]),
    adobe("Adobe", new String[0]),
    afghan_csa("Afghan CSA", new String[0]),
    afghan_mcit("Afghan MCIT", new String[0]),
    afrigen("Afrigen", new String[0]),
    anii("Anii Research Group", new String[0]),
    apple("Apple", new String[0]),
    bangladesh("Bangladesh", "Bangladesh Computer Council"),
    bangor_univ("Bangor Univ.", new String[0]),
    bhutan("Bhutan DDC", new String[0]),
    breton("Office of Breton Lang", new String[0]),
    cherokee("Cherokee Nation", new String[0]),
    choctaw("Choctaw Nation", new String[0]),
    cldr("Cldr", new String[0]),
    gaeilge("Foras na Gaeilge", new String[0]),
    georgia_isi("Georgia ISI", new String[0]),
    gnome("Gnome Foundation", new String[0]),
    google("Google", new String[0]),
    ibm("IBM", new String[0]),
    india("India MIT", new String[0]),
    iran_hci("Iran HCI", new String[0]),
    kendra("Kendra (Nepal)", new String[0]),
    kotoistus("Kotoistus (Finnish IT Ctr)", new String[0]),
    kunsill_malti("Il-Kunsill Nazzjonali tal-Ilsien Malti", "National Council for the Maltese Language", "malta", "malti"),
    lakota_lc("Lakota LC", new String[0]),
    lao_dpt("Lao Posts/Telecom", new String[0]),
    longnow("The Long Now Foundation", "Long Now", "PanLex", "Utilika", "Utilka Foundation"),
    meta("Meta", "Facebook"),
    microsoft("Microsoft", new String[0]),
    mikmaw_kinamatnewey("Mi'kmaw Kina'matnewey", new String[0]),
    mozilla("Mozilla", new String[0]),
    netflix("Netflix", new String[0]),
    nyiakeng_puachue_hmong("Nyiakeng Puachue Hmong", new String[0]),
    openinstitute("Open Inst (Cambodia)", new String[0]),
    openoffice_org("Open Office", new String[0]),
    oracle("Oracle", "sun", "Sun Micro"),
    pakistan("Pakistan", new String[0]),
    rodakych("Rodakych", "Nigerian Pidgin"),
    rohingyazuban("Rohingya Language Council", "RLC", "Rohingya Zuban"),
    rumantscha("Lia Rumantscha", new String[0]),
    sardware("Sardware", "Sardware"),
    sil("SIL", "SIL International"),
    special("High Coverage and Generated", new String[0]),
    srilanka("Sri Lanka ICTA", "Sri Lanka"),
    surveytool("Survey Tool", new String[0]),
    unaffiliated("Unaffiliated", "Guest"),
    venetian("VeC - Lengua Veneta", new String[0]),
    welsh_lc("Welsh LC", new String[0]),
    wikimedia("Wikimedia Foundation", new String[0]),
    wod_nko("WOD N\u2019ko", "World Organization for the Development of N\u2019ko", "WODN"),
    wsci_wg("WSC+I WG", "Western Swampy Cree+Internet Working Group"),
    yahoo("Yahoo", new String[0]);

    private static final Set<Organization> TC_ORGS;
    private final String displayName;
    private final String[] names;
    static final Map<String, Organization> OrganizationNameMap;
    private LocaleSet localeSet = null;

    public static Set<Organization> getTCOrgs() {
        return TC_ORGS;
    }

    public boolean isTCOrg() {
        return Organization.getTCOrgs().contains((Object)this);
    }

    public static Organization fromString(String name) {
        if (name == null) {
            throw new NullPointerException("Organization.fromString(null) called");
        }
        if (name.contains("Government of Pakistan")) {
            return pakistan;
        }
        if (name.contains("Utilika")) {
            return longnow;
        }
        name = name.toLowerCase().replace('-', '_').replace('.', '_');
        return OrganizationNameMap.get(name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private Organization(String displayName, String ... names) {
        this.displayName = displayName;
        this.names = names;
    }

    public LocaleSet getCoveredLocales() {
        if (this.localeSet == null) {
            Set<String> localeNameSet = StandardCodes.make().getLocaleCoverageLocales(this);
            this.localeSet = localeNameSet.contains("*") ? LocaleNormalizer.ALL_LOCALES_SET : new LocaleSet(localeNameSet);
        }
        return this.localeSet;
    }

    public boolean visibleOnFrontEnd() {
        return this != special;
    }

    static {
        TC_ORGS = ImmutableSet.copyOf(EnumSet.of(apple, google, meta, microsoft));
        OrganizationNameMap = new HashMap<String, Organization>();
        for (Organization x : Organization.values()) {
            OrganizationNameMap.put(x.displayName.toLowerCase().replace('-', '_').replace('.', '_'), x);
            for (String name : x.names) {
                OrganizationNameMap.put(name.toLowerCase().replace('-', '_').replace('.', '_'), x);
            }
            OrganizationNameMap.put(x.name().toLowerCase().replace('-', '_').replace('.', '_'), x);
        }
    }
}

