/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Transform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XPathParts;

public class PathStarrer
implements Transform<String, String> {
    public static final String STAR_PATTERN = "([^\"]*+)";
    private String starredPathString;
    private final List<String> attributes = new ArrayList<String>();
    private final List<String> protectedAttributes = Collections.unmodifiableList(this.attributes);
    private String substitutionPattern = "([^\"]*+)";
    private static final Pattern ATTRIBUTE_PATTERN_OLD = PatternCache.get("=\"([^\"]*)\"");
    private final StringBuilder starredPathOld = new StringBuilder();

    public String set(String path) {
        XPathParts parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
        return this.set(parts, Collections.emptySet());
    }

    public String set(XPathParts parts, Set<String> skipAttributes) {
        this.attributes.clear();
        for (int i = 0; i < parts.size(); ++i) {
            for (String key : parts.getAttributeKeys(i)) {
                if (skipAttributes.contains(key)) continue;
                this.attributes.add(parts.getAttributeValue(i, key));
                parts.setAttribute(i, key, this.substitutionPattern);
            }
        }
        this.starredPathString = parts.toString();
        return this.starredPathString;
    }

    public String setOld(String path) {
        Matcher starAttributeMatcher = ATTRIBUTE_PATTERN_OLD.matcher(path);
        this.starredPathOld.setLength(0);
        this.attributes.clear();
        int lastEnd = 0;
        while (starAttributeMatcher.find()) {
            int start = starAttributeMatcher.start(1);
            int end = starAttributeMatcher.end(1);
            this.starredPathOld.append(path.substring(lastEnd, start));
            this.starredPathOld.append(this.substitutionPattern);
            this.attributes.add(path.substring(start, end));
            lastEnd = end;
        }
        this.starredPathOld.append(path.substring(lastEnd));
        this.starredPathString = this.starredPathOld.toString();
        return this.starredPathString;
    }

    public List<String> getAttributes() {
        return this.protectedAttributes;
    }

    public String getAttributesString(String separator) {
        return Joiner.on(separator).join(this.attributes);
    }

    public String getResult() {
        return this.starredPathString;
    }

    public String getSubstitutionPattern() {
        return this.substitutionPattern;
    }

    public PathStarrer setSubstitutionPattern(String substitutionPattern) {
        this.substitutionPattern = substitutionPattern;
        return this;
    }

    @Override
    public String transform(String source) {
        return this.set(source);
    }

    public String transform2(String source) {
        String result = Utility.unescape(this.setOld(source));
        if (result.startsWith("^") && result.endsWith("$")) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }
}

