/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.XMLSource;

public class SimpleFactory
extends Factory {
    private static final boolean USE_OLD_HANDLEMAKE_CODE = false;
    private static final boolean CACHE_SIMPLE_FACTORIES = false;
    private static final int FACTORY_CACHE_LIMIT = 10;
    private static final Object FACTORY_LOOKUP_SYNC = new Object();
    private static final int CACHE_LIMIT = 75;
    private static final boolean DEBUG_SIMPLEFACTORY = false;
    private static final boolean USE_COMBINEDCACHE = false;
    private File[] sourceDirectories;
    private Set<String> localeList = new TreeSet<String>();
    private Cache<CLDRCacheKey, CLDRFile> combinedCache = null;
    private Map<String, CLDRFile>[] mainCache = null;
    private Map<String, CLDRFile>[] resolvedCache = null;
    private CLDRFile.DraftStatus minimalDraftStatus = CLDRFile.DraftStatus.unconfirmed;
    private static Cache<SimpleFactoryCacheKey, SimpleFactory> factoryCache = null;
    private static Cache<SimpleFactoryLookupKey, SimpleFactoryCacheKey> factoryLookupMap = null;

    private SimpleFactory() {
    }

    @Override
    public CLDRFile.DraftStatus getMinimalDraftStatus() {
        return this.minimalDraftStatus;
    }

    public static Factory make(String sourceDirectory, String matchString) {
        return SimpleFactory.make(sourceDirectory, matchString, CLDRFile.DraftStatus.unconfirmed);
    }

    public static Factory make(String sourceDirectory, String matchString, CLDRFile.DraftStatus minimalDraftStatus) {
        File[] list = new File[]{new File(sourceDirectory)};
        return new SimpleFactory(list, matchString, minimalDraftStatus);
    }

    public static Factory make(File[] sourceDirectory, String matchString) {
        return SimpleFactory.make(sourceDirectory, matchString, CLDRFile.DraftStatus.unconfirmed);
    }

    public static Factory make(File[] sourceDirectory, String matchString, CLDRFile.DraftStatus minimalDraftStatus) {
        sourceDirectory = SimpleFactory.filterOutNulls(sourceDirectory);
        return new SimpleFactory(sourceDirectory, matchString, minimalDraftStatus);
    }

    private static File[] filterOutNulls(File[] sourceDirectory) {
        ArrayList<File> result = new ArrayList<File>();
        for (File f : sourceDirectory) {
            if (f == null) continue;
            result.add(f);
        }
        return result.toArray(new File[result.size()]);
    }

    private SimpleFactory(File[] sourceDirectories, String matchString, CLDRFile.DraftStatus minimalDraftStatus) {
        this.combinedCache = CacheBuilder.newBuilder().maximumSize(75L).build();
        this.sourceDirectories = sourceDirectories;
        this.minimalDraftStatus = minimalDraftStatus;
        Matcher m4 = PatternCache.get(matchString).matcher("");
        this.localeList = CLDRFile.getMatchingXMLFiles(sourceDirectories, m4);
        File goodSuppDir = null;
        for (File sourceDirectoryPossibility : sourceDirectories) {
            File suppDir = new File(sourceDirectoryPossibility, "../supplemental");
            if (!suppDir.isDirectory()) continue;
            goodSuppDir = suppDir;
            break;
        }
        if (goodSuppDir != null) {
            this.setSupplementalDirectory(goodSuppDir);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{" + this.getClass().getName()).append(" dirs=");
        for (File f : this.sourceDirectories) {
            sb.append(f.getPath()).append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected Set<String> handleGetAvailable() {
        return this.localeList;
    }

    @Override
    public CLDRFile handleMake(String localeName, boolean resolved, CLDRFile.DraftStatus minimalDraftStatus) {
        List<File> parentDirs = this.getSourceDirectoriesForLocale(localeName);
        if (parentDirs == null) {
            throw new NoSourceDirectoryException(localeName);
        }
        CLDRFile result = null;
        if (resolved) {
            XMLSource.ResolvingSource makeResolvingSource;
            try {
                makeResolvingSource = this.makeResolvingSource(localeName, minimalDraftStatus);
            }
            catch (Exception e) {
                throw new ICUException("Couldn't make resolved CLDR file for " + localeName, e);
            }
            result = new CLDRFile(makeResolvingSource);
        } else if (parentDirs != null) {
            result = new CLDRFile(localeName, parentDirs, minimalDraftStatus);
            result.freeze();
        }
        return result;
    }

    public static CLDRFile makeFromFile(String fullFileName, String localeName, CLDRFile.DraftStatus minimalDraftStatus) {
        return SimpleFactory.makeFromFile(new File(fullFileName), localeName, minimalDraftStatus);
    }

    private static CLDRFile makeFromFile(File file, String localeName, CLDRFile.DraftStatus minimalDraftStatus) {
        return CLDRFile.loadFromFile(file, localeName, minimalDraftStatus);
    }

    private static CLDRFile makeFromFile(List<File> dirs, String localeName, CLDRFile.DraftStatus minimalDraftStatus) {
        return CLDRFile.loadFromFiles(dirs, localeName, minimalDraftStatus);
    }

    public static CLDRFile makeSupplemental(String localeName) {
        SimpleXMLSource source = new SimpleXMLSource(localeName);
        CLDRFile result = new CLDRFile(source);
        result.setNonInheriting(true);
        return result;
    }

    public static CLDRFile makeFile(String fileName, InputStream fis, CLDRFile.DraftStatus minimalDraftStatus) {
        CLDRFile file = CLDRFile.load(fileName, null, fis, minimalDraftStatus);
        return file;
    }

    public static CLDRFile makeFileLenient(String fileName, InputStream fis, CLDRFile.DraftStatus minimalDraftStatus) {
        CLDRFile file = CLDRFile.load(fileName, null, fis, minimalDraftStatus, true);
        return file;
    }

    public static CLDRFile makeFile(String fileName, String localeName, InputStream fis, CLDRFile.DraftStatus minimalDraftStatus) {
        return CLDRFile.load(fileName, localeName, fis, minimalDraftStatus);
    }

    public static CLDRFile makeFile(String localeName, String dir, CLDRFile.DraftStatus minimalDraftStatus) {
        return SimpleFactory.makeFile(localeName, new File(dir), minimalDraftStatus);
    }

    public static CLDRFile makeFile(String localeName, File dir, CLDRFile.DraftStatus minimalDraftStatus) {
        CLDRFile file = SimpleFactory.makeFromFile(SimpleFactory.makeFileName(localeName, dir), localeName, minimalDraftStatus);
        return file;
    }

    public static CLDRFile makeFile(String localeName, List<File> dirs, CLDRFile.DraftStatus minimalDraftStatus) {
        CLDRFile file = SimpleFactory.makeFromFile(dirs, localeName, minimalDraftStatus);
        return file;
    }

    private static File makeFileName(String localeName, File dir) {
        return new File(dir, localeName + ".xml");
    }

    public static CLDRFile makeFile(String localeName) {
        SimpleXMLSource source = new SimpleXMLSource(localeName);
        return new CLDRFile(source);
    }

    public static CLDRFile makeFile(String localeName, String dir, boolean includeDraft) {
        return SimpleFactory.makeFile(localeName, dir, includeDraft ? CLDRFile.DraftStatus.unconfirmed : CLDRFile.DraftStatus.approved);
    }

    @Override
    public File[] getSourceDirectories() {
        return this.sourceDirectories;
    }

    @Override
    public List<File> getSourceDirectoriesForLocale(String localeName) {
        ImmutableList.Builder result = null;
        boolean isSupplemental = CLDRFile.isSupplementalName(localeName);
        for (File sourceDirectory : this.sourceDirectories) {
            File dir;
            File xmlFile;
            if (isSupplemental) {
                sourceDirectory = new File(sourceDirectory.getAbsolutePath().replace("incoming" + File.separator + "vetted" + File.separator, "common" + File.separator));
            }
            if (!(xmlFile = SimpleFactory.makeFileName(localeName, dir = isSupplemental ? new File(sourceDirectory, "../supplemental") : sourceDirectory)).canRead()) continue;
            if (result == null) {
                result = ImmutableList.builder();
            }
            result.add(dir);
        }
        return result == null ? null : result.build();
    }

    public static class NoSourceDirectoryException
    extends ICUUncheckedIOException {
        private static final long serialVersionUID = 1L;
        private final String localeName;

        public NoSourceDirectoryException(String localeName) {
            this.localeName = localeName;
        }

        @Override
        public String getMessage() {
            return "Unable to determine the source directory for locale " + this.localeName;
        }
    }

    private static class SimpleFactoryCacheKey {
        private List<String> sourceDirectories;
        private String matchString;
        private CLDRFile.DraftStatus mimimalDraftStatus;

        public SimpleFactoryCacheKey(List<String> sourceDirectories, String matchString, CLDRFile.DraftStatus mimimalDraftStatus) {
            this.sourceDirectories = sourceDirectories;
            this.matchString = matchString;
            this.mimimalDraftStatus = mimimalDraftStatus;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.matchString == null ? 0 : this.matchString.hashCode());
            result = 31 * result + (this.mimimalDraftStatus == null ? 0 : this.mimimalDraftStatus.hashCode());
            result = 31 * result + (this.sourceDirectories == null ? 0 : this.sourceDirectories.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleFactoryCacheKey other = (SimpleFactoryCacheKey)obj;
            if (this.matchString == null ? other.matchString != null : !this.matchString.equals(other.matchString)) {
                return false;
            }
            if (this.mimimalDraftStatus != other.mimimalDraftStatus) {
                return false;
            }
            return !(this.sourceDirectories == null ? other.sourceDirectories != null : !this.sourceDirectories.equals(other.sourceDirectories));
        }

        public List<String> getSourceDirectories() {
            return this.sourceDirectories;
        }

        public String getMatchString() {
            return this.matchString;
        }

        public CLDRFile.DraftStatus getMimimalDraftStatus() {
            return this.mimimalDraftStatus;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SimpleFactoryCacheKey [sourceDirectories=").append(this.sourceDirectories).append(", matchString=").append(this.matchString).append(", mimimalDraftStatus=").append((Object)this.mimimalDraftStatus).append("]");
            return builder.toString();
        }
    }

    private static class SimpleFactoryLookupKey {
        private final String directory;
        private final String matchString;

        public SimpleFactoryLookupKey(String directory, String matchString) {
            this.directory = directory;
            this.matchString = matchString;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
            result = 31 * result + (this.matchString == null ? 0 : this.matchString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleFactoryLookupKey other = (SimpleFactoryLookupKey)obj;
            if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
                return false;
            }
            return !(this.matchString == null ? other.matchString != null : !this.matchString.equals(other.matchString));
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getMatchString() {
            return this.matchString;
        }

        public String toString() {
            return "SimpleFactoryLookupKey [directory=" + this.directory + ", matchString=" + this.matchString + "]";
        }
    }

    private static class CLDRCacheKey {
        private final String localeName;
        private final boolean resolved;
        private final CLDRFile.DraftStatus draftStatus;
        private final Set<String> directories;
        private final int hashCode;

        public CLDRCacheKey(String localeName, boolean resolved, CLDRFile.DraftStatus draftStatus, List<File> directories) {
            this.localeName = localeName;
            this.resolved = resolved;
            this.draftStatus = draftStatus;
            if (directories == null || directories.isEmpty()) {
                throw new ICUUncheckedIOException("Attempt to create a CLDRCacheKey with a null directory, please supply a non-null one.");
            }
            ImmutableSet.Builder _directories = ImmutableSet.builder();
            for (File directory : directories) {
                if (!directory.canRead()) {
                    throw new ICUUncheckedIOException("The directory specified, " + directory.getPath() + ", cannot be read");
                }
                _directories.add(directory.toString());
            }
            this.directories = _directories.build();
            this.hashCode = Objects.hash(new Object[]{this.localeName, this.resolved, this.draftStatus, this.directories});
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CLDRCacheKey other = (CLDRCacheKey)obj;
            if (!Objects.equals(this.directories, other.directories)) {
                return false;
            }
            if (this.draftStatus != other.draftStatus) {
                return false;
            }
            if (this.localeName == null ? other.localeName != null : !this.localeName.equals(other.localeName)) {
                return false;
            }
            return this.resolved == other.resolved;
        }

        public String toString() {
            return "[ LocaleName: " + this.localeName + " Resolved: " + this.resolved + " Draft status: " + this.draftStatus + " Directories: " + this.directories + " ]";
        }
    }
}

