/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.XPathParser;

public class SimpleXPathParts
extends XPathParser {
    final List<Element> elements = new LinkedList<Element>();

    @Override
    public String getElement(int i) {
        if (i < 0) {
            i = this.elements.size() + i;
        }
        return this.elements.get((int)i).name;
    }

    @Override
    public String getAttributeValue(int i, String attribute) {
        if (i < 0) {
            i = this.elements.size() + i;
        }
        return this.elements.get((int)i).attributes.get(attribute);
    }

    @Override
    protected void handleClearElements() {
        this.elements.clear();
    }

    @Override
    protected void handleAddElement(String element) {
        this.elements.add(new Element(element));
    }

    @Override
    protected void handleAddAttribute(String attribute, String value) {
        this.elements.get((int)(this.elements.size() - 1)).attributes.put(attribute, value);
    }

    SimpleXPathParts(String xpath) {
        this.handleParse(xpath, true);
    }

    static SimpleXPathParts getFrozenInstance(String xpath) {
        return new SimpleXPathParts(xpath);
    }

    private final class Element {
        public final String name;
        public final Map<String, String> attributes = new TreeMap<String, String>();

        public Element(String name) {
            this.name = name;
        }
    }
}

