/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Utility;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Dictionary;
import org.unicode.cldr.util.IntMap;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.StringByteConverter;

public class StateDictionary<T>
extends Dictionary<T> {
    private static final boolean DEBUG_FLATTEN = false;
    private final ArrayList<Row> builtRows;
    private final Row builtBaseRow;
    private final IntMap<T> builtResults;
    private final int builtMaxByteLength;
    private final StringByteConverter byteString;
    private static int debugReferenceCount = 0;
    private int debugReferenceNumber = debugReferenceCount++;
    static final Comparator<Byte> unsignedByteComparator = new Comparator<Byte>(){

        @Override
        public int compare(Byte o1, Byte o2) {
            int b2;
            int b1 = o1 & 0xFF;
            return b1 < (b2 = o2 & 0xFF) ? -1 : (b1 > b2 ? 1 : 0);
        }
    };
    static final Comparator<Row> rowComparator = new Comparator<Row>(){

        @Override
        public int compare(Row row1, Row row2) {
            if (row1 == row2) {
                return 0;
            }
            if (row1 == null) {
                return -1;
            }
            if (row2 == null) {
                return 1;
            }
            int result = row1.byteToCell.size() - row2.byteToCell.size();
            if (0 != result) {
                return result;
            }
            Iterator<Byte> otherIt = row2.byteToCell.keySet().iterator();
            for (byte key : row1.byteToCell.keySet()) {
                byte otherKey;
                result = key - (otherKey = otherIt.next().byteValue());
                if (0 != result) {
                    return result;
                }
                Cell cell1 = row1.byteToCell.get(key);
                Cell cell2 = row2.byteToCell.get(key);
                result = cell1.deltaResult - cell2.deltaResult;
                if (0 != result) {
                    return result;
                }
                if (cell1.returns != cell2.returns) {
                    return cell1.returns ? 1 : -1;
                }
                result = this.compare(cell1.nextRow, cell2.nextRow);
                if (0 == result) continue;
                return result;
            }
            return 0;
        }
    };

    StateDictionary(Row builtBaseRow2, ArrayList<Row> builtRows2, IntMap<T> builtResults2, int builtMaxByteLength, StringByteConverter byteConverter) {
        this.builtBaseRow = builtBaseRow2;
        this.builtRows = builtRows2;
        this.builtResults = builtResults2;
        this.builtMaxByteLength = builtMaxByteLength;
        this.byteString = byteConverter;
    }

    @Override
    public Dictionary.Matcher<T> getMatcher() {
        return new StateMatcher();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Row row : this.builtRows) {
            result.append(row.toString()).append("\n");
        }
        Map<T, Integer> map = this.builtResults.getValueMap();
        TreeSet<Pair<Integer, String>> sorted = new TreeSet<Pair<Integer, String>>();
        for (T t2 : map.keySet()) {
            sorted.add(new Pair<Integer, String>(map.get(t2), t2.toString()));
        }
        for (Pair pair : sorted) {
            result.append(pair.getFirst()).append("*=").append((String)pair.getSecond()).append("\n");
        }
        return result.toString();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, T>> getMapping() {
        return new TextFetcher().getWords().entrySet().iterator();
    }

    @Override
    public String debugShow() {
        return new TextFetcher().debugShow();
    }

    public int getRowCount() {
        return this.builtRows.size();
    }

    static int addBytes(int source, byte[] target, int pos) {
        source = source < 0 ? -source << 1 | 1 : (source <<= 1);
        while (true) {
            byte b = (byte)(source & 0x7F);
            if ((source >>>= 7) == 0) {
                b = (byte)(b | 0x80);
                target[pos++] = b;
                return pos;
            }
            target[pos++] = b;
        }
    }

    public void flatten() {
        TreeSet<Row> s2 = new TreeSet<Row>(this.builtRows);
        int count = 0;
        int oldDepth = 999;
        String oldCell = "";
        int uniqueCount = 0;
        int cellCount = 0;
        byte[] target = new byte[500];
        int totalBytesCompacted = 0;
        block0: for (Row row : s2) {
            row.referenceNumber = count++;
            int depth = row.maximumDepth();
            if (depth != oldDepth) {
                oldDepth = depth;
            }
            int bytesCompacted = row.compact(target);
            String newCell = row.toStringCells();
            if (!newCell.equals(oldCell)) {
                ++uniqueCount;
                totalBytesCompacted += bytesCompacted;
                cellCount += row.byteToCell.size();
            }
            oldCell = newCell;
            for (Cell cell : row.byteToCell.values()) {
                if (cell.nextRow == null || cell.nextRow.referenceNumber <= row.referenceNumber) continue;
                continue block0;
            }
        }
        System.out.println("Count: " + count);
        System.out.println("UniqueCount: " + uniqueCount);
        System.out.println("CellCount: " + cellCount);
        System.out.println("TotalBytesCompacted: " + totalBytesCompacted);
    }

    private class TextFetcher {
        Map<CharSequence, T> result = new TreeMap();
        byte[] soFar;
        BitSet shown;
        StringBuilder buffer;
        StringBuilder debugTreeView;
        private HashSet<Row> rowsSeen;

        private TextFetcher() {
            this.soFar = new byte[StateDictionary.this.builtMaxByteLength];
            this.shown = new BitSet();
            this.buffer = new StringBuilder();
            this.debugTreeView = new StringBuilder();
            this.rowsSeen = new HashSet();
        }

        public Map<CharSequence, T> getWords() {
            this.result.clear();
            this.getWords(0, 0, StateDictionary.this.builtBaseRow);
            return this.result;
        }

        public String debugShow() {
            this.rowsSeen.clear();
            Counter<Integer> debugCounter = new Counter<Integer>();
            this.getDebugWords(0, 0, StateDictionary.this.builtBaseRow, Integer.MAX_VALUE);
            for (Row row : StateDictionary.this.builtRows) {
                debugCounter.add(row.byteToCell.size(), 1L);
            }
            for (Integer item : debugCounter.getKeysetSortedByKey()) {
                this.debugTreeView.append("cells in row=\t").append(item).append("\trows with count=\t").append(debugCounter.getCount(item)).append("\n");
            }
            return this.debugTreeView.toString();
        }

        private void getDebugWords(int byteLength, int resultSoFar, Row row, int suppressAbove) {
            if (this.rowsSeen.contains(row)) {
                if (suppressAbove > byteLength) {
                    suppressAbove = byteLength;
                }
            } else {
                this.rowsSeen.add(row);
            }
            TreeSet<Byte> sorted = new TreeSet<Byte>(unsignedByteComparator);
            sorted.addAll(row.byteToCell.keySet());
            for (Byte key : sorted) {
                Cell cell = row.byteToCell.get(key);
                this.soFar[byteLength] = key;
                this.shown.set(byteLength, false);
                int currentValue = resultSoFar + cell.deltaResult;
                if (cell.returns) {
                    CharSequence key2 = this.stringFromBytes(this.soFar, byteLength + 1);
                    Object value2 = StateDictionary.this.builtResults.get(currentValue);
                    for (int i = 0; i <= byteLength; ++i) {
                        this.debugTreeView.append(' ');
                        if (i >= suppressAbove) {
                            this.debugTreeView.append("++");
                            continue;
                        }
                        if (this.shown.get(i)) {
                            this.debugTreeView.append("--");
                            continue;
                        }
                        this.debugTreeView.append(Utility.hex(this.soFar[i] & 0xFF, 2));
                        this.shown.set(i);
                    }
                    this.debugTreeView.append("\t<").append(key2).append(">\t<").append(value2).append(">\n");
                }
                if (cell.nextRow == null) continue;
                this.getDebugWords(byteLength + 1, currentValue, cell.nextRow, suppressAbove);
            }
        }

        private void getWords(int byteLength, int resultSoFar, Row row) {
            for (Byte key : row.byteToCell.keySet()) {
                Cell cell = row.byteToCell.get(key);
                this.soFar[byteLength] = key;
                int currentValue = resultSoFar + cell.deltaResult;
                if (cell.returns) {
                    CharSequence key2 = this.stringFromBytes(this.soFar, byteLength + 1);
                    Object value2 = StateDictionary.this.builtResults.get(currentValue);
                    this.result.put(key2, value2);
                }
                if (cell.nextRow == null) continue;
                this.getWords(byteLength + 1, currentValue, cell.nextRow);
            }
        }

        private CharSequence stringFromBytes(byte[] soFar, int len) {
            this.buffer.setLength(0);
            StateDictionary.this.byteString.fromBytes(soFar, 0, len, this.buffer);
            return this.buffer.toString();
        }
    }

    class StateMatcher
    extends Dictionary.Matcher<T> {
        private static final boolean SHOW_DEBUG = false;
        private final byte[] matchByteBuffer;
        private int matchByteStringIndex;
        private int matchByteBufferLength;
        private Row matchCurrentRow;
        private int matchIntValue;
        private Row matchLastRow;
        int myMatchEnd;
        private Row partialLastRow;
        private int partialMatchValue;

        StateMatcher() {
            this.matchByteBuffer = new byte[StateDictionary.this.byteString.getMaxBytesPerChar()];
            this.matchIntValue = -1;
        }

        @Override
        public Dictionary.Matcher<T> setOffset(int offset) {
            this.matchCurrentRow = StateDictionary.this.builtBaseRow;
            this.partialLastRow = null;
            this.partialMatchValue = 0;
            this.matchIntValue = 0;
            this.myMatchEnd = offset;
            this.matchValue = null;
            StateDictionary.this.byteString.clear();
            this.matchByteStringIndex = offset;
            return super.setOffset(offset);
        }

        @Override
        public Dictionary.Matcher.Status next() {
            if (this.matchCurrentRow == null) {
                this.matchIntValue = -1;
                this.matchValue = null;
                return Dictionary.Matcher.Status.NONE;
            }
            Dictionary.Matcher.Status result = Dictionary.Matcher.Status.PARTIAL;
            while (this.text.hasCharAt(this.myMatchEnd)) {
                if (this.myMatchEnd == this.matchByteStringIndex) {
                    char ch = this.text.charAt(this.matchByteStringIndex++);
                    this.matchByteBufferLength = StateDictionary.this.byteString.toBytes(ch, this.matchByteBuffer, 0);
                }
                for (int i = 0; i < this.matchByteBufferLength && (result = this.nextByte(this.matchByteBuffer[i])) == Dictionary.Matcher.Status.PARTIAL; ++i) {
                }
                if (result == Dictionary.Matcher.Status.PARTIAL) {
                    ++this.myMatchEnd;
                    continue;
                }
                if (result == Dictionary.Matcher.Status.MATCH) {
                    ++this.myMatchEnd;
                    this.matchValue = StateDictionary.this.builtResults.get(this.matchIntValue);
                    this.matchEnd = this.myMatchEnd;
                    return result;
                }
                if (this.myMatchEnd > this.offset && this.matchCurrentRow.byteToCell.size() > 0) {
                    result = Dictionary.Matcher.Status.PARTIAL;
                }
                if (result != Dictionary.Matcher.Status.NONE) break;
                this.matchIntValue = -1;
                this.matchValue = null;
                break;
            }
            this.matchLastRow = this.matchCurrentRow;
            this.matchCurrentRow = null;
            if (result == Dictionary.Matcher.Status.PARTIAL) {
                this.matchValue = StateDictionary.this.builtResults.get(this.matchIntValue);
                this.matchEnd = this.myMatchEnd;
                this.partialLastRow = this.matchLastRow;
                this.partialMatchValue = this.matchIntValue;
            }
            return result;
        }

        private Dictionary.Matcher.Status nextByte(int chunk) {
            Cell cell = this.matchCurrentRow.byteToCell.get((byte)chunk);
            if (cell == null) {
                return Dictionary.Matcher.Status.NONE;
            }
            this.matchIntValue += cell.deltaResult;
            this.matchCurrentRow = cell.nextRow;
            if (cell.returns) {
                return Dictionary.Matcher.Status.MATCH;
            }
            return Dictionary.Matcher.Status.PARTIAL;
        }

        public int getIntMatchValue() {
            return this.matchIntValue;
        }

        @Override
        public boolean nextUniquePartial() {
            if (this.partialLastRow.hasUniqueValue == Row.Uniqueness.UNIQUE) {
                this.matchValue = StateDictionary.this.builtResults.get(this.partialMatchValue);
                this.matchEnd = this.myMatchEnd;
                return true;
            }
            return false;
        }

        @Override
        public StateDictionary<T> getDictionary() {
            return StateDictionary.this;
        }
    }

    static class Cell {
        public Row nextRow;
        public int deltaResult;
        public boolean returns;

        Cell() {
        }

        public int addBytes(byte[] target, int pos, int rowDelta) {
            pos = StateDictionary.addBytes(this.deltaResult, target, pos);
            int rowOffset = this.nextRow == null ? 0 : rowDelta - this.nextRow.getReferenceNumber();
            rowOffset <<= 1;
            if (this.returns) {
                rowOffset |= 1;
            }
            return StateDictionary.addBytes(rowOffset, target, pos);
        }

        public String toString() {
            Object result;
            Object object = result = this.deltaResult == 0 ? "" : String.valueOf(this.deltaResult);
            if (this.returns) {
                result = (String)result + "*";
            }
            if (this.nextRow != null) {
                if (((String)result).length() != 0) {
                    result = (String)result + "/";
                }
                result = (String)result + "R" + this.nextRow.getReferenceNumber();
            }
            return result;
        }
    }

    static class Row
    implements Comparable {
        Uniqueness hasUniqueValue = Uniqueness.UNKNOWN;
        final TreeMap<Byte, Cell> byteToCell = new TreeMap();
        transient int returnCount;
        transient int terminatingReturnCount;
        private int referenceNumber;

        Row(int rowNumber) {
            this.referenceNumber = rowNumber;
        }

        public int nonTerminating() {
            return this.byteToCell.size() - this.terminatingReturnCount;
        }

        public int nonReturn() {
            return this.byteToCell.size() - this.returnCount;
        }

        public int maximumDepth() {
            int result = 0;
            for (Cell cell : this.byteToCell.values()) {
                int temp;
                if (cell.nextRow == null || result >= (temp = cell.nextRow.maximumDepth() + 1)) continue;
                result = temp;
            }
            return result;
        }

        public int compareTo(Object o) {
            Row other = (Row)o;
            int result = this.maximumDepth() - other.maximumDepth();
            if (0 != result) {
                return result;
            }
            result = this.byteToCell.size() - other.byteToCell.size();
            if (0 != result) {
                return result;
            }
            Iterator<Byte> otherIt = other.byteToCell.keySet().iterator();
            for (byte key : this.byteToCell.keySet()) {
                byte otherKey;
                result = key - (otherKey = otherIt.next().byteValue());
                if (0 != result) {
                    return result;
                }
                Cell cell = this.byteToCell.get(key);
                Cell otherCell = other.byteToCell.get(key);
                result = cell.deltaResult - otherCell.deltaResult;
                if (0 == result) continue;
                return result;
            }
            return this.referenceNumber - other.referenceNumber;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("R" + this.getReferenceNumber() + this.hasUniqueValue.debugName() + "{");
            boolean first = true;
            TreeSet<Byte> sorted = new TreeSet<Byte>(unsignedByteComparator);
            sorted.addAll(this.byteToCell.keySet());
            for (Byte key : sorted) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(' ');
                }
                buffer.append(Utility.hex(key & 0xFF, 2));
                buffer.append('=');
                buffer.append(this.byteToCell.get(key));
            }
            buffer.append('}');
            return buffer.toString();
        }

        public String toStringCells() {
            StringBuilder buffer = new StringBuilder();
            for (Byte key : this.byteToCell.keySet()) {
                buffer.append(Utility.hex(key & 0xFF, 2));
                buffer.append(this.byteToCell.get(key).toString());
                buffer.append(' ');
            }
            return buffer.toString();
        }

        public int getReferenceNumber() {
            return this.referenceNumber;
        }

        int compact(byte[] target) {
            int pos = 0;
            for (Byte key : this.byteToCell.keySet()) {
                target[pos++] = key;
                pos = this.byteToCell.get(key).addBytes(target, pos, 0);
            }
            target[pos++] = 0;
            return pos;
        }

        static enum Uniqueness {
            UNIQUE,
            AMBIGUOUS,
            UNKNOWN;


            public String debugName() {
                switch (this) {
                    case UNIQUE: {
                        return "\u00b9";
                    }
                    case AMBIGUOUS: {
                        return "\u00b2";
                    }
                }
                return "?";
            }
        }
    }
}

