/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.util.Freezable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.UnitConverter;

public class UnitPreferences
implements Freezable<UnitPreferences> {
    Map<String, Map<String, Multimap<Set<String>, UnitPreference>>> quantityToUsageToRegionsToInfo = new TreeMap<String, Map<String, Multimap<Set<String>, UnitPreference>>>();
    Set<String> usages = new TreeSet<String>();
    private static final Splitter SPLIT_SPACE = Splitter.on(' ').trimResults().omitEmptyStrings();
    public static Splitter SPLIT_AND = Splitter.on("-and-");
    boolean frozen;
    static final Joiner JOIN_SPACE = Joiner.on(' ');

    public void add(String quantity, String usage, String regions, String geq, String skeleton, String unit) {
        Multimap<Set<String>, UnitPreference> regionsToInfo;
        this.usages.add(usage);
        Map<String, Multimap<Set<String>, UnitPreference>> usageToRegionsToInfo = this.quantityToUsageToRegionsToInfo.get(quantity);
        if (usageToRegionsToInfo == null) {
            usageToRegionsToInfo = new TreeMap<String, Multimap<Set<String>, UnitPreference>>();
            this.quantityToUsageToRegionsToInfo.put(quantity, usageToRegionsToInfo);
        }
        if ((regionsToInfo = usageToRegionsToInfo.get(usage)) == null) {
            regionsToInfo = LinkedHashMultimap.create();
            usageToRegionsToInfo.put(usage, regionsToInfo);
        }
        Rational newGeq = geq == null || geq.isEmpty() ? Rational.ONE : Rational.of(geq);
        UnitPreference newUnitPref = new UnitPreference(newGeq, unit, skeleton);
        regionsToInfo.put(ImmutableSet.copyOf(new TreeSet<String>(SPLIT_SPACE.splitToList(regions))), newUnitPref);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public UnitPreferences freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.quantityToUsageToRegionsToInfo = CldrUtility.protectCollection(this.quantityToUsageToRegionsToInfo);
            this.usages = ImmutableSet.copyOf(this.usages);
        }
        return this;
    }

    @Override
    public UnitPreferences cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Map<String, Multimap<Set<String>, UnitPreference>>> getData() {
        return this.quantityToUsageToRegionsToInfo;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int order = 0;
        for (Map.Entry<String, Map<String, Multimap<Set<String>, UnitPreference>>> entry1 : this.quantityToUsageToRegionsToInfo.entrySet()) {
            String quantity = entry1.getKey();
            for (Map.Entry<String, Multimap<Set<String>, UnitPreference>> entry2 : entry1.getValue().entrySet()) {
                String usage = entry2.getKey();
                for (Map.Entry<Set<String>, Collection<UnitPreference>> entry : entry2.getValue().asMap().entrySet()) {
                    Set<String> regions = entry.getKey();
                    for (UnitPreference up : entry.getValue()) {
                        buffer.append("\n" + up.unit + "\t;\t" + this.getPath(order++, quantity, usage, regions, up.geq, up.skeleton));
                    }
                }
            }
        }
        return buffer.toString();
    }

    public String getPath(int order, String quantity, String usage, Collection<String> regions, Rational geq, String skeleton) {
        return "//supplementalData/unitPreferenceData/unitPreferences[@category=\"" + quantity + "\"][@usage=\"" + usage + "\"]/unitPreference[@_q=\"" + order + "\"][@regions=\"" + JOIN_SPACE.join(regions) + "\"]" + (String)(geq == Rational.ONE ? "" : "[@geq=\"" + geq + "\"]") + (String)(skeleton.isEmpty() ? "" : "[@skeleton=\"" + skeleton + "\"]");
    }

    public Map<String, Map<String, Map<String, UnitPreference>>> getFastMap(UnitConverter converter) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, Map<String, Multimap<Set<String>, UnitPreference>>> entry1 : this.quantityToUsageToRegionsToInfo.entrySet()) {
            String quantity = entry1.getKey();
            LinkedHashMap result2 = new LinkedHashMap();
            result.put(quantity, result2);
            for (Map.Entry<String, Multimap<Set<String>, UnitPreference>> entry2 : entry1.getValue().entrySet()) {
                String usage = entry2.getKey();
                LinkedHashMap<String, UnitPreference> result3 = new LinkedHashMap<String, UnitPreference>();
                result2.put(usage, result3);
                for (Map.Entry<Set<String>, Collection<UnitPreference>> entry : entry2.getValue().asMap().entrySet()) {
                    Set<String> regions = entry.getKey();
                    for (UnitPreference up : entry.getValue()) {
                        String unit = SPLIT_AND.split(up.unit).iterator().next();
                        quantity = converter.getQuantityFromUnit(unit, false);
                        String baseUnit = converter.getBaseUnitFromQuantity(quantity);
                        Rational geq = converter.parseRational(String.valueOf(up.geq));
                        Rational value = converter.convert(geq, unit, baseUnit, false);
                        if (value.equals(Rational.NaN)) {
                            converter.convert(geq, unit, baseUnit, true);
                        }
                        UnitPreference up2 = new UnitPreference(value, up.unit, up.skeleton);
                        for (String region : regions) {
                            result3.put(region, up2);
                        }
                    }
                }
            }
        }
        return XCldrStub.ImmutableMap.copyOf(result);
    }

    public Set<String> getUsages() {
        return this.usages;
    }

    public static final class UnitPreference
    implements Comparable<UnitPreference> {
        public final Rational geq;
        public final String unit;
        public final String skeleton;

        public UnitPreference(Rational geq, String unit, String skeleton) {
            this.geq = geq;
            this.unit = unit;
            this.skeleton = skeleton == null ? "" : skeleton;
        }

        @Override
        public int compareTo(UnitPreference o) {
            int diff = this.geq.compareTo(o.geq);
            if (diff != 0) {
                return diff;
            }
            return this.unit.compareTo(o.unit);
        }

        public boolean equals(Object obj) {
            return this.compareTo((UnitPreference)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.geq, this.unit);
        }

        public String toString(String baseUnit) {
            return this.geq + (String)(baseUnit == null ? "" : " " + baseUnit) + ", " + this.unit + (String)(this.skeleton.isEmpty() ? "" : ", " + this.skeleton);
        }

        public String toString() {
            return this.toString(null);
        }
    }
}

