/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

public class XPathTokenizer {
    char[] xpath;
    int current;

    public XPathTokenizer(StringBuffer path) {
        this(path.toString());
    }

    public XPathTokenizer(StringBuilder path) {
        this(path.toString());
    }

    public XPathTokenizer(String path) {
        this.xpath = path.toCharArray();
        this.current = path.indexOf("..") == 0 ? 0 : 2;
    }

    public String nextToken() {
        boolean inquote = false;
        int save = this.current;
        block4: while (this.current < this.xpath.length) {
            switch (this.xpath[this.current]) {
                case '\'': {
                    inquote = !inquote;
                    ++this.current;
                    continue block4;
                }
                case '/': {
                    if (inquote) break;
                    String retval = new String(this.xpath, save, this.current - save);
                    ++this.current;
                    return retval;
                }
            }
            ++this.current;
        }
        if (this.current == this.xpath.length) {
            String retval = new String(this.xpath, save, this.current - save);
            ++this.current;
            return retval;
        }
        return null;
    }

    public static StringBuffer deleteToken(StringBuffer xpath) {
        int length = xpath.length();
        int current = length - 1;
        block4: while (current > 0) {
            boolean inquote = false;
            switch (xpath.charAt(current)) {
                case '\'': {
                    inquote = !inquote;
                    --current;
                    continue block4;
                }
                case '/': {
                    if (inquote) break;
                    if (current < length) {
                        xpath.delete(current, length);
                    }
                    return xpath;
                }
            }
            --current;
        }
        return xpath;
    }

    public static StringBuilder deleteToken(StringBuilder xpath) {
        int length = xpath.length();
        int current = length - 1;
        block4: while (current > 0) {
            boolean inquote = false;
            switch (xpath.charAt(current)) {
                case '\'': {
                    inquote = !inquote;
                    --current;
                    continue block4;
                }
                case '/': {
                    if (inquote) break;
                    if (current < length) {
                        xpath.delete(current, length);
                    }
                    return xpath;
                }
            }
            --current;
        }
        return xpath;
    }

    @Deprecated
    public static StringBuffer relativeToAbsolute(String xpath, StringBuffer fullPath) {
        if (!xpath.startsWith("..")) {
            fullPath.setLength(0);
            fullPath.append(xpath);
            return fullPath;
        }
        XPathTokenizer tokenizer = new XPathTokenizer(xpath);
        String token = tokenizer.nextToken();
        StringBuffer retVal = new StringBuffer();
        retVal.append(fullPath);
        while (token.equals("..")) {
            XPathTokenizer.deleteToken(retVal);
            token = tokenizer.nextToken();
        }
        while (token != null) {
            retVal.append("/");
            retVal.append(token);
            token = tokenizer.nextToken();
        }
        return retVal;
    }

    public static StringBuilder relativeToAbsolute(String xpath, StringBuilder fullPath) {
        if (!xpath.startsWith("..")) {
            fullPath.setLength(0);
            fullPath.append(xpath);
            return fullPath;
        }
        XPathTokenizer tokenizer = new XPathTokenizer(xpath);
        String token = tokenizer.nextToken();
        StringBuilder retVal = new StringBuilder();
        retVal.append((CharSequence)fullPath);
        while (token.equals("..")) {
            XPathTokenizer.deleteToken(retVal);
            token = tokenizer.nextToken();
        }
        while (token != null) {
            retVal.append("/");
            retVal.append(token);
            token = tokenizer.nextToken();
        }
        return retVal;
    }
}

