/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.ListFormat;
import com.ibm.icu.util.ULocale;

public class ListFormatTest
extends TestFmwk {
    String[] HardcodedTestData = new String[]{"", "A", "A and B", "A; B, and C", "A; B, C, and D", "A; B, C, D, and E"};
    String[] EnglishTestData = new String[]{"", "A", "A and B", "A, B, and C", "A, B, C, and D", "A, B, C, D, and E"};
    String[] JapaneseTestData = new String[]{"", "A", "A\u3001B", "A\u3001B\u3001C", "A\u3001B\u3001C\u3001D", "A\u3001B\u3001C\u3001D\u3001E"};
    String[] RootTestData = new String[]{"", "A", "A, B", "A, B, C", "A, B, C, D", "A, B, C, D, E"};

    public static void main(String[] args) {
        new ListFormatTest().run(args);
    }

    public void TestBasic() {
        ListFormat formatter = new ListFormat("{0} and {1}", "{0}; {1}", "{0}, {1}", "{0}, and {1}");
        this.checkData(formatter, this.HardcodedTestData);
    }

    public void TestEnglish() {
        this.checkData(ListFormat.getInstance(ULocale.ENGLISH), this.EnglishTestData);
        this.checkData(ListFormat.getInstance(ULocale.US), this.EnglishTestData);
    }

    public void TestJapanese() {
        this.checkData(ListFormat.getInstance(ULocale.JAPANESE), this.JapaneseTestData);
    }

    public void TestSpecial() {
        this.checkData(ListFormat.getInstance(ULocale.ROOT), this.RootTestData);
        this.checkData(ListFormat.getInstance(new ULocale("xxx")), this.RootTestData);
    }

    public void checkData(ListFormat listFormat, String[] strings) {
        this.assertEquals("0", strings[0], listFormat.format(new Object[0]));
        this.assertEquals("1", strings[1], listFormat.format("A"));
        this.assertEquals("2", strings[2], listFormat.format("A", "B"));
        this.assertEquals("3", strings[3], listFormat.format("A", "B", "C"));
        this.assertEquals("4", strings[4], listFormat.format("A", "B", "C", "D"));
        this.assertEquals("5", strings[5], listFormat.format("A", "B", "C", "D", "E"));
    }
}

