/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.NameClassSplitter;
import com.thaiopensource.relaxng.output.dtd.Analysis;
import com.thaiopensource.relaxng.output.dtd.AttributeType;
import com.thaiopensource.relaxng.output.dtd.ContentType;
import com.thaiopensource.relaxng.output.dtd.Datatypes;
import com.thaiopensource.relaxng.output.dtd.GrammarPart;
import com.thaiopensource.relaxng.output.dtd.ModelBreaker;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.out.CharRepertoire;
import com.thaiopensource.xml.util.Naming;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

class DtdOutput {
    private final boolean warnDatatypes;
    private final String sourceUri;
    private Writer writer;
    private String encoding;
    private CharRepertoire charRepertoire;
    private final int indent;
    private final int lineLength;
    private final String lineSep;
    private final StringBuffer buf = new StringBuffer();
    private final List<ElementPattern> elementQueue = new Vector<ElementPattern>();
    private final List<String> requiredParamEntities = new Vector<String>();
    private final List<String> externallyRequiredParamEntities = new Vector<String>();
    private final Set<String> doneParamEntities = new HashSet<String>();
    private final Set<String> doneIncludes = new HashSet<String>();
    private final Set<String> pendingIncludes = new HashSet<String>();
    private final Analysis analysis;
    private final GrammarPart part;
    private final OutputDirectory od;
    private final ErrorReporter er;
    private final Set<String> reservedEntityNames;
    private final PatternVisitor<VoidValue> topLevelContentModelOutput = new TopLevelContentModelOutput();
    private final AbstractVisitor nestedContentModelOutput = new ContentModelOutput();
    private final PatternVisitor<VoidValue> expandedContentModelOutput = new ExpandedContentModelOutput();
    private final PatternVisitor<VoidValue> groupContentModelOutput = new GroupContentModelOutput();
    private final PatternVisitor<VoidValue> choiceContentModelOutput = new ChoiceContentModelOutput();
    private final PatternVisitor<VoidValue> occurContentModelOutput = new ParenthesizedContentModelOutput();
    private final PatternVisitor<VoidValue> innerElementClassOutput = new InnerElementClassOutput();
    private final PatternVisitor<VoidValue> expandedInnerElementClassOutput = new ExpandedInnerElementClassOutput();
    private final AttributeOutput attributeOutput = new AttributeOutput();
    private final AttributeOutput optionalAttributeOutput = new OptionalAttributeOutput();
    private final PatternVisitor<VoidValue> topLevelSimpleTypeOutput = new TopLevelSimpleTypeOutput();
    private final PatternVisitor<VoidValue> nestedSimpleTypeOutput = new SimpleTypeOutput();
    private final PatternVisitor<VoidValue> valueOutput = new ValueOutput();
    private final GrammarOutput grammarOutput = new GrammarOutput();
    private static final String DTD_URI = "http://www.thaiopensource.com/ns/relaxng/dtd";

    private DtdOutput(boolean bl, String string, Analysis analysis, Set<String> set, OutputDirectory outputDirectory, ErrorReporter errorReporter) {
        this.warnDatatypes = bl;
        this.sourceUri = string;
        this.analysis = analysis;
        this.reservedEntityNames = set;
        this.od = outputDirectory;
        this.er = errorReporter;
        this.part = analysis.getGrammarPart(string);
        try {
            OutputDirectory.Stream stream = outputDirectory.open(string, analysis.getEncoding(string));
            this.encoding = stream.getEncoding();
            this.writer = stream.getWriter();
            this.charRepertoire = stream.getCharRepertoire();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
        this.lineSep = outputDirectory.getLineSeparator();
        this.indent = outputDirectory.getIndent();
        this.lineLength = outputDirectory.getLineLength();
    }

    void outputQueuedElements() {
        for (int i = 0; i < this.elementQueue.size(); ++i) {
            this.outputElement(this.elementQueue.get(i), null);
        }
        this.elementQueue.clear();
    }

    static void output(boolean bl, Analysis analysis, OutputDirectory outputDirectory, ErrorReporter errorReporter) throws IOException {
        try {
            new DtdOutput(bl, analysis.getMainUri(), analysis, new HashSet<String>(), outputDirectory, errorReporter).topLevelOutput();
        }
        catch (WrappedIOException wrappedIOException) {
            throw wrappedIOException.cause;
        }
    }

    void topLevelOutput() {
        GrammarPattern grammarPattern = this.analysis.getGrammarPattern();
        this.xmlDecl();
        Pattern pattern = this.analysis.getPattern();
        if (pattern != grammarPattern) {
            this.outputLeadingComments(pattern);
            pattern.accept(this.nestedContentModelOutput);
            this.outputQueuedElements();
        }
        if (grammarPattern != null) {
            this.outputLeadingComments(grammarPattern);
            this.outputInitialChildComments(grammarPattern);
            this.grammarOutput.visitContainer(grammarPattern);
            this.outputFollowingComments(grammarPattern);
        }
        this.close();
    }

    void subOutput(GrammarPattern grammarPattern) {
        this.xmlDecl();
        this.outputLeadingComments(grammarPattern);
        this.outputInitialChildComments(grammarPattern);
        this.grammarOutput.visitContainer(grammarPattern);
        this.outputFollowingComments(grammarPattern);
        this.close();
    }

    void xmlDecl() {
        this.write("<?xml encoding=\"");
        this.write(this.encoding);
        this.write("\"?>");
        this.outputNewline();
    }

    ContentType getContentType(Pattern pattern) {
        return this.analysis.getContentType(pattern);
    }

    AttributeType getAttributeType(Pattern pattern) {
        return this.analysis.getAttributeType(pattern);
    }

    Pattern getBody(String string) {
        return this.analysis.getBody(string);
    }

    void paramEntityRef(RefPattern refPattern) {
        String string = refPattern.getName();
        this.buf.append('%');
        this.buf.append(string);
        this.buf.append(';');
        this.requiredParamEntities.add(string);
    }

    void attributeValueLiteral(String string) {
        this.buf.append('\'');
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.buf.append("&lt;");
                    continue block9;
                }
                case '&': {
                    this.buf.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    this.buf.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    this.buf.append("&quot;");
                    continue block9;
                }
                case '\r': {
                    this.buf.append("&#xD;");
                    continue block9;
                }
                case '\n': {
                    this.buf.append("&#xA;");
                    continue block9;
                }
                case '\t': {
                    this.buf.append("&#9;");
                    continue block9;
                }
                default: {
                    this.buf.append(c);
                }
            }
        }
        this.buf.append('\'');
    }

    void outputRequiredComponents() {
        for (int i = 0; i < this.requiredParamEntities.size(); ++i) {
            String string = this.requiredParamEntities.get(i);
            Component component = this.part.getWhereProvided(string);
            if (component == null) {
                this.externallyRequiredParamEntities.add(string);
                continue;
            }
            if (component instanceof DefineComponent) {
                if (this.doneParamEntities.contains(string)) continue;
                this.doneParamEntities.add(string);
                this.outputParamEntity((DefineComponent)component);
                continue;
            }
            this.outputInclude((IncludeComponent)component);
        }
        this.requiredParamEntities.clear();
    }

    void outputInclude(IncludeComponent includeComponent) {
        String string = includeComponent.getUri();
        if (this.doneIncludes.contains(string)) {
            return;
        }
        if (this.pendingIncludes.contains(string)) {
            this.er.error("sorry_include_depend", includeComponent.getSourceLocation());
            return;
        }
        this.pendingIncludes.add(string);
        DtdOutput dtdOutput = new DtdOutput(this.warnDatatypes, string, this.analysis, this.reservedEntityNames, this.od, this.er);
        GrammarPattern grammarPattern = (GrammarPattern)this.analysis.getSchema(string);
        dtdOutput.subOutput(grammarPattern);
        this.requiredParamEntities.addAll(dtdOutput.externallyRequiredParamEntities);
        this.outputRequiredComponents();
        this.outputLeadingComments(includeComponent);
        String string2 = this.genEntityName(includeComponent);
        this.outputNewline();
        this.write("<!ENTITY % ");
        this.write(string2);
        this.write(" SYSTEM ");
        this.write('\"');
        this.write(this.od.reference(this.sourceUri, string));
        this.write('\"');
        this.write('>');
        this.outputNewline();
        this.write('%');
        this.write(string2);
        this.write(';');
        this.outputNewline();
        this.outputFollowingComments(includeComponent);
        this.doneIncludes.add(string);
        this.pendingIncludes.remove(string);
    }

    String genEntityName(IncludeComponent includeComponent) {
        String string = DtdOutput.getAttributeAnnotation(includeComponent, DTD_URI, "entityName");
        if (string != null && !Naming.isNcname(string = string.trim())) {
            this.er.warning("entity_name_not_ncname", string, includeComponent.getSourceLocation());
            string = null;
        }
        if (string == null) {
            int n;
            String string2 = includeComponent.getUri();
            int n2 = string2.lastIndexOf(47);
            if (n2 >= 0) {
                string2 = string2.substring(n2 + 1);
            }
            if ((n = string2.lastIndexOf(46)) > 0) {
                string2 = string2.substring(0, n);
            }
            if (Naming.isNcname(string2)) {
                string = string2;
            }
        }
        if (string == null) {
            string = "ent";
        }
        if (!this.reserveEntityName(string)) {
            int n = 1;
            while (true) {
                String string3;
                if (this.reserveEntityName(string3 = string + Integer.toString(n))) {
                    string = string3;
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    private boolean reserveEntityName(String string) {
        if (this.reservedEntityNames.contains(string)) {
            return false;
        }
        this.reservedEntityNames.add(string);
        return true;
    }

    void outputParamEntity(DefineComponent defineComponent) {
        String string = defineComponent.getName();
        Pattern pattern = defineComponent.getBody();
        ContentType contentType = this.getContentType(pattern);
        this.buf.setLength(0);
        boolean bl = true;
        if (contentType.isA(ContentType.MODEL_GROUP) || contentType.isA(ContentType.NOT_ALLOWED) || contentType.isA(ContentType.MIXED_ELEMENT_CLASS)) {
            pattern.accept(this.nestedContentModelOutput);
        } else if (contentType.isA(ContentType.MIXED_MODEL)) {
            pattern.accept(this.topLevelContentModelOutput);
        } else if (contentType.isA(ContentType.EMPTY)) {
            this.attributeOutput.output(pattern);
            bl = false;
        } else if (contentType.isA(ContentType.ENUM)) {
            pattern.accept(this.nestedSimpleTypeOutput);
        } else if (contentType.isA(ContentType.VALUE)) {
            pattern.accept(this.valueOutput);
            bl = false;
        } else if (contentType.isA(ContentType.SIMPLE_TYPE)) {
            pattern.accept(this.topLevelSimpleTypeOutput);
        }
        String string2 = this.buf.toString();
        this.outputRequiredComponents();
        this.outputLeadingComments(defineComponent);
        String string3 = this.analysis.getParamEntityElementName(string);
        if (string3 != null) {
            if (string2.length() > 0) {
                this.outputNewline();
                this.write("<!ATTLIST ");
                this.write(string3);
                this.outputAttributeNamespaces(pattern);
                this.write(string2);
                this.write('>');
                this.outputNewline();
            }
        } else {
            this.doneParamEntities.add(string);
            this.outputNewline();
            String string4 = "<!ENTITY % " + string + " \"";
            String string5 = "\">";
            if (!bl) {
                this.write(string4);
                this.write(string2);
                this.write(string5);
                this.outputNewline();
            } else {
                this.outputModelBreak(string4, string2, string5);
            }
        }
        this.outputFollowingComments(defineComponent);
    }

    private void outputModelBreak(String string, String string2, String string3) {
        ModelBreaker modelBreaker = new ModelBreaker(string, string2, string3, this.lineLength);
        while (modelBreaker.hasNextLine()) {
            this.write(modelBreaker.nextLine());
            this.outputNewline();
        }
    }

    void outputElement(ElementPattern elementPattern, Annotated annotated) {
        this.buf.setLength(0);
        Pattern pattern = elementPattern.getChild();
        ContentType contentType = this.getContentType(pattern);
        if (contentType != ContentType.EMPTY) {
            if (contentType == ContentType.MIXED_ELEMENT_CLASS) {
                this.er.warning("mixed_choice_approx", elementPattern.getSourceLocation());
                this.buf.append("(");
                pattern.accept(this.nestedContentModelOutput);
                this.buf.append(")*");
            } else if (contentType.isA(ContentType.SIMPLE_TYPE)) {
                if (this.warnDatatypes) {
                    this.er.warning("data_content_approx", elementPattern.getSourceLocation());
                }
                this.buf.append("(#PCDATA)");
            } else {
                if (contentType == ContentType.NOT_ALLOWED) {
                    return;
                }
                pattern.accept(this.topLevelContentModelOutput);
            }
        }
        String string = this.buf.length() == 0 ? "EMPTY" : this.buf.toString();
        this.buf.setLength(0);
        this.attributeOutput.output(pattern);
        String string2 = this.buf.toString();
        this.outputRequiredComponents();
        if (annotated != null) {
            this.outputLeadingComments(annotated);
        }
        this.outputLeadingComments(elementPattern);
        List<NameNameClass> list = NameClassSplitter.split(elementPattern.getNameClass());
        for (NameNameClass nameNameClass : list) {
            boolean bl;
            String string3 = nameNameClass.getNamespaceUri();
            String string4 = nameNameClass.getLocalName();
            String string5 = this.analysis.getElementPrefixForNamespaceUri(string3);
            if (string5 != null) {
                string4 = string5 + ":" + string4;
            }
            this.outputNewline();
            this.outputModelBreak("<!ELEMENT " + string4 + " ", string, ">");
            if (string3 == NameClass.INHERIT_NS) {
                bl = false;
            } else if (string5 == null) {
                bl = true;
            } else {
                boolean bl2 = bl = !this.analysis.getAttributeNamespaces(pattern).contains(string3);
            }
            if (string2.length() == 0 && !bl) continue;
            this.write("<!ATTLIST ");
            this.write(string4);
            if (bl) {
                this.outputNewline();
                this.outputIndent();
                if (string5 != null) {
                    this.write("xmlns:");
                    this.write(string5);
                } else {
                    this.write("xmlns");
                }
                this.write(" CDATA #FIXED ");
                this.buf.setLength(0);
                this.attributeValueLiteral(string3);
                this.write(this.buf.toString());
            }
            if (string2.length() != 0) {
                this.outputAttributeNamespaces(pattern);
            }
            this.write(string2);
            this.write('>');
            this.outputNewline();
        }
        if (annotated != null) {
            this.outputFollowingComments(annotated);
        }
    }

    void outputAttributeNamespaces(Pattern pattern) {
        Set<String> set = this.analysis.getAttributeNamespaces(pattern);
        for (String string : set) {
            String string2 = this.analysis.getPrefixForNamespaceUri(string);
            this.outputNewline();
            this.outputIndent();
            this.write("xmlns:");
            this.write(string2);
            this.write(" CDATA #FIXED ");
            this.buf.setLength(0);
            this.attributeValueLiteral(string);
            this.write(this.buf.toString());
        }
    }

    void outputLeadingComments(Annotated annotated) {
        this.outputComments(annotated.getLeadingComments());
    }

    void outputInitialChildComments(Annotated annotated) {
        this.outputComments(annotated.getChildElementAnnotations());
    }

    void outputFollowingComments(Annotated annotated) {
        this.outputComments(annotated.getFollowingElementAnnotations());
    }

    void outputComments(List<? extends AnnotationChild> list) {
        for (AnnotationChild annotationChild : list) {
            if (!(annotationChild instanceof Comment)) continue;
            this.outputComment(((Comment)annotationChild).getValue());
        }
    }

    void outputComment(String string) {
        this.outputNewline();
        this.write("<!--");
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(10, n)) < 0) {
                if (n == 0) {
                    this.write(' ');
                    this.write(string);
                    this.write(' ');
                    break;
                }
                this.outputNewline();
                this.write(string.substring(n));
                this.outputNewline();
                break;
            }
            this.outputNewline();
            this.write(string.substring(n, n2));
            n = n2 + 1;
        }
        this.write("-->");
        this.outputNewline();
    }

    void outputIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.write(' ');
        }
    }

    void outputNewline() {
        this.write(this.lineSep);
    }

    void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    void write(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    private static String getDefaultValue(AttributePattern attributePattern) {
        return DtdOutput.getAttributeAnnotation(attributePattern, "http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue");
    }

    private static String getAttributeAnnotation(Annotated annotated, String string, String string2) {
        List<AttributeAnnotation> list = annotated.getAttributeAnnotations();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeAnnotation attributeAnnotation = list.get(i);
            if (!attributeAnnotation.getLocalName().equals(string2) || !attributeAnnotation.getNamespaceUri().equals(string)) continue;
            return attributeAnnotation.getValue();
        }
        return null;
    }

    static class WrappedIOException
    extends RuntimeException {
        final IOException cause;

        WrappedIOException(IOException iOException) {
            this.cause = iOException;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    class GrammarOutput
    implements ComponentVisitor<VoidValue> {
        GrammarOutput() {
        }

        public void visitContainer(Container container) {
            List<Component> list = container.getComponents();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
        }

        @Override
        public VoidValue visitDiv(DivComponent divComponent) {
            DtdOutput.this.outputLeadingComments(divComponent);
            DtdOutput.this.outputInitialChildComments(divComponent);
            this.visitContainer(divComponent);
            DtdOutput.this.outputFollowingComments(divComponent);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            if (defineComponent.getName() == DefineComponent.START) {
                DtdOutput.this.outputLeadingComments(defineComponent);
                DtdOutput.this.outputFollowingComments(defineComponent);
                if (DtdOutput.this.analysis.getPattern() == DtdOutput.this.analysis.getGrammarPattern()) {
                    defineComponent.getBody().accept(DtdOutput.this.nestedContentModelOutput);
                }
            } else if (DtdOutput.this.getContentType(defineComponent.getBody()) == ContentType.DIRECT_SINGLE_ELEMENT) {
                DtdOutput.this.outputElement((ElementPattern)defineComponent.getBody(), defineComponent);
            } else if (!DtdOutput.this.doneParamEntities.contains(defineComponent.getName())) {
                DtdOutput.this.doneParamEntities.add(defineComponent.getName());
                DtdOutput.this.outputParamEntity(defineComponent);
            }
            DtdOutput.this.outputQueuedElements();
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            DtdOutput.this.outputInclude(includeComponent);
            return VoidValue.VOID;
        }
    }

    private class ValueOutput
    extends PatternOutput {
        private ValueOutput() {
        }

        @Override
        public VoidValue visitValue(ValuePattern valuePattern) {
            DtdOutput.this.buf.append("CDATA #FIXED ");
            DtdOutput.this.attributeValueLiteral(valuePattern.getValue());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            DtdOutput.this.paramEntityRef(refPattern);
            return VoidValue.VOID;
        }
    }

    class TopLevelSimpleTypeOutput
    extends SimpleTypeOutput {
        TopLevelSimpleTypeOutput() {
        }

        @Override
        public VoidValue visitList(ListPattern listPattern) {
            if (DtdOutput.this.warnDatatypes) {
                DtdOutput.this.er.warning("list_approx", listPattern.getSourceLocation());
            }
            DtdOutput.this.buf.append("CDATA");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitValue(ValuePattern valuePattern) {
            if (DtdOutput.this.getContentType(valuePattern) == ContentType.ENUM) {
                DtdOutput.this.buf.append('(');
                super.visitValue(valuePattern);
                DtdOutput.this.buf.append(')');
            } else {
                Datatypes.Info info = Datatypes.getInfo(valuePattern.getDatatypeLibrary(), valuePattern.getType());
                if (info == null) {
                    DtdOutput.this.er.warning("unrecognized_datatype", valuePattern.getSourceLocation());
                    DtdOutput.this.buf.append("CDATA");
                } else {
                    String string = info.closestType();
                    if (DtdOutput.this.warnDatatypes) {
                        DtdOutput.this.er.warning("value_approx", string, valuePattern.getSourceLocation());
                    }
                    DtdOutput.this.buf.append(string);
                }
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoicePattern choicePattern) {
            ContentType contentType = DtdOutput.this.getContentType(choicePattern);
            if (contentType == ContentType.ENUM) {
                DtdOutput.this.buf.append('(');
                DtdOutput.this.nestedSimpleTypeOutput.visitChoice(choicePattern);
                DtdOutput.this.buf.append(')');
            } else if (contentType == ContentType.SIMPLE_TYPE_CHOICE) {
                if (DtdOutput.this.warnDatatypes) {
                    DtdOutput.this.er.warning("datatype_choice_approx", choicePattern.getSourceLocation());
                }
                DtdOutput.this.buf.append("CDATA");
            } else {
                super.visitChoice(choicePattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            ContentType contentType = DtdOutput.this.getContentType(refPattern);
            if (contentType == ContentType.ENUM) {
                DtdOutput.this.buf.append('(');
                super.visitRef(refPattern);
                DtdOutput.this.buf.append(')');
            } else if (contentType == ContentType.TEXT) {
                DtdOutput.this.buf.append("CDATA");
            } else {
                super.visitRef(refPattern);
            }
            return VoidValue.VOID;
        }
    }

    class SimpleTypeOutput
    extends PatternOutput {
        SimpleTypeOutput() {
        }

        @Override
        public VoidValue visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append("CDATA");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitValue(ValuePattern valuePattern) {
            DtdOutput.this.buf.append(valuePattern.getValue());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            DtdOutput.this.paramEntityRef(refPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitData(DataPattern dataPattern) {
            Datatypes.Info info = Datatypes.getInfo(dataPattern.getDatatypeLibrary(), dataPattern.getType());
            if (info == null) {
                DtdOutput.this.er.warning("unrecognized_datatype", dataPattern.getSourceLocation());
                DtdOutput.this.buf.append("CDATA");
            } else {
                if (DtdOutput.this.warnDatatypes) {
                    if (!info.isExact()) {
                        DtdOutput.this.er.warning("datatype_approx", dataPattern.getType(), info.closestType(), dataPattern.getSourceLocation());
                    } else {
                        for (Param param : dataPattern.getParams()) {
                            DtdOutput.this.er.warning("ignore_param", param.getName(), dataPattern.getType(), dataPattern.getSourceLocation());
                        }
                        if (dataPattern.getExcept() != null) {
                            DtdOutput.this.er.warning("ignore_except", dataPattern.getType(), dataPattern.getSourceLocation());
                        }
                    }
                }
                DtdOutput.this.buf.append(info.closestType());
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoicePattern choicePattern) {
            ContentType contentType;
            Pattern pattern;
            int n;
            List<Pattern> list = choicePattern.getChildren();
            boolean bl = false;
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                pattern = list.get(n);
                contentType = DtdOutput.this.getContentType(pattern);
                if (contentType == ContentType.NOT_ALLOWED) continue;
                if (bl) {
                    DtdOutput.this.buf.append('|');
                } else {
                    bl = true;
                }
                pattern.accept(this);
            }
            for (n = 0; n < n2; ++n) {
                pattern = list.get(n);
                contentType = DtdOutput.this.getContentType(pattern);
                if (contentType != ContentType.NOT_ALLOWED) continue;
                if (bl) {
                    DtdOutput.this.buf.append(' ');
                } else {
                    bl = true;
                }
                pattern.accept(this);
            }
            return VoidValue.VOID;
        }
    }

    class OptionalAttributeOutput
    extends AttributeOutput {
        OptionalAttributeOutput() {
        }

        @Override
        boolean isRequired() {
            return false;
        }
    }

    class AttributeOutput
    extends PatternOutput {
        AttributeOutput() {
        }

        void output(Pattern pattern) {
            if (DtdOutput.this.getAttributeType(pattern) != AttributeType.EMPTY) {
                pattern.accept(this);
            }
        }

        void newlineIndent() {
            DtdOutput.this.buf.append(DtdOutput.this.lineSep);
            for (int i = 0; i < DtdOutput.this.indent; ++i) {
                DtdOutput.this.buf.append(' ');
            }
        }

        @Override
        public VoidValue visitComposite(CompositePattern compositePattern) {
            List<Pattern> list = compositePattern.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.output(list.get(i));
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitMixed(MixedPattern mixedPattern) {
            this.output(mixedPattern.getChild());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            this.output(oneOrMorePattern.getChild());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            if (DtdOutput.this.getAttributeType(zeroOrMorePattern) != AttributeType.SINGLE) {
                DtdOutput.this.er.warning("attribute_occur_approx", zeroOrMorePattern.getSourceLocation());
            }
            DtdOutput.this.optionalAttributeOutput.output(zeroOrMorePattern.getChild());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            ContentType contentType = DtdOutput.this.getContentType(refPattern);
            if (contentType.isA(ContentType.EMPTY) && this.isRequired()) {
                if (DtdOutput.this.analysis.getParamEntityElementName(refPattern.getName()) == null) {
                    this.newlineIndent();
                    DtdOutput.this.paramEntityRef(refPattern);
                }
            } else {
                this.output(DtdOutput.this.getBody(refPattern.getName()));
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitAttribute(AttributePattern attributePattern) {
            ContentType contentType = DtdOutput.this.getContentType(attributePattern.getChild());
            if (contentType == ContentType.NOT_ALLOWED) {
                return VoidValue.VOID;
            }
            List<NameNameClass> list = NameClassSplitter.split(attributePattern.getNameClass());
            int n = list.size();
            if (n > 1) {
                DtdOutput.this.er.warning("attribute_occur_approx", attributePattern.getSourceLocation());
            }
            for (int i = 0; i < n; ++i) {
                int n2 = DtdOutput.this.buf.length();
                this.newlineIndent();
                NameNameClass nameNameClass = list.get(i);
                String string = nameNameClass.getNamespaceUri();
                if (!string.equals("") && string != NameClass.INHERIT_NS) {
                    String string2 = DtdOutput.this.analysis.getPrefixForNamespaceUri(string);
                    DtdOutput.this.buf.append(string2);
                    DtdOutput.this.buf.append(':');
                }
                DtdOutput.this.buf.append(nameNameClass.getLocalName());
                DtdOutput.this.buf.append(' ');
                if (contentType == ContentType.VALUE) {
                    attributePattern.getChild().accept(DtdOutput.this.valueOutput);
                    continue;
                }
                int n3 = DtdOutput.this.buf.length();
                if (contentType.isA(ContentType.SIMPLE_TYPE) || contentType == ContentType.TEXT) {
                    attributePattern.getChild().accept(DtdOutput.this.topLevelSimpleTypeOutput);
                } else if (contentType == ContentType.EMPTY) {
                    DtdOutput.this.er.warning("empty_attribute_approx", attributePattern.getSourceLocation());
                    DtdOutput.this.buf.append("CDATA");
                }
                int n4 = DtdOutput.this.buf.length();
                if (this.isRequired() && n == 1) {
                    DtdOutput.this.buf.append(" #REQUIRED");
                } else {
                    String string3 = DtdOutput.getDefaultValue(attributePattern);
                    if (string3 == null) {
                        DtdOutput.this.buf.append(" #IMPLIED");
                    } else {
                        DtdOutput.this.buf.append(' ');
                        DtdOutput.this.attributeValueLiteral(string3);
                    }
                }
                int n5 = n2 + DtdOutput.this.lineSep.length();
                if (DtdOutput.this.buf.length() - n5 <= DtdOutput.this.lineLength || !contentType.isA(ContentType.ENUM)) continue;
                ModelBreaker modelBreaker = new ModelBreaker(DtdOutput.this.buf.substring(n5, n3), DtdOutput.this.buf.substring(n3, n4), DtdOutput.this.buf.substring(n4), DtdOutput.this.lineLength);
                DtdOutput.this.buf.setLength(n2);
                while (modelBreaker.hasNextLine()) {
                    DtdOutput.this.buf.append(DtdOutput.this.lineSep);
                    DtdOutput.this.buf.append(modelBreaker.nextLine());
                }
            }
            return VoidValue.VOID;
        }

        boolean isRequired() {
            return true;
        }

        @Override
        public VoidValue visitChoice(ChoicePattern choicePattern) {
            if (DtdOutput.this.getAttributeType(choicePattern) != AttributeType.EMPTY) {
                DtdOutput.this.er.warning("attribute_occur_approx", choicePattern.getSourceLocation());
            }
            DtdOutput.this.optionalAttributeOutput.visitComposite(choicePattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOptional(OptionalPattern optionalPattern) {
            if (DtdOutput.this.getAttributeType(optionalPattern) != AttributeType.SINGLE) {
                DtdOutput.this.er.warning("attribute_occur_approx", optionalPattern.getSourceLocation());
            }
            DtdOutput.this.optionalAttributeOutput.output(optionalPattern.getChild());
            return VoidValue.VOID;
        }
    }

    class ExpandedInnerElementClassOutput
    extends InnerElementClassOutput {
        ExpandedInnerElementClassOutput() {
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.getChild().accept(DtdOutput.this.expandedContentModelOutput);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getChild().accept(DtdOutput.this.expandedContentModelOutput);
            return VoidValue.VOID;
        }
    }

    class InnerElementClassOutput
    extends PatternOutput {
        InnerElementClassOutput() {
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            DtdOutput.this.getBody(refPattern.getName()).accept(DtdOutput.this.expandedInnerElementClassOutput);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitComposite(CompositePattern compositePattern) {
            Pattern pattern;
            int n;
            List<Pattern> list = compositePattern.getChildren();
            boolean bl = false;
            int n2 = -1;
            int n3 = list.size();
            for (n = 0; n < n3; ++n) {
                pattern = list.get(n);
                ContentType contentType = DtdOutput.this.getContentType(pattern);
                if (!contentType.isA(ContentType.MIXED_MODEL) && contentType != ContentType.TEXT) continue;
                pattern.accept(this);
                bl = true;
                n2 = n;
                break;
            }
            n3 = list.size();
            for (n = 0; n < n3; ++n) {
                if (n == n2 || DtdOutput.this.getContentType(pattern = list.get(n)) == ContentType.EMPTY) continue;
                if (bl) {
                    DtdOutput.this.buf.append('|');
                } else {
                    bl = true;
                }
                pattern.accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitMixed(MixedPattern mixedPattern) {
            if (DtdOutput.this.getContentType(mixedPattern.getChild()) == ContentType.EMPTY) {
                DtdOutput.this.buf.append("#PCDATA");
            } else {
                DtdOutput.this.buf.append("#PCDATA|");
                mixedPattern.getChild().accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append("#PCDATA");
            return VoidValue.VOID;
        }
    }

    class PatternOutput
    extends AbstractPatternVisitor<VoidValue> {
        PatternOutput() {
        }

        @Override
        public VoidValue visitPattern(Pattern pattern) {
            return VoidValue.VOID;
        }
    }

    class ExpandedContentModelOutput
    extends ContentModelOutput {
        ExpandedContentModelOutput() {
        }

        @Override
        public VoidValue visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            return VoidValue.VOID;
        }
    }

    class TopLevelContentModelOutput
    extends ContentModelOutput {
        TopLevelContentModelOutput() {
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            DtdOutput.this.buf.append('(');
            zeroOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            DtdOutput.this.buf.append('*');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            DtdOutput.this.buf.append('(');
            oneOrMorePattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            ContentType contentType = DtdOutput.this.getContentType(oneOrMorePattern);
            if (contentType.isA(ContentType.MIXED_MODEL)) {
                DtdOutput.this.buf.append('*');
            } else {
                DtdOutput.this.buf.append('+');
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOptional(OptionalPattern optionalPattern) {
            DtdOutput.this.buf.append('(');
            optionalPattern.getChild().accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            DtdOutput.this.buf.append('?');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitElement(ElementPattern elementPattern) {
            DtdOutput.this.buf.append('(');
            super.visitElement(elementPattern);
            DtdOutput.this.buf.append(')');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            ContentType contentType = DtdOutput.this.getContentType(refPattern);
            if (contentType.isA(ContentType.MIXED_MODEL)) {
                super.visitRef(refPattern);
            } else {
                DtdOutput.this.buf.append('(');
                super.visitRef(refPattern);
                DtdOutput.this.buf.append(')');
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoicePattern choicePattern) {
            DtdOutput.this.buf.append('(');
            choicePattern.accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append('(');
            textPattern.accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitMixed(MixedPattern mixedPattern) {
            DtdOutput.this.buf.append('(');
            if (DtdOutput.this.getContentType(mixedPattern.getChild()) == ContentType.EMPTY) {
                DtdOutput.this.buf.append("#PCDATA)");
            } else {
                DtdOutput.this.buf.append("#PCDATA|");
                mixedPattern.getChild().accept(DtdOutput.this.innerElementClassOutput);
                DtdOutput.this.buf.append(')');
                DtdOutput.this.buf.append('*');
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitGroup(GroupPattern groupPattern) {
            List<Pattern> list = groupPattern.getChildren();
            Pattern pattern = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Pattern pattern2 = list.get(i);
                if (DtdOutput.this.getContentType(pattern2).isA(ContentType.EMPTY)) continue;
                if (pattern == null) {
                    pattern = pattern2;
                    continue;
                }
                DtdOutput.this.buf.append('(');
                DtdOutput.this.nestedContentModelOutput.visitGroup(groupPattern);
                DtdOutput.this.buf.append(')');
                return VoidValue.VOID;
            }
            if (pattern != null) {
                pattern.accept(this);
            }
            return VoidValue.VOID;
        }
    }

    class ContentModelOutput
    extends AbstractVisitor {
        ContentModelOutput() {
        }

        @Override
        public VoidValue visitName(NameNameClass nameNameClass) {
            String string = DtdOutput.this.analysis.getElementPrefixForNamespaceUri(nameNameClass.getNamespaceUri());
            if (string != null) {
                DtdOutput.this.buf.append(string).append(':');
            }
            DtdOutput.this.buf.append(nameNameClass.getLocalName());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
            List<NameClass> list = choiceNameClass.getChildren();
            boolean bl = false;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    DtdOutput.this.buf.append('|');
                } else {
                    bl = true;
                }
                list.get(i).accept(this);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            DtdOutput.this.elementQueue.add(elementPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            Pattern pattern = DtdOutput.this.getBody(refPattern.getName());
            if (DtdOutput.this.getContentType(pattern) == ContentType.DIRECT_SINGLE_ELEMENT) {
                ((ElementPattern)pattern).getNameClass().accept(this);
            } else {
                DtdOutput.this.paramEntityRef(refPattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.getChild().accept(DtdOutput.this.occurContentModelOutput);
            DtdOutput.this.buf.append('*');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getChild().accept(DtdOutput.this.occurContentModelOutput);
            ContentType contentType = DtdOutput.this.getContentType(oneOrMorePattern);
            if (contentType.isA(ContentType.MIXED_MODEL)) {
                DtdOutput.this.buf.append('*');
            } else {
                DtdOutput.this.buf.append('+');
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOptional(OptionalPattern optionalPattern) {
            optionalPattern.getChild().accept(DtdOutput.this.occurContentModelOutput);
            DtdOutput.this.buf.append('?');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitText(TextPattern textPattern) {
            DtdOutput.this.buf.append("#PCDATA");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitMixed(MixedPattern mixedPattern) {
            DtdOutput.this.buf.append("#PCDATA");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitGroup(GroupPattern groupPattern) {
            List<Pattern> list = groupPattern.getChildren();
            boolean bl = false;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Pattern pattern = list.get(i);
                ContentType contentType = DtdOutput.this.getContentType(pattern);
                if (contentType.isA(ContentType.EMPTY)) continue;
                if (bl) {
                    DtdOutput.this.buf.append(',');
                } else {
                    bl = true;
                }
                pattern.accept(DtdOutput.this.groupContentModelOutput);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInterleave(InterleavePattern interleavePattern) {
            ContentType contentType = DtdOutput.this.getContentType(interleavePattern);
            if (contentType == ContentType.INTERLEAVE_ZERO_OR_MORE_ELEMENT_CLASS || contentType == ContentType.INTERLEAVE_MIXED_MODEL) {
                DtdOutput.this.buf.append('(');
                interleavePattern.accept(DtdOutput.this.innerElementClassOutput);
                DtdOutput.this.buf.append(')');
                DtdOutput.this.buf.append('*');
            } else {
                List<Pattern> list = interleavePattern.getChildren();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Pattern pattern = list.get(i);
                    ContentType contentType2 = DtdOutput.this.getContentType(pattern);
                    if (contentType2.isA(ContentType.EMPTY)) continue;
                    pattern.accept(this);
                }
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoicePattern choicePattern) {
            ContentType contentType;
            Pattern pattern;
            int n;
            List<Pattern> list = choicePattern.getChildren();
            boolean bl = false;
            int n2 = list.size();
            if (DtdOutput.this.getContentType(choicePattern).isA(ContentType.MIXED_ELEMENT_CLASS)) {
                for (n = 0; n < n2; ++n) {
                    pattern = list.get(n);
                    if (!DtdOutput.this.getContentType(pattern).isA(ContentType.MIXED_ELEMENT_CLASS)) continue;
                    pattern.accept(DtdOutput.this.nestedContentModelOutput);
                    bl = true;
                    break;
                }
            }
            for (n = 0; n < n2; ++n) {
                pattern = list.get(n);
                contentType = DtdOutput.this.getContentType(pattern);
                if (contentType == ContentType.NOT_ALLOWED || contentType == ContentType.EMPTY || contentType.isA(ContentType.MIXED_ELEMENT_CLASS)) continue;
                if (bl) {
                    DtdOutput.this.buf.append('|');
                } else {
                    bl = true;
                }
                pattern.accept(!contentType.isA(ContentType.ELEMENT_CLASS) ? DtdOutput.this.choiceContentModelOutput : DtdOutput.this.nestedContentModelOutput);
            }
            for (n = 0; n < n2; ++n) {
                pattern = list.get(n);
                contentType = DtdOutput.this.getContentType(pattern);
                if (contentType != ContentType.NOT_ALLOWED) continue;
                if (bl) {
                    DtdOutput.this.buf.append(' ');
                } else {
                    bl = true;
                }
                pattern.accept(DtdOutput.this.nestedContentModelOutput);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitGrammar(GrammarPattern grammarPattern) {
            return DtdOutput.this.getBody(DefineComponent.START).accept(this);
        }
    }

    private class GroupContentModelOutput
    extends ChoiceContentModelOutput {
        private GroupContentModelOutput() {
        }

        @Override
        public VoidValue visitGroup(GroupPattern groupPattern) {
            groupPattern.accept(DtdOutput.this.nestedContentModelOutput);
            return VoidValue.VOID;
        }
    }

    class ChoiceContentModelOutput
    extends ParenthesizedContentModelOutput {
        ChoiceContentModelOutput() {
        }

        @Override
        public VoidValue visitOptional(OptionalPattern optionalPattern) {
            optionalPattern.accept(DtdOutput.this.nestedContentModelOutput);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.accept(DtdOutput.this.nestedContentModelOutput);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            zeroOrMorePattern.accept(DtdOutput.this.nestedContentModelOutput);
            return VoidValue.VOID;
        }
    }

    class ParenthesizedContentModelOutput
    extends AbstractPatternVisitor<VoidValue> {
        ParenthesizedContentModelOutput() {
        }

        @Override
        public VoidValue visitPattern(Pattern pattern) {
            DtdOutput.this.buf.append('(');
            pattern.accept(DtdOutput.this.nestedContentModelOutput);
            DtdOutput.this.buf.append(')');
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            Pattern pattern = DtdOutput.this.getBody(refPattern.getName());
            if (DtdOutput.this.getContentType(pattern) == ContentType.DIRECT_SINGLE_ELEMENT) {
                ((ElementPattern)pattern).getNameClass().accept(DtdOutput.this.nestedContentModelOutput);
            } else {
                this.visitPattern(refPattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitElement(ElementPattern elementPattern) {
            if (DtdOutput.this.getContentType(elementPattern) == ContentType.DIRECT_SINGLE_ELEMENT) {
                elementPattern.getNameClass().accept(DtdOutput.this.nestedContentModelOutput);
                DtdOutput.this.elementQueue.add(elementPattern);
            } else {
                this.visitPattern(elementPattern);
            }
            return VoidValue.VOID;
        }
    }
}

