/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PluralSnapshot;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Timer;

public class Misc {
    static final Normalizer2 nfc = Normalizer2.getInstance(null, "nfc", Normalizer2.Mode.COMPOSE);
    static final Normalizer2 nfd = Normalizer2.getInstance(null, "nfc", Normalizer2.Mode.DECOMPOSE);

    public static void main(String[] args) throws IOException {
        Misc.showDefaultContent("bn", "sw", "mr", "ta", "ms", "am", "af", "zu", "et", "is", "ur", "te", "gu", "kn", "ml", "gl", "eu");
        Misc.showSortKey();
        Misc.showNumberSamples();
        Misc.showDateSamples();
        Misc.showExemplarSize();
        Misc.doNFC();
        Misc.showPlurals();
        String[] locales = "zh en es hi fr ar pt ru id bn ur ja de fil sw pa jv ko tr vi it te mr th fa ta pl lah gu my ms uk zh_Hant kn su ml nl az or ro uz bho ps ha ku mad yo ig si mg sd hu am om kk el ne be mai sr cs km as sv mag mwr sn ny ca bg hne tg bgc ii he dcc ug fuv qu rw min af zu mn bjn so ki hr ak tk fi sq da bya sk gn bal no lua xh bs ht syl ka bjj ban sat hy za luy rn bug bem luo wtm st lo gl ti shn ceb ks mfa ace lt ky bm lg shi tn bcl glk war kok bew kln kam umb bo suk ee kmb ay pam bhk sas bbc swv nso tpi rjb gbm lmn ff kab sl ts ba cv kri gon ndc guz wo tzm mak kfy ln ljp mk efi ibb doi awa mos nyn vmw mer kru lv sid pag gno sck tcy wbq nd lrc ss cgg brh xog nn sg xnr dyu rmt teo kxm mdh hno lu eu khn wbr tsg rej rif brx ilo kbd et ce kg fy hil kj cy ast av ve udm ga tt sah myv tet gaa ady mt dv fj nr is mdf kum kha sm kpv lez pap krc inh oc se tyv zdj dz bi gag to koi lbe mi ab os ty kl gil iu ch fo rm mh chk haw pon lb pau tvl sa kos na ho yap gd uli niu la tkl eo kl".split(" ");
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        for (String locale : locales) {
            Set<SupplementalDataInfo.BasicLanguageData> items = sdi.getBasicLanguageData(locale);
            if (items == null) {
                System.out.println(locale + "\t?");
                continue;
            }
            scripts.clear();
            for (SupplementalDataInfo.BasicLanguageData item : items) {
                Set<String> script2;
                if (item.getType() == SupplementalDataInfo.BasicLanguageData.Type.secondary || (script2 = item.getScripts()) == null) continue;
                scripts.addAll(script2);
            }
            if (scripts.size() == 0) {
                System.out.println(locale + "\t?");
                continue;
            }
            if (locale.equals("zh")) {
                scripts.remove("Hant");
            } else if (locale.equals("zh_Hant")) {
                scripts.add("Hant");
            }
            System.out.println(locale + "\t" + Joiner.on(" ").join(scripts));
        }
        Transliterator unicode = Transliterator.getInstance("hex/unicode");
        UnicodeSet exclude = new UnicodeSet("[:bidimirrored:]");
        for (int i = 0; i < 0x110000; ++i) {
            int rev;
            String reverse;
            String name;
            if (exclude.contains(i) || (name = UCharacter.getExtendedName(i)) == null || (reverse = name.replaceAll("RIGHT", "LEFT")).equals(name) && (reverse = name.replaceAll("REVERSED ", "")).equals(name) || (rev = UCharacter.getCharFromName(reverse)) == -1) continue;
            System.out.println(unicode.transform(UTF16.valueOf(i)) + "\t" + UTF16.valueOf(i) + "\t" + name + "\t" + UTF16.valueOf(rev) + "\t" + unicode.transform(UTF16.valueOf(rev)) + "\t" + reverse);
        }
        System.out.println(Locale.SIMPLIFIED_CHINESE);
        System.out.println(Locale.TRADITIONAL_CHINESE);
        for (String s2 : StandardCodes.make().getGoodCountries()) {
            System.out.println(s2 + "\t" + ULocale.getDisplayCountry("und-" + s2, ULocale.ENGLISH));
        }
    }

    private static void showDefaultContent(String ... strings) {
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
        CLDRConfig info = ToolConfig.getToolInstance();
        CLDRFile english = info.getEnglish();
        Set<String> defaultContents = sdi.getDefaultContentLocales();
        for (String string : strings) {
            String defCon = null;
            for (String dc : defaultContents) {
                if (!string.equals(LocaleIDParser.getParent(dc))) continue;
                defCon = dc;
                break;
            }
            System.out.println(string + "\t" + defCon + "\t" + english.getName(defCon));
        }
    }

    private static void showSortKey() {
        String[] tests = "a \u00e4 A \u3041 \u3042 \u30a1 \uff67 \u30a2 \uff71 \u32d0".split(" ");
        RuleBasedCollator c = (RuleBasedCollator)Collator.getInstance(ULocale.ENGLISH);
        c.setStrength(3);
        c.setCaseLevel(true);
        c.setHiraganaQuaternary(true);
        for (String test : tests) {
            for (boolean caseLevel : new boolean[]{false, true}) {
                c.setCaseLevel(caseLevel);
                for (boolean hiraganaQuaternary : new boolean[]{false, true}) {
                    c.setHiraganaQuaternary(hiraganaQuaternary);
                    System.out.print(caseLevel ? "Cl\t" : "\t");
                    System.out.print(hiraganaQuaternary ? "Hl\t" : "\t");
                    System.out.print(test + "\t");
                    RawCollationKey key = c.getRawCollationKey(test, null);
                    for (byte item : key.bytes) {
                        System.out.print(Integer.toHexString(0xFF & item) + "\t");
                    }
                    System.out.println();
                }
            }
        }
    }

    private static void showNumberSamples() {
        String[] tests;
        for (String test : tests = new String[]{"a$b", "abcd_defg-hi", "abcd-defg$xy", "ab-d$efg-419", "root", "", "und"}) {
            ULocale locale = ULocale.forLanguageTag(test);
            System.out.println(test + " -> " + locale);
        }
        DecimalFormat df = new DecimalFormat("***");
        for (int i = 10; i > -10; --i) {
            String sample = df.format(1.23456789 * Math.pow(10.0, i));
            System.out.println(sample);
        }
    }

    private static void showDateSamples() {
        TreeMap<String, Row.R2<Integer, Integer>> specials = Builder.with(new TreeMap()).put("full-date", Row.of(0, -1)).put("long-date", Row.of(1, -1)).put("medium-date", Row.of(2, -1)).put("short-date", Row.of(3, -1)).put("full-time", Row.of(-1, 0)).put("long-time", Row.of(-1, 1)).put("medium-time", Row.of(-1, 2)).put("short-time", Row.of(-1, 3)).freeze();
        Date sample = new Date(111, 11, 30, 14, 45, 59);
        ULocale english = ULocale.ENGLISH;
        ULocale otherLocale = new ULocale("el");
        DateTimePatternGenerator englishGenerator = DateTimePatternGenerator.getInstance(english);
        DateTimePatternGenerator otherGenerator = DateTimePatternGenerator.getInstance(otherLocale);
        for (String dp : new String[]{"d", "h", "H", "hm", "Hm", "Hms", "hms", "hmv", "Hmv", "hv", "Hv", "M", "Md", "MEd", "MMM", "MMMd", "MMMEd", "ms", "y", "yM", "yMd", "yMEd", "yMMM", "yMMMd", "yMMMEd", "yMMMM", "yQ", "yQQQ", "EEEd", "full-date", "long-date", "medium-date", "short-date", "full-time", "long-time", "medium-time", "short-time", "MMMM", "MMMMd", "E", "Ed", "GGGGyMd", "GGGGyMMMMEEEEdd", "GGGGyyyyMMMMd", "HHmm", "HHmmss", "HHmmZ", "Hmm", "MMd", "MMdd", "MMMdd", "MMMEEEd", "MMMMdd", "MMMMEd", "MMMMEEEd", "mmss", "yMMMMccccd", "yyMM", "yyMMdd", "yyMMM", "yyMMMd", "yyMMMEEEd", "yyQ", "yyQQQQ", "yyyy", "yyyyLLLL", "yyyyM", "yyyyMEEEd", "yyyyMM", "yyyyMMM", "yyyyMMMM", "yyyyMMMMEEEEd", "yyyyQQQQ", "hmz", "hz", "LLL", "LLLL", "MMMMEEEEd", "yMMMMd", "yMMMMEEEEd"}) {
            String formattedEnglish = Misc.getFormatted(specials, sample, dp, english, englishGenerator);
            String formattedOther = Misc.getFormatted(specials, sample, dp, otherLocale, otherGenerator);
            System.out.println(dp + "\t\u00ab" + formattedEnglish + "\u00bb\t\u00ab" + formattedOther + "\u00bb");
        }
    }

    private static String getFormatted(Map<String, Row.R2<Integer, Integer>> specials, Date sample, String dp, ULocale ulocale, DateTimePatternGenerator generator) {
        DateFormat df;
        Row.R2<Integer, Integer> special = specials.get(dp);
        if (special != null) {
            df = DateFormat.getDateTimeInstance((int)((Integer)special.get0()), (int)((Integer)special.get1()), ulocale);
        } else {
            String pat = generator.getBestPattern(dp);
            df = new SimpleDateFormat(pat, ulocale);
        }
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String formatted = df.format(sample);
        return formatted;
    }

    private static void showExemplarSize() {
        CLDRConfig info = ToolConfig.getToolInstance();
        CLDRFile english = info.getEnglish();
        Factory factory = info.getCldrFactory();
        SupplementalDataInfo dataInfo = info.getSupplementalDataInfo();
        Map<String, Map<String, Row.R2<List<String>, String>>> type_tag_replacement = dataInfo.getLocaleAliasInfo();
        Map<String, Row.R2<List<String>, String>> lang2replacement = type_tag_replacement.get("language");
        LanguageTagParser ltp = new LanguageTagParser();
        String[] locales = "en ru nl en-GB fr de it pl pt-BR es tr th ja zh-CN zh-TW ko ar bg sr uk ca hr cs da fil fi hu id lv lt no pt-PT ro sk sl es-419 sv vi el iw fa hi am af et is ms sw zu bn mr ta eu fr-CA gl zh-HK ur gu kn ml te".split(" ");
        TreeSet<Object> nameAndInfo = new TreeSet<Object>(info.getCollator());
        for (String localeCode : locales) {
            String s2;
            int cp;
            String baseLanguage = ltp.set(localeCode).getLanguage();
            Row.R2<List<String>, String> temp = lang2replacement.get(baseLanguage);
            if (temp != null) {
                baseLanguage = (String)((List)temp.get0()).get(0);
            }
            String englishName = english.getName(baseLanguage);
            CLDRFile cldrFile = factory.make(baseLanguage, false);
            UnicodeSet set = cldrFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
            int script = -1;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext() && ((script = UScript.getScript(cp = (s2 = iterator.next()).codePointAt(0))) == 0 || script == 1)) {
            }
            String nativeName = cldrFile.getName(baseLanguage);
            nameAndInfo.add(englishName + "\t" + nativeName + "\t" + baseLanguage + "\t" + UScript.getShortName(script));
        }
        for (String string : nameAndInfo) {
            System.out.println(string);
        }
    }

    private static void doNFC() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 0x110000; ++i) {
            boolean isNfdNew;
            b.setLength(0);
            b.appendCodePoint(i);
            boolean isNfd = nfd.isNormalized(b);
            boolean bl = isNfdNew = IsNfd.isNormalizedUpTo(b) < 0;
            if (isNfd == isNfdNew) continue;
            IsNfd.isNormalizedUpTo(b);
            throw new IllegalArgumentException();
        }
        String[] tests = new String[]{"Mark", "\u039c\u03ac\u03c1\u03ba\u03bf\u03c2", nfd.normalize("\u039c\u03ac\u03c1\u03ba\u03bf\u03c2")};
        long[] times = new long[2];
        for (String test : tests) {
            times[1] = Long.MIN_VALUE;
            times[0] = Long.MIN_VALUE;
            Misc.time(nfc, test, 10000000, "NFC", times);
            Misc.time(nfd, test, 10000000, "NFD", times);
            Misc.time(test, 10000000, "NFDx", times);
        }
        System.out.println();
        for (String test : tests) {
            times[1] = Long.MIN_VALUE;
            times[0] = Long.MIN_VALUE;
            Misc.time(nfc, test, 100000000, "NFC", times);
            Misc.time(nfd, test, 100000000, "NFD", times);
            Misc.time(test, 100000000, "NFDx", times);
        }
    }

    private static void time(String test, int iterations, String name, long[] times) {
        System.out.println(test);
        System.gc();
        System.gc();
        System.gc();
        Timer t2 = new Timer();
        t2.start();
        for (int i = iterations; i > 0; --i) {
            IsNfd.isNormalizedUpTo(test);
        }
        long isNfc = t2.getDuration();
        if (times[0] != Long.MIN_VALUE) {
            System.out.println("\tis" + name + ":\t" + t2.toString(iterations, times[0]));
        } else {
            System.out.println("\tis" + name + ":\t" + t2.toString(iterations));
        }
        times[0] = isNfc;
        System.gc();
        System.gc();
        System.gc();
        t2.start();
        for (int i = iterations; i > 0; --i) {
            IsNfd.normalize(test);
        }
        long toNfc = t2.getDuration();
        if (times[1] != Long.MIN_VALUE) {
            System.out.println("\tto" + name + ":\t" + t2.toString(iterations, times[1]));
        } else {
            System.out.println("\tto" + name + ":\t" + t2.toString(iterations));
        }
        times[1] = toNfc;
    }

    private static void time(Normalizer2 nfx, String test, int iterations, String name, long[] times) {
        System.out.println(test);
        System.gc();
        System.gc();
        System.gc();
        Timer t2 = new Timer();
        t2.start();
        for (int i = iterations; i > 0; --i) {
            nfx.isNormalized(test);
        }
        long isNfc = t2.getDuration();
        if (times[0] != Long.MIN_VALUE) {
            System.out.println("\tis" + name + ":\t" + t2.toString(iterations, times[0]));
        } else {
            System.out.println("\tis" + name + ":\t" + t2.toString(iterations));
        }
        times[0] = isNfc;
        System.gc();
        System.gc();
        System.gc();
        t2.start();
        for (int i = iterations; i > 0; --i) {
            nfx.normalize(test);
        }
        long toNfc = t2.getDuration();
        if (times[1] != Long.MIN_VALUE) {
            System.out.println("\tto" + name + ":\t" + t2.toString(iterations, times[1]));
        } else {
            System.out.println("\tto" + name + ":\t" + t2.toString(iterations));
        }
        times[1] = toNfc;
    }

    private static void showPlurals() throws IOException {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "pluralTest.html");
        System.out.println(PluralSnapshot.getDefaultStyles());
        out.println("<html><head>" + PluralSnapshot.getDefaultStyles() + "</style><body>");
        PluralSnapshot.writeTables(testInfo.getEnglish(), out);
        out.println("</body></html>");
        out.close();
    }

    static class IsNfd {
        static final byte[] info = new byte[0x110000];

        IsNfd() {
        }

        public static String normalize(CharSequence s2) {
            int normalizedUpTo = IsNfd.isNormalizedUpTo(s2);
            if (normalizedUpTo < 0) {
                return s2.toString();
            }
            return nfd.normalizeSecondAndAppend(new StringBuilder(s2.subSequence(0, normalizedUpTo)), s2.subSequence(normalizedUpTo, s2.length())).toString();
        }

        public static int isNormalizedUpTo(CharSequence s2) {
            int length = s2.length();
            int lastNonStarterIndex = 0;
            int lastByte = 0;
            for (int i = 0; i < length; ++i) {
                int b;
                int cp = s2.charAt(i);
                if (cp >= 55296 && cp < 56320) {
                    cp = Character.codePointAt(s2, i);
                }
                if ((b = info[cp] & 0xFF) == 0) {
                    lastNonStarterIndex = i;
                    lastByte = b;
                } else if (b != lastByte) {
                    if (b < lastByte || b == 255) {
                        return lastNonStarterIndex;
                    }
                    lastByte = b;
                }
                if (cp <= 65535) continue;
                ++i;
            }
            return -1;
        }

        static {
            for (int i = 0; i < 0x110000; ++i) {
                int nfdqc = UCharacter.getIntPropertyValue(i, 4108);
                if (nfdqc == 0) {
                    IsNfd.info[i] = -1;
                    continue;
                }
                int ccc = UCharacter.getIntPropertyValue(i, 4098);
                IsNfd.info[i] = (byte)ccc;
            }
        }
    }
}

