/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;
import org.unicode.cldr.draft.PatternFixer;
import org.unicode.cldr.draft.RegexTransformBuilder;
import org.unicode.cldr.util.Timer;

public class TransformTest
extends TestFmwk {
    private static final boolean SHOW = false;
    private static final int TIMING_ITERATIONS = 10000;

    public static void main(String[] args) {
        new TransformTest().run(args);
    }

    public void TestFix() {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"!=", "([:m:])*"}, {"==", "(\\[:m:])*"}, {"==", "\\Q([:m:])*\\E"}, {"a(?:gh|[b])", "a[b{gh}]"}}) {
            if (test[0].equals("!=")) {
                this.assertNotEquals("Should be different", test[1], PatternFixer.fixJava(test[1]));
                continue;
            }
            this.assertEquals("Should be equal", test[0].equals("==") ? test[1] : test[0], PatternFixer.fixJava(test[1]));
        }
    }

    public void TestSomeBasic() {
        String[] tests = new String[]{"RULES", "ab > AB; ::NULL; BA > CD;", "ABAB", "RULES", "ab > AB; BA > CD;", "ABAB", "RULES", "D { a > A;c {(d)} e > X$1;d > D", "dabcdefgd", "ad", "Da", "RULES", "::[a-z];[:L:] { b } > B;B > M;z > Z;w > W;x > X;q > Q;C > Y;", "zB", "abXbCabXbCabXbCabXbCabXbCabXbCabXbCabXbCabXbCabXbCabX"};
        boolean setRules = true;
        StringTransform transform = null;
        Transliterator oldTransform = null;
        for (String testCase : tests) {
            if (testCase.equalsIgnoreCase("rules")) {
                setRules = true;
                continue;
            }
            if (setRules) {
                String rules = testCase;
                transform = RegexTransformBuilder.createFromRules(rules);
                oldTransform = Transliterator.createFromRules("foo", rules, 0);
                setRules = false;
                continue;
            }
            this.check(10000, testCase, transform, transform);
        }
    }

    public void TestCyrillic() {
        this.checkAgainstCurrent("Latin-Cyrillic", "abc", "Def", "ango");
    }

    public void TestGreek() {
        this.checkAgainstCurrent("Latin-Greek", "abk", "Delpho", "ango", "ago");
    }

    public void checkAgainstCurrent(String translitId, String ... tests) {
        Transliterator oldGreek = Transliterator.getInstance(translitId);
        String rules = oldGreek.toRules(false);
        StringTransform newGreek = RegexTransformBuilder.createFromRules(rules);
        for (String test : tests) {
            this.check(10000, test, newGreek, oldGreek);
        }
    }

    private void check(int iterations, String test, StringTransform newTransform, StringTransform oldTransform) {
        Timer t2 = new Timer();
        String result = null;
        String oldResult = null;
        t2.start();
        for (int i = 0; i < iterations; ++i) {
            result = newTransform.transform(test);
        }
        t2.stop();
        long newDuration = t2.getDuration();
        t2.start();
        for (int i = 0; i < iterations; ++i) {
            oldResult = oldTransform.transform(test);
        }
        t2.stop();
        long oldDuration = t2.getDuration();
        if (!result.equals(oldResult)) {
            this.errln("BAD:\t" + test + "\t=>\tnew:\t" + result + "\t!=\told:\t" + oldResult);
        } else {
            this.logln("OK:\t" + test + "\t=>\t" + result);
        }
        String percent = oldDuration == 0L ? "INF" : String.valueOf(newDuration * 100L / oldDuration - 100L);
        this.logln("new time: " + (double)newDuration / 1.0 / (double)iterations + "\told time: " + (double)oldDuration / 1.0 / (double)iterations + "\tnew%: " + percent + "%");
    }

    private void show(Transliterator oldTransform) {
        UnicodeFilter filter = oldTransform.getFilter();
        this.logln("Old:\n" + (String)(filter == null ? "" : filter.toString() + ";\n") + oldTransform.toRules(true));
    }
}

