/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.io.BufferedReader;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.StateMachine;
import org.unicode.cldr.draft.StateMachineBuilder;

public class UnicodeSetBuilder {
    private static final boolean SHOW_LINES = false;
    final StateMachine<UnicodeSet> machine;

    public UnicodeSetBuilder() {
        try {
            String line;
            BufferedReader in = FileUtilities.openUTF8Reader("../", "cldr-code/java/org/unicode/cldr/draft/UnicodeSetStates.txt");
            StateMachineBuilder<UnicodeSet> builder = new StateMachineBuilder<UnicodeSet>();
            while ((line = in.readLine()) != null) {
                builder.add(line);
            }
            in.close();
            this.machine = builder.build(new MyObjectBuilderFactory());
        }
        catch (Exception e) {
            throw (RuntimeException)new InternalError().initCause(e);
        }
    }

    public List<String> getActionNames() {
        return this.machine.getActionNames();
    }

    public UnicodeSet parse(String testLine, ParsePosition parsePosition) {
        return this.machine.parse(testLine, parsePosition);
    }

    private static final class MyObjectBuilder
    extends StateMachine.StateObjectBuilder<UnicodeSet> {
        private static final UnicodeSet WHITESPACE = new UnicodeSet("[:whitespace:]").freeze();
        private static final UnicodeSet NOT_WHITESPACE = new UnicodeSet("[:^whitespace:]").freeze();
        private static final UnicodeSet WORD = new UnicodeSet("[[:alphabetic:][:digit:]]").freeze();
        private static final UnicodeSet NOT_WORD = new UnicodeSet("[^[:alphabetic:][:digit:]]").freeze();
        private static final UnicodeSet DIGIT = new UnicodeSet("[:Nd:]").freeze();
        private static final UnicodeSet NOT_DIGIT = new UnicodeSet("[:^Nd:]").freeze();
        UnicodeSet current = new UnicodeSet();
        private Operation operation;
        private boolean negateSet;
        private String propertyName;
        private String valueName;
        private boolean negateProp;
        private List<Info> setStack = new ArrayList<Info>();
        private int lastLiteral = 0;
        private int lastPosition;

        private MyObjectBuilder() {
        }

        @Override
        protected void init(CharSequence string, StateMachine<UnicodeSet> stateMachine, int start) {
            super.init(string, stateMachine, start);
            this.lastPosition = start;
        }

        @Override
        protected UnicodeSet getResult() {
            return this.current;
        }

        @Override
        protected void handle(int position, StateMachine.StateAction action) {
            String actionName = this.getActionName(action.action);
            MyActions myAction = null;
            try {
                myAction = MyActions.valueOf(actionName);
            }
            catch (IllegalArgumentException e) {
                myAction = MyActions.unhandled;
            }
            if (StateMachine.SHOW_STATE_TRANSITIONS) {
                System.out.println("\t\t" + myAction + (String)(myAction == MyActions.unhandled ? ":" + actionName : ""));
            }
            switch (myAction) {
                case doSetNegate: {
                    this.negateSet = true;
                    break;
                }
                case doSetLiteral: 
                case doSetLiteralEscaped: {
                    this.lastLiteral = UTF16.charAt(this.string, position);
                    this.current.add(this.lastLiteral);
                    break;
                }
                case doHex: {
                    this.lastLiteral = Integer.parseInt(this.string.toString().substring(this.lastPosition + 2, position), 16);
                    this.current.add(this.lastLiteral);
                    break;
                }
                case doSetRange: {
                    this.lastLiteral = UTF16.charAt(this.string, position);
                    this.current.add(this.lastLiteral + 1, this.lastLiteral);
                    break;
                }
                case doName: {
                    this.lastLiteral = UCharacter.getCharFromExtendedName(this.string.toString().substring(this.lastPosition + 2, position));
                    this.current.add(this.lastLiteral);
                    break;
                }
                case doStartSetProp: {
                    this.negateProp = UTF16.charAt(this.string, position) == 80;
                    break;
                }
                case doPropName: {
                    this.propertyName = this.string.toString().substring(this.lastPosition + 2, position);
                    UnicodeSet propSet = new UnicodeSet().applyPropertyAlias(this.propertyName, "", null);
                    if (this.negateProp) {
                        propSet = propSet.complement();
                    }
                    this.current.addAll(propSet);
                    break;
                }
                case doPropRelation: {
                    this.propertyName = this.string.toString().substring(this.lastPosition + 2, position);
                    if (UTF16.charAt(this.string, position) == 61) break;
                    this.negateProp = !this.negateProp;
                    break;
                }
                case doPropValue: {
                    this.valueName = this.string.toString().substring(this.lastPosition + 1, position);
                    UnicodeSet propSet = new UnicodeSet().applyPropertyAlias(this.propertyName, this.valueName, null);
                    if (this.negateProp) {
                        propSet = propSet.complement();
                    }
                    this.current.addAll(propSet);
                    break;
                }
                case doSetAddAmp: {
                    this.lastLiteral = UTF16.charAt(this.string, position);
                    this.current.add(38).add(this.lastLiteral);
                }
                case doSetAddDash: {
                    this.lastLiteral = UTF16.charAt(this.string, position);
                    this.current.add(45).add(this.lastLiteral);
                }
                case doSetBackslash_s: {
                    this.current.addAll(WHITESPACE);
                    break;
                }
                case doSetBackslash_S: {
                    this.current.addAll(NOT_WHITESPACE);
                    break;
                }
                case doSetBackslash_w: {
                    this.current.addAll(WORD);
                    break;
                }
                case doSetBackslash_W: {
                    this.current.addAll(NOT_WORD);
                    break;
                }
                case doSetBackslash_d: {
                    this.current.addAll(DIGIT);
                    break;
                }
                case doSetBackslash_D: {
                    this.current.addAll(NOT_DIGIT);
                    break;
                }
                case doSetBeginUnion: {
                    this.current.addAll(NOT_WHITESPACE);
                    this.pushInfo(Operation.union);
                    break;
                }
                case doSetBeginDifference1: 
                case doSetDifference2: {
                    this.pushInfo(Operation.difference);
                    break;
                }
                case doSetBeginIntersection1: 
                case doSetIntersection2: {
                    this.pushInfo(Operation.intersection);
                    break;
                }
                case doSetEnd: {
                    int size;
                    if (this.negateSet) {
                        this.current.complement();
                    }
                    if ((size = this.setStack.size()) == 0) break;
                    Info popped = this.setStack.remove(size - 1);
                    UnicodeSet recent = this.current;
                    this.current = popped.set;
                    switch (this.operation) {
                        case union: {
                            this.current.addAll(recent);
                            break;
                        }
                        case difference: {
                            this.current.removeAll(recent);
                            break;
                        }
                        case intersection: {
                            this.current.retainAll(recent);
                            break;
                        }
                    }
                    this.negateSet = popped.negated;
                    this.operation = popped.operation;
                    break;
                }
            }
            if (StateMachine.SHOW_STATE_TRANSITIONS) {
                System.out.println("\t\tLiteral:" + Integer.toHexString(this.lastLiteral));
            }
            this.lastPosition = position;
        }

        private void pushInfo(Operation operation2) {
            this.setStack.add(new Info(this.current, this.negateSet, this.operation));
            this.current = new UnicodeSet();
            this.negateSet = false;
            this.operation = operation2;
        }

        private static class Info {
            UnicodeSet set;
            boolean negated;
            Operation operation;

            public Info(UnicodeSet set, boolean negated, Operation operation) {
                this.set = set;
                this.negated = negated;
                this.operation = operation;
            }
        }

        private static enum Operation {
            union,
            difference,
            intersection,
            symmetric;

        }
    }

    public static enum MyActions {
        unhandled,
        doSetLiteral,
        doSetLiteralEscaped,
        doHex,
        doSetRange,
        doSetNegate,
        doName,
        doPropName,
        doPropRelation,
        doPropValue,
        doStartSetProp,
        doSetBeginUnion,
        doSetEnd,
        doSetBeginDifference1,
        doSetBeginIntersection1,
        doSetDifference2,
        doSetIntersection2,
        doSetBackslash_s,
        doSetBackslash_S,
        doSetBackslash_w,
        doSetBackslash_W,
        doSetBackslash_d,
        doSetBackslash_D,
        doSetAddAmp,
        doSetAddDash;

    }

    private static final class MyObjectBuilderFactory
    implements StateMachine.StateObjectBuilderFactory<UnicodeSet> {
        private MyObjectBuilderFactory() {
        }

        @Override
        public StateMachine.StateObjectBuilder<UnicodeSet> getInstance() {
            return new MyObjectBuilder();
        }
    }
}

