/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.test.CasingInfo;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SpecialLocales;

public class CheckConsistentCasing
extends FactoryCheckCLDR {
    private static final boolean DEBUG = CldrUtility.getProperty("DEBUG", false);
    private static final double MIN_FACTOR = 2.5;
    ULocale uLocale = null;
    BreakIterator breaker = null;
    private String locale;
    CasingInfo casingInfo;
    private boolean hasCasingInfo;
    static final Matcher placeholder = PatternCache.get("\\{\\d+\\}").matcher("");
    static final RegexLookup<Category> pathToBucket = new RegexLookup<Category>().add("//ldml/localeDisplayNames/languages/language", Category.language).add("//ldml/localeDisplayNames/scripts/script", Category.script).add("//ldml/localeDisplayNames/territories/territory", Category.territory).add("//ldml/localeDisplayNames/variants/variant", Category.variant).add("//ldml/localeDisplayNames/keys/key", Category.key).add("//ldml/localeDisplayNames/types/type", Category.keyValue).add("//ldml/dates/calendars/calendar.*/months.*narrow", Category.month_narrow).add("//ldml/dates/calendars/calendar.*/months.*format", Category.month_format_except_narrow).add("//ldml/dates/calendars/calendar.*/months", Category.month_standalone_except_narrow).add("//ldml/dates/calendars/calendar.*/days.*narrow", Category.day_narrow).add("//ldml/dates/calendars/calendar.*/days.*format", Category.day_format_except_narrow).add("//ldml/dates/calendars/calendar.*/days", Category.day_standalone_except_narrow).add("//ldml/dates/calendars/calendar.*/eras/eraNarrow", Category.era_narrow).add("//ldml/dates/calendars/calendar.*/eras/eraAbbr", Category.era_abbr).add("//ldml/dates/calendars/calendar.*/eras/", Category.era_name).add("//ldml/dates/calendars/calendar.*/quarters.*narrow", Category.quarter_narrow).add("//ldml/dates/calendars/calendar.*/quarters.*abbreviated", Category.quarter_abbreviated).add("//ldml/dates/calendars/calendar.*/quarters.*format", Category.quarter_format_wide).add("//ldml/dates/calendars/calendar.*/quarters", Category.quarter_standalone_wide).add("//ldml/.*/relative", Category.relative).add("//ldml/dates/fields", Category.calendar_field).add("//ldml/dates/timeZoneNames/zone.*/exemplarCity", Category.zone_exemplarCity).add("//ldml/dates/timeZoneNames/zone.*/short", Category.zone_short).add("//ldml/dates/timeZoneNames/zone", Category.zone_long).add("//ldml/dates/timeZoneNames/metazone.*/commonlyUsed", Category.NOT_USED).add("//ldml/dates/timeZoneNames/metazone.*/short", Category.metazone_long).add("//ldml/dates/timeZoneNames/metazone", Category.metazone_long).add("//ldml/numbers/currencies/currency.*/symbol", Category.symbol).add("//ldml/numbers/currencies/currency.*/displayName.*@count", Category.currencyName_count).add("//ldml/numbers/currencies/currency.*/displayName", Category.currencyName).add("//ldml/units/unit.*/unitPattern.*(past|future)", Category.relative).add("//ldml/units/unit.*/unitPattern", Category.unit_pattern);
    Map<Category, CasingTypeAndErrFlag> types = new EnumMap<Category, CasingTypeAndErrFlag>(Category.class);
    private static final String CASE_WARNING = "The first letter of \u3008{0}\u3009 is {1}, which differs from what is expected for the {2} category: that almost all values be {3}.\n\n";

    public CheckConsistentCasing(Factory factory) {
        super(factory);
        this.casingInfo = new CasingInfo(factory);
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.locale = cldrFileToCheck.getLocaleID();
        String script = new LikelySubtags().getLikelyScript(this.locale);
        ScriptMetadata.Info localeInfo = ScriptMetadata.getInfo(script);
        if (localeInfo != null && localeInfo.hasCase == ScriptMetadata.Trinary.YES) {
            try {
                this.types = this.casingInfo.getLocaleCasing(this.locale);
            }
            catch (Exception e) {
                this.types = Collections.emptyMap();
            }
            if ((this.types == null || this.types.isEmpty()) && !SpecialLocales.isScratchLocale(this.locale)) {
                possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectCasing).setMessage("Could not load casing info for {0}", this.locale));
            }
        } else {
            this.types = Collections.emptyMap();
        }
        this.hasCasingInfo = this.types == null ? false : this.types.size() > 0;
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        Category category;
        if (fullPath == null) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        if (!this.hasCasingInfo) {
            return this;
        }
        String locale2 = this.getCldrFileToCheck().getSourceLocaleID(path, null);
        if (locale2.equals(this.locale) && value != null && value.length() > 0 && (category = CheckConsistentCasing.getCategory(path)) != null) {
            this.checkConsistentCasing(category, path, fullPath, value, options, result);
        }
        return this;
    }

    static Category getCategory(String path) {
        return pathToBucket.get(path);
    }

    public static Map<Category, CasingType> getSamples(CLDRFile resolved) {
        EnumMap counters = new EnumMap(Category.class);
        for (Category category : Category.values()) {
            counters.put(category, new Counter());
        }
        PathStarrer starrer = new PathStarrer();
        boolean isRoot = "root".equals(resolved.getLocaleID());
        TreeSet<String> missing = !DEBUG ? null : new TreeSet<String>();
        for (String path : resolved) {
            String winningPath;
            String locale2;
            if (!isRoot && ((locale2 = resolved.getSourceLocaleID(path, null)).equals("root") || locale2.equals("code-fallback")) || !(winningPath = resolved.getWinningPath(path)).equals(path)) continue;
            Category category = CheckConsistentCasing.getCategory(path);
            if (category != null) {
                String value = resolved.getStringValue(path);
                if (value == null || value.length() == 0) continue;
                CasingType ft = CasingType.from(value);
                ((Counter)counters.get((Object)category)).add(ft, 1L);
                continue;
            }
            if (!DEBUG) continue;
            String starred = starrer.set(path);
            missing.add(starred);
        }
        EnumMap<Category, CasingType> info = new EnumMap<Category, CasingType>(Category.class);
        for (Category category : Category.values()) {
            if (category == Category.NOT_USED) continue;
            Counter counter = (Counter)counters.get((Object)category);
            long countLower = counter.getCount(CasingType.lowercase);
            long countUpper = counter.getCount(CasingType.titlecase);
            long countOther = counter.getCount(CasingType.other);
            CasingType type = countLower + countUpper == 0L ? CasingType.other : ((double)countLower >= (double)countUpper * 2.5 && countLower >= countOther ? CasingType.lowercase : ((double)countUpper >= (double)countLower * 2.5 && countUpper >= countOther ? CasingType.titlecase : CasingType.other));
            info.put(category, type);
        }
        if (DEBUG && missing.size() != 0) {
            System.out.println("Paths skipped:\n" + Joiner.on("\n").join(missing));
        }
        return info;
    }

    private void checkConsistentCasing(Category category, String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (this.types != null) {
            CasingType ft = CasingType.from(value);
            CasingTypeAndErrFlag typeAndFlagFromCat = this.types.get((Object)category);
            if (typeAndFlagFromCat == null) {
                typeAndFlagFromCat = CasingTypeAndErrFlag.other_mismatchWarn;
            }
            if (!ft.worksWith(typeAndFlagFromCat.type())) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(typeAndFlagFromCat.flag() ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectCasing).setMessage(CASE_WARNING, new Object[]{value, ft, category, typeAndFlagFromCat.type()}));
            }
        }
    }

    public static enum Category {
        language,
        script,
        territory,
        variant,
        keyValue,
        month_narrow,
        month_format_except_narrow,
        month_standalone_except_narrow,
        day_narrow,
        day_format_except_narrow,
        day_standalone_except_narrow,
        era_narrow,
        era_abbr,
        era_name,
        quarter_narrow,
        quarter_abbreviated,
        quarter_format_wide,
        quarter_standalone_wide,
        calendar_field,
        zone_exemplarCity,
        zone_short,
        zone_long,
        NOT_USED,
        metazone_short,
        metazone_long,
        symbol,
        currencyName_count,
        currencyName,
        relative,
        unit_pattern,
        key;

    }

    public static enum CasingTypeAndErrFlag {
        titlecase_mismatchWarn(CasingType.titlecase, false),
        titlecase_mismatchErr(CasingType.titlecase, true),
        lowercase_mismatchWarn(CasingType.lowercase, false),
        lowercase_mismatchErr(CasingType.lowercase, true),
        other_mismatchWarn(CasingType.other, false),
        other_mismatchErr(CasingType.other, true);

        private final CasingType type;
        private final boolean flag;

        private CasingTypeAndErrFlag(CasingType type, boolean flag) {
            this.type = type;
            this.flag = flag;
        }

        public CasingType type() {
            return this.type;
        }

        public boolean flag() {
            return this.flag;
        }
    }

    public static enum CasingType {
        titlecase,
        lowercase,
        other;


        public static CasingType from(String s2) {
            int cp;
            if (s2 == null || s2.length() == 0) {
                return other;
            }
            for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
                cp = s2.codePointAt(i);
                int type = UCharacter.getType(cp);
                switch (type) {
                    case 2: {
                        return lowercase;
                    }
                    case 1: 
                    case 3: {
                        return titlecase;
                    }
                    case 5: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        return other;
                    }
                }
            }
            return other;
        }

        public boolean worksWith(CasingType otherType) {
            return otherType == null || this == otherType || this == other || otherType == other;
        }
    }
}

