/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class CheckPersonNames
extends CheckCLDR {
    private static final String LengthValues = Joiner.on(", ").join(PersonNameFormatter.Length.ALL.stream().map(x -> x.toString()).collect(Collectors.toList()));
    private static final String FormalityValues = Joiner.on(", ").join(PersonNameFormatter.Formality.ALL.stream().map(x -> x.toString()).collect(Collectors.toList()));
    static final String MISSING = CldrUtility.NO_INHERITANCE_MARKER;
    private boolean isRoot = false;
    private boolean hasRootParent = false;
    private String initialSeparator = " ";
    private UnicodeSet allowedCharacters;
    private boolean emptyNativeSpaceReplacement;
    static final UnicodeSet BASE_ALLOWED = new UnicodeSet("[\\p{sc=Common}\\p{sc=Inherited}-\\p{N}-[\u276e\u276f\u2205<>\u22050]]").freeze();
    static final UnicodeSet HANI = new UnicodeSet("[\\p{sc=Hani}]").freeze();
    static final UnicodeSet KORE = new UnicodeSet("[\\p{sc=Hang}]").addAll(HANI).freeze();
    static final UnicodeSet JPAN = new UnicodeSet("[\\p{sc=Kana}\\p{sc=Hira}]").addAll(HANI).freeze();
    static final UnicodeSet nativeSpaceReplacementValues = new UnicodeSet("[{}\\ ]").freeze();
    static final UnicodeSet foreignSpaceReplacementValues = new UnicodeSet("[\\ \u30fb\u00b7]").freeze();

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        String localeId = cldrFileToCheck.getLocaleID();
        this.isRoot = localeId.equals("root");
        this.hasRootParent = "root".equals(LocaleIDParser.getParent(localeId));
        String script = new LikelySubtags().getLikelyScript(localeId);
        this.allowedCharacters = new UnicodeSet(BASE_ALLOWED).addAll(this.getUnicodeSetForScript(script)).freeze();
        String initialPatternSequence = cldrFileToCheck.getStringValue("//ldml/personNames/initialPattern[@type=\"initialSequence\"]");
        this.initialSeparator = MessageFormat.format(initialPatternSequence, "", "");
        this.emptyNativeSpaceReplacement = cldrFileToCheck.getStringValue("//ldml/personNames/nativeSpaceReplacement").isEmpty();
        return super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
    }

    public UnicodeSet getUnicodeSetForScript(String script) {
        switch (script) {
            case "Jpan": {
                return JPAN;
            }
            case "Kore": {
                return KORE;
            }
            case "Hant": 
            case "Hans": {
                return HANI;
            }
        }
        return new UnicodeSet("[\\p{sc=" + script + "}]");
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (this.isRoot || !path.startsWith("//ldml/personNames/")) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        switch (parts.getElement(2)) {
            default: {
                boolean debug = false;
                break;
            }
            case "personName": {
                PersonNameFormatter.NamePattern namePattern = PersonNameFormatter.NamePattern.from(0, value);
                this.checkAdjacentFields(namePattern, result);
                ArrayList<List<String>> failures = namePattern.findInitialFailures(this.initialSeparator);
                for (List<String> row : failures) {
                    String previousField = row.get(0);
                    String intermediateLiteral = row.get(1);
                    String followingField = row.get(1);
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInPattern).setMessage("The gap between {0} and {2} must be the same as the pattern-initialSequence, =\u201c{1}\u201d", previousField, intermediateLiteral, followingField));
                }
                break;
            }
            case "nativeSpaceReplacement": {
                if (nativeSpaceReplacementValues.contains(value)) break;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInPattern).setMessage("NativeSpaceReplacement must be space if script requires spaces, and empty otherwise."));
                break;
            }
            case "foreignSpaceReplacement": {
                if (foreignSpaceReplacementValues.contains(value)) break;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInPattern).setMessage("ForeignSpaceReplacement must be space if script requires spaces."));
                break;
            }
            case "parameterDefault": {
                CheckPersonNames.checkParameterDefault(this, value, result, parts);
                break;
            }
            case "sampleName": {
                if (value == null) break;
                if (!this.allowedCharacters.containsAll(value) && !value.equals(CldrUtility.NO_INHERITANCE_MARKER)) {
                    UnicodeSet bad = new UnicodeSet().addAll(value).removeAll(this.allowedCharacters);
                    CheckCLDR.CheckStatus.Type mainType = this.getPhase() != CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(mainType).setSubtype(CheckCLDR.CheckStatus.Subtype.badSamplePersonName).setMessage("Illegal characters in sample name: " + bad.toPattern(false)));
                    break;
                }
                if (this.getCldrFileToCheck().getUnresolved().getStringValue(path) == null) break;
                String message = null;
                PersonNameFormatter.SampleType sampleType = PersonNameFormatter.SampleType.valueOf(parts.getAttributeValue(2, "item"));
                String modifiedField = parts.getAttributeValue(3, "type");
                boolean isMissingInUnresolved = value.equals(MISSING) || value.equals(CldrUtility.INHERITANCE_MARKER);
                PersonNameFormatter.Optionality optionality = sampleType.getOptionality(modifiedField);
                if (isMissingInUnresolved) {
                    if (optionality == PersonNameFormatter.Optionality.required) {
                        message = "This value must not be empty (" + MISSING + ")";
                    }
                } else if (optionality == PersonNameFormatter.Optionality.disallowed) {
                    message = "This value must be empty (" + MISSING + ")";
                } else if (modifiedField.equals("surname2")) {
                    String surname = this.getCldrFileToCheck().getStringValue(path).replace("surname2", "surname");
                    String surnameCore = this.getCldrFileToCheck().getStringValue(path).replace("surname2", "surname-core");
                    if (surname.equals(MISSING) && surnameCore.equals(MISSING)) {
                        message = "The value for '" + modifiedField + "' must not be empty (" + MISSING + ") unless 'surname2' is.";
                    }
                }
                if (message == null) break;
                this.getPhase();
                CheckCLDR.CheckStatus.Type mainType = this.getPhase() != CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(mainType).setSubtype(CheckCLDR.CheckStatus.Subtype.badSamplePersonName).setMessage(message));
            }
        }
        return this;
    }

    private void checkAdjacentFields(PersonNameFormatter.NamePattern namePattern, List<CheckCLDR.CheckStatus> result) {
        PersonNameFormatter.ModifiedField lastModifiedField = null;
        for (int i = 0; i < namePattern.getElementCount(); ++i) {
            PersonNameFormatter.ModifiedField modifiedField = namePattern.getModifiedField(i);
            if (modifiedField == null) {
                lastModifiedField = null;
            } else if (lastModifiedField != null) {
                if (lastModifiedField.getModifiers().contains((Object)PersonNameFormatter.Modifier.monogram) && modifiedField.getModifiers().contains((Object)PersonNameFormatter.Modifier.monogram) || lastModifiedField.getModifiers().contains((Object)PersonNameFormatter.Modifier.initial) || lastModifiedField.getModifiers().contains((Object)PersonNameFormatter.Modifier.initialCap) || modifiedField.getField() == PersonNameFormatter.Field.title && this.emptyNativeSpaceReplacement) continue;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(this.emptyNativeSpaceReplacement ? CheckCLDR.CheckStatus.warningType : CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingSpaceBetweenNameFields).setMessage("Normally there should be a space or punctuation between name fields: '{'{0}'}{'{1}'}'", lastModifiedField, modifiedField));
            }
            lastModifiedField = modifiedField;
        }
    }

    public static void checkParameterDefault(CheckCLDR checkCldr, String value, List<CheckCLDR.CheckStatus> result, XPathParts parts) {
        String okValues = null;
        boolean succeed = false;
        try {
            switch (parts.getAttributeValue(-1, "parameter")) {
                case "length": {
                    okValues = LengthValues;
                    PersonNameFormatter.Length.from(value);
                    break;
                }
                case "formality": {
                    okValues = FormalityValues;
                    PersonNameFormatter.Formality.from(value);
                }
            }
            succeed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null || !succeed) {
            result.add(new CheckCLDR.CheckStatus().setCause(checkCldr).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalParameterValue).setMessage("Valid values are: {0}", okValues));
        }
    }
}

