/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.LanguageGroup;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.LocaleIDParser;

public class ChartAnnotations
extends Chart {
    private static final String LDML_ANNOTATIONS = "<a href='https://unicode.org/reports/tr35/tr35-general.html#Annotations'>LDML Annotations</a>";
    private static final String MAIN_HEADER = "<p>Annotations provide names and keywords for Unicode characters, currently focusing on emoji. If you see any problems, please <a target='_blank' href='https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>file a ticket</a> with the corrected values for the locale. For the XML data used for these charts, see <a href='http://unicode.org/repos/cldr/tags/latest/common/annotations/'>latest-release annotations </a> or <a href='http://unicode.org/repos/cldr/tags/latest/common/annotations/'>beta annotations</a>. For more information, see <a href='https://unicode.org/reports/tr35/tr35-general.html#Annotations'>LDML Annotations</a>.</p>";
    private static final boolean DEBUG = false;
    private static final String DIR = CLDRPaths.CHART_DIRECTORY + "annotations/";
    static final UnicodeSet EXTRAS = new UnicodeSet().addAll((Iterable<?>)Arrays.asList("\ud83c\uddea\ud83c\uddfa", "\ud83d\udd1f", "#\ufe0f\u20e3", "\ud83d\udc76\ud83c\udffd", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc69", "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67", "\ud83d\udc68\ud83c\udffb\u200d\u2695\ufe0f", "\ud83d\udc6e\ud83c\udfff\u200d\u2642\ufe0f", "\ud83d\udc6e\ud83c\udffd\u200d\u2640\ufe0f", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "\ud83d\udc6e\ud83c\udffd\u200d\u2640\ufe0f", "\ud83d\udc8f", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "\ud83d\udc91", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc69", "\ud83d\udc6a", "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67", "\ud83d\udc66\ud83c\udffb", "\ud83d\udc69\ud83c\udfff", "\ud83d\udc68\u200d\u2696", "\ud83d\udc68\ud83c\udfff\u200d\u2696", "\ud83d\udc69\u200d\u2696", "\ud83d\udc69\ud83c\udffc\u200d\u2696", "\ud83d\udc6e", "\ud83d\udc6e\u200d\u2642\ufe0f", "\ud83d\udc6e\ud83c\udffc\u200d\u2642\ufe0f", "\ud83d\udc6e\u200d\u2640\ufe0f", "\ud83d\udc6e\ud83c\udfff\u200d\u2640\ufe0f", "\ud83d\udeb4", "\ud83d\udeb4\ud83c\udfff", "\ud83d\udeb4\u200d\u2642\ufe0f", "\ud83d\udeb4\ud83c\udfff\u200d\u2642\ufe0f", "\ud83d\udeb4\u200d\u2640\ufe0f", "\ud83d\udeb4\ud83c\udfff\u200d\u2640\ufe0f", "\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc73\udb40\udc63\udb40\udc74\udb40\udc7f", "#\ufe0f\u20e3", "\ud83c\udde6\ud83c\udde8", "\u26f9\ufe0f\u200d\u2640\ufe0f", "\ud83d\udc68\u200d\u2695\ufe0f", "\ud83c\udff3\ufe0f\u200d\ud83c\udf08", "\ud83c\udff4\u200d\u2620\ufe0f", "\ud83d\udc68\u200d\ud83e\uddb0", "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddb0", "\ud83c\udfff", "\ud83e\uddb0")).freeze();
    static final int FIRST_REGIONAL = 127462;
    static final int LAST_REGIONAL = 127487;
    public static RuleBasedCollator RBC;

    public static void main(String[] args) {
        new ChartAnnotations().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return DIR;
    }

    @Override
    public String getTitle() {
        return "Annotation Charts";
    }

    @Override
    public String getFileName() {
        return "index";
    }

    @Override
    public String getExplanation() {
        return "<p>Annotations provide names and keywords for Unicode characters, currently focusing on emoji. If you see any problems, please <a target='_blank' href='https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>file a ticket</a> with the corrected values for the locale. For the XML data used for these charts, see <a href='http://unicode.org/repos/cldr/tags/latest/common/annotations/'>latest-release annotations </a> or <a href='http://unicode.org/repos/cldr/tags/latest/common/annotations/'>beta annotations</a>. For more information, see <a href='https://unicode.org/reports/tr35/tr35-general.html#Annotations'>LDML Annotations</a>.</p><p>The charts are presented in groups of related languages, for easier comparison.<p>";
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        FileCopier.ensureDirectoryExists(DIR);
        FileCopier.copy(Chart.class, "index.css", DIR);
        FormattedFileWriter.copyIncludeHtmls(DIR);
        FormattedFileWriter.Anchors anchors = new FormattedFileWriter.Anchors();
        this.writeSubcharts(anchors);
        pw.setIndex("Main Chart Index", "../index.html");
        pw.write(anchors.toString());
    }

    public void writeSubcharts(FormattedFileWriter.Anchors anchors) throws IOException {
        Set<String> locales = Annotations.getAvailableLocales();
        Annotations.AnnotationSet english = Annotations.getDataSet("en");
        UnicodeSet s2 = new UnicodeSet(english.keySet()).addAll(EXTRAS).freeze();
        LinkedHashMap<String, String> nameToCode = new LinkedHashMap<String, String>();
        Relation<LanguageGroup, Row.R3<Integer, String, String>> groupToNameAndCodeSorted = Relation.of(new EnumMap(LanguageGroup.class), TreeSet.class);
        TreeMultimap<String, String> localeToSub = TreeMultimap.create();
        LanguageTagParser ltp = new LanguageTagParser();
        for (String string : locales) {
            ltp.set(string);
            if (string.equals("root") || string.equals("en")) continue;
            String region = ltp.getRegion();
            if (!region.isEmpty()) {
                localeToSub.put(ltp.getLanguageScript(), string);
                continue;
            }
            if (string.startsWith("en")) {
                boolean bl = false;
            }
            String name = ENGLISH.getName(string, true);
            int baseEnd = string.indexOf(95);
            ULocale loc = new ULocale(baseEnd < 0 ? string : string.substring(0, baseEnd));
            LanguageGroup group = LanguageGroup.get(loc);
            int rank = LanguageGroup.rankInGroup(loc);
            groupToNameAndCodeSorted.put(group, Row.of(rank, name, string));
        }
        for (Map.Entry entry : groupToNameAndCodeSorted.keyValuesSet()) {
            Object name;
            LanguageGroup group = (LanguageGroup)((Object)entry.getKey());
            String ename = ENGLISH.getName("en", true);
            nameToCode.clear();
            nameToCode.put(ename, "en");
            for (Row.R3 pair : (Set)entry.getValue()) {
                String name2 = (String)pair.get1();
                String locale = (String)pair.get2();
                if (!locale.startsWith("en_")) continue;
                nameToCode.put(name2, locale);
            }
            for (Row.R3 pair : (Set)entry.getValue()) {
                String name2 = (String)pair.get1();
                String locale = (String)pair.get2();
                nameToCode.put(name2, locale);
                System.out.println(pair);
            }
            double width = (double)((int)(99.0 / (double)(locales.size() + 1) * 1000.0)) / 1000.0;
            String widthStringTarget = "class='target' width='" + width + "%'";
            TablePrinter tablePrinter = new TablePrinter().addColumn("Char", "class='source' width='1%'", CldrUtility.getDoubleLinkMsg(), "class='source-image'", true).addColumn("Hex", "class='source' width='1%'", null, "class='source'", true);
            for (Map.Entry entry2 : nameToCode.entrySet()) {
                name = (String)entry2.getKey();
                tablePrinter.addColumn((String)name, widthStringTarget, null, "class='target'", true);
            }
            TreeSet<Object> sorted = new TreeSet<Object>(RBC);
            TreeMultimap<String, String> valueToSub = TreeMultimap.create();
            for (String cp : (Set)s2.addAllTo(sorted)) {
                tablePrinter.addRow().addCell((Comparable)((Object)cp)).addCell((Comparable)((Object)Utility.hex(cp, 4, " ")));
                for (Map.Entry nameAndLocale : nameToCode.entrySet()) {
                    String name3 = (String)nameAndLocale.getKey();
                    String locale = (String)nameAndLocale.getValue();
                    Annotations.AnnotationSet annotations = Annotations.getDataSet(locale);
                    Annotations.AnnotationSet parentAnnotations = Annotations.getDataSet(LocaleIDParser.getParent(locale));
                    Object baseAnnotation = annotations.toString(cp, true, parentAnnotations);
                    String baseAnnotationOriginal = baseAnnotation;
                    Collection subs = localeToSub.get(locale);
                    if (!subs.isEmpty()) {
                        valueToSub.clear();
                        for (String string : subs) {
                            Annotations.AnnotationSet subParentAnnotations;
                            Annotations.AnnotationSet subAnnotations = Annotations.getDataSet(string);
                            String baseAnnotation2 = subAnnotations.toString(cp, true, subParentAnnotations = Annotations.getDataSet(LocaleIDParser.getParent(locale)));
                            if (baseAnnotation2.equals(baseAnnotationOriginal)) continue;
                            valueToSub.put(baseAnnotation2, string);
                        }
                        for (Map.Entry entry3 : valueToSub.asMap().entrySet()) {
                            baseAnnotation = (String)baseAnnotation + "<hr><i>" + Joiner.on(", ").join((Iterable)entry3.getValue()) + "</i>: " + (String)entry3.getKey();
                        }
                    }
                    tablePrinter.addCell((Comparable)baseAnnotation);
                }
                tablePrinter.finishRow();
            }
            name = group.toString();
            new Subchart((String)name + " Annotations", FileUtilities.anchorize((String)name), tablePrinter).writeChart(anchors);
        }
    }

    public static int getRegionalIndicator(int firstCodepoint) {
        return 127462 <= firstCodepoint && firstCodepoint <= 127487 ? firstCodepoint - 127462 + 65 : -1;
    }

    static {
        Factory cldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "collation/", ".*");
        CLDRFile root = cldrFactory.make("root", false);
        String rules = root.getStringValue("//ldml/collations/collation[@type=\"emoji\"][@visibility=\"external\"]/cr");
        try {
            RBC = new RuleBasedCollator(rules);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failure in rules for " + CLDRPaths.COMMON_DIRECTORY + "collation/root", e);
        }
    }

    private class Subchart
    extends Chart {
        String title;
        String file;
        private TablePrinter tablePrinter;

        @Override
        public boolean getShowDate() {
            return false;
        }

        public Subchart(String title, String file, TablePrinter tablePrinter) {
            this.title = title;
            this.file = file;
            this.tablePrinter = tablePrinter;
        }

        @Override
        public String getDirectory() {
            return DIR;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getFileName() {
            return this.file;
        }

        @Override
        public String getExplanation() {
            return "<p>Annotations provide names and keywords for Unicode characters, currently focusing on emoji. If you see any problems, please <a target='_blank' href='https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>file a ticket</a> with the corrected values for the locale. For the XML data used for these charts, see <a href='http://unicode.org/repos/cldr/tags/latest/common/annotations/'>latest-release annotations </a> or <a href='http://unicode.org/repos/cldr/tags/latest/common/annotations/'>beta annotations</a>. For more information, see <a href='https://unicode.org/reports/tr35/tr35-general.html#Annotations'>LDML Annotations</a>.</p><p>This table shows the annotations for a group of related languages (plus English) for easier comparison. The first item is the <b>short name</b> (also the text-to-speech phrase). It is bolded for clarity, and marked with a * for searching on this page. The remaining phrases are <b>keywords</b> (labels), separated by \u201c|\u201d. The keywords plus the words in the short name are typically used for search and predictive typing.<p>\n<p>Most short names and keywords that can be constructed with the mechanism in <a href='https://unicode.org/reports/tr35/tr35-general.html#Annotations'>LDML Annotations</a> are omitted. However, a few are included for comparison: " + Joiner.on(", ").join(EXTRAS.addAllTo(new TreeSet())) + ". In this chart, missing items are marked with \u201c\u2296\u201d, \u2018fallback\u2019 constructed items with \u201c\u2297\u201d, substituted English values with \u201c\u2295\u201d, and values equal to their parent locale\u2019s values are replaced with \u2263.</p>\n";
        }

        @Override
        public void writeContents(FormattedFileWriter pw) throws IOException {
            pw.write(this.tablePrinter.toTable());
        }
    }
}

