/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.TreeMultimap;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Validity;

public class CheckLanguageNameCoverage {
    public static void main(String[] args) {
        Level level;
        String path;
        CLDRConfig config = CLDRConfig.getInstance();
        CoverageLevel2 coverages = CoverageLevel2.getInstance(config.getSupplementalDataInfo(), "haw");
        Validity validity = Validity.getInstance();
        TreeMultimap<Level, String> levelToLangs = TreeMultimap.create();
        Map<String, Validity.Status> map = validity.getCodeToStatus(StandardCodes.LstrType.language);
        TreeSet<String> targets = new TreeSet<String>(Arrays.asList("ceb", "ny", "co", "eo", "fy", "ht", "ha", "haw", "hmn", "ig", "jw", "ku", "la", "lb", "mg", "mt", "mi", "sm", "gd", "st", "sn", "so", "su", "tg", "xh", "yi", "yo"));
        for (String string : targets) {
            path = CLDRFile.getKey(0, string);
            level = coverages.getLevel(path);
            System.out.println(string + "\t" + level + "\t" + config.getEnglish().getName(string));
        }
        for (String string : map.keySet()) {
            path = CLDRFile.getKey(0, string);
            level = coverages.getLevel(path);
            if (level == null) continue;
            levelToLangs.put(level, string);
        }
        for (Map.Entry entry : levelToLangs.asMap().entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
    }
}

