/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.util.Output;
import java.util.Set;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;

public class CheckUnit {
    private static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();

    public static void main(String[] args) {
        MyOptions.parse(args);
        boolean verbose = MyOptions.verbose.option.doesOccur();
        UnitConverter uc = SDI.getUnitConverter();
        String rationalString = MyOptions.rational.option.getValue();
        String fromString = MyOptions.from.option.getValue();
        Rational rational = uc.parseRational(rationalString);
        Output<String> metricUnit = new Output<String>();
        UnitConverter.ConversionInfo convInfo = uc.parseUnitId(fromString, metricUnit, verbose);
        if (convInfo == null) {
            System.out.println("Can't parse unit: " + fromString);
            uc.parseUnitId(fromString, metricUnit, true);
            return;
        }
        Rational toValue = convInfo.convert(rational);
        String reducedUnit = uc.getReducedUnit((String)metricUnit.value);
        String standardUnit = uc.getStandardUnit((String)metricUnit.value);
        System.out.println(toValue.toString(Rational.FormatStyle.formatted) + "\t" + metricUnit + (String)(reducedUnit.equals(metricUnit.value) ? "" : "\t\u2261 " + reducedUnit) + (String)(standardUnit.equals(metricUnit.value) ? "" : "\t\u2261 " + standardUnit));
        if (MyOptions.to.option.doesOccur()) {
            String toString = MyOptions.to.option.getValue();
            convInfo = uc.parseUnitId(toString, metricUnit, verbose);
            if (convInfo == null) {
                System.out.println("Can't parse unit: " + toString);
                uc.parseUnitId(toString, metricUnit, true);
                return;
            }
            Rational newRational = uc.convert(rational, fromString, toString, verbose);
            if (newRational.equals(Rational.NaN)) {
                System.out.println("Can't convert between units: " + fromString + " to " + toString);
                uc.convert(rational, fromString, toString, true);
                return;
            }
            System.out.println(newRational.toString(Rational.FormatStyle.formatted) + "\t" + toString + "\t\u2261 " + newRational.doubleValue());
        }
    }

    private static enum MyOptions {
        rational(new Option.Params().setHelp("value, as rational").setMatch(".+").setDefault("1")),
        from(new Option.Params().setHelp("source unit").setMatch(".+")),
        to(new Option.Params().setHelp("target as unit").setMatch(".+")),
        verbose(new Option.Params().setHelp("verbose debugging messages"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

