/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.UnicodeRelation;

public class CompareExemplars {
    static final Set<String> Recommended = ImmutableSet.of("Zyyy", "Zinh", "Arab", "Armn", "Beng", "Bopo", new String[]{"Cyrl", "Deva", "Ethi", "Geor", "Grek", "Gujr", "Guru", "Hang", "Hani", "Hebr", "Hira", "Kana", "Knda", "Khmr", "Laoo", "Latn", "Mlym", "Mymr", "Orya", "Sinh", "Taml", "Telu", "Thaa", "Thai", "Tibt"});

    public static void main(String[] args) {
        UnicodeSet skip = new UnicodeSet("[[:nfkcqc=n:][:Lu:][:^XID_Continue:]]");
        UnicodeSet IdAllowed = new UnicodeSet("['\\-.0-\\:A-Z_a-z\u00b7\u00c0-\u00d6 \u00d8-\u00f6\u00f8-\u0131\u0134-\u013e\u0141-\u0148\u014a-\u017e\u018f\u01a0\u01a1\u01af\u01b0\u01cd-\u01dc \u01de-\u01e3\u01e6-\u01f0\u01f4\u01f5\u01f8-\u021b\u021e\u021f\u0226-\u0233\u0259\u02bb\u02bc\u02ec\u0300-\u0304\u0306-\u030c\u030f-\u0311\u0313\u0314\u031b\u0323-\u0328\u032d\u032e\u0330\u0331\u0335\u0338\u0339\u0342\u0345 \u0375\u037b-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03ce\u03fc-\u045f\u048a-\u04ff \u0510-\u0529\u052e\u052f\u0531-\u0556\u0559\u0561-\u0586\u058a\u05b4\u05d0-\u05ea\u05ef-\u05f4\u0620-\u063f \u0641-\u0655\u0660-\u0669\u0670-\u0672\u0674\u0679-\u068d\u068f-\u06a0\u06a2-\u06d3\u06d5\u06e5 \u06e6\u06ee-\u06ff\u0750-\u07b1\u0870-\u0887\u0889-\u088e\u08a0-\u08ac\u08b2\u08b5-\u08c9\u0901-\u094d\u094f \u0950\u0956\u0957\u0960-\u0963\u0966-\u096f\u0971-\u0977\u0979-\u097f\u0981-\u0983\u0985-\u098c \u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bc-\u09c4\u09c7\u09c8\u09cb-\u09ce\u09d7 \u09e0-\u09e3\u09e6-\u09f1\u09fe\u0a01-\u0a03\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30 \u0a32\u0a35\u0a38\u0a39\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a5c\u0a66-\u0a74\u0a81-\u0a83\u0a85-\u0a8d \u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abc-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd \u0ad0\u0ae0-\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28 \u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3c-\u0b43\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b5f-\u0b61 \u0b66-\u0b6f\u0b71\u0b82\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3 \u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd0\u0bd7\u0be6-\u0bef\u0c01-\u0c0c \u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3c-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56 \u0c5d\u0c60\u0c61\u0c66-\u0c6f\u0c80\u0c82\u0c83\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3 \u0cb5-\u0cb9\u0cbc-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0cdd\u0ce0-\u0ce3\u0ce6-\u0cef \u0cf1-\u0cf3\u0d00\u0d02\u0d03\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d-\u0d43\u0d46-\u0d48\u0d4a-\u0d4e \u0d54-\u0d57\u0d60\u0d61\u0d66-\u0d6f\u0d7a-\u0d7f\u0d82\u0d83\u0d85-\u0d8e\u0d91-\u0d96\u0d9a-\u0da5 \u0da7-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0dde\u0df2\u0e01-\u0e32\u0e34-\u0e3a \u0e40-\u0e4e\u0e50-\u0e59\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb2\u0eb4-\u0ebd \u0ec0-\u0ec4\u0ec6\u0ec8-\u0ece\u0ed0-\u0ed9\u0ede\u0edf\u0f00\u0f0b\u0f20-\u0f29\u0f35\u0f37\u0f3e-\u0f42 \u0f44-\u0f47\u0f49-\u0f4c\u0f4e-\u0f51\u0f53-\u0f56\u0f58-\u0f5b\u0f5d-\u0f68\u0f6a-\u0f6c\u0f71\u0f72\u0f74\u0f7a-\u0f80\u0f82-\u0f84\u0f86-\u0f92\u0f94-\u0f97\u0f99-\u0f9c\u0f9e-\u0fa1\u0fa3-\u0fa6\u0fa8-\u0fab\u0fad-\u0fb8\u0fba-\u0fbc\u0fc6 \u1000-\u1049\u1050-\u109d\u10c7\u10cd\u10d0-\u10f0\u10f7-\u10fa\u10fd-\u10ff\u1200-\u1248\u124a-\u124d \u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be \u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u135d-\u135f\u1380-\u138f \u1780-\u17a2\u17a5-\u17a7\u17a9-\u17b3\u17b6-\u17cd\u17d0\u17d2\u17d7\u17dc\u17e0-\u17e9\u1c90-\u1cba \u1cbd-\u1cbf\u1e00-\u1e99\u1e9e\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d \u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f70\u1f72\u1f74\u1f76\u1f78\u1f7a\u1f7c\u1f80-\u1fb4\u1fb6-\u1fba \u1fbc\u1fc2-\u1fc4\u1fc6-\u1fc8\u1fca\u1fcc\u1fd0-\u1fd2\u1fd6-\u1fda\u1fe0-\u1fe2\u1fe4-\u1fea \u1fec\u1ff2-\u1ff4\u1ff6-\u1ff8\u1ffa\u1ffc\u2010\u2019\u2027\u2d27\u2d2d\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae \u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007 \u3041-\u3096\u3099\u309a\u309d\u309e\u30a0-\u30fe\u3105-\u312d\u312f\u31a0-\u31bf\u3400-\u4dbf\u4e00-\u9fff \ua67f\ua717-\ua71f\ua788\ua78d\ua792\ua793\ua7aa\ua7c0-\ua7ca\ua7d0\ua7d1\ua7d3\ua7d5-\ua7d9\ua9e7-\ua9fe \uaa60-\uaa76\uaa7a-\uaa7f\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e \uab66\uab67\uac00-\ud7a3\ufa0e\ufa0f\ufa11\ufa13\ufa14\ufa1f\ufa21\ufa23\ufa24\ufa27-\ufa29\ud804\udf01\ud804\udf03\ud804\udf3b\ud804\udf3c\ud81b\udff0\ud81b\udff1 \ud82c\udd1f-\ud82c\udd22\ud82c\udd32\ud82c\udd50-\ud82c\udd52\ud82c\udd55\ud82c\udd64-\ud82c\udd67\ud837\udf00-\ud837\udf1e\ud837\udf25-\ud837\udf2a\ud838\udc8f\ud839\udfe0-\ud839\udfe6 \ud839\udfe8-\ud839\udfeb\ud839\udfed\ud839\udfee\ud839\udff0-\ud839\udffe\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf39\ud86d\udf40-\ud86e\udc1d\ud86e\udc20-\ud873\udea1\ud873\udeb0-\ud87a\udfe0 \ud880\udc00-\ud884\udf4a\ud884\udf50-\ud888\udfaf]").removeAll(skip).freeze();
        UnicodeRelation<String> charactersToLocales = new UnicodeRelation<String>();
        UnicodeSet allExemplars = new UnicodeSet();
        for (String subDir : ImmutableSet.of("common/main", "exemplars/main")) {
            CompareExemplars.gatherExemplars(subDir, charactersToLocales, allExemplars);
        }
        allExemplars.removeAll(skip);
        TreeMap<Integer, UnicodeSet> scriptCodeToCharacters = new TreeMap<Integer, UnicodeSet>();
        for (String string : allExemplars) {
            int scriptCode = UScript.getScript(string.codePointAt(0));
            if (scriptCode == 1 || scriptCode == 0) continue;
            UnicodeSet chars = (UnicodeSet)scriptCodeToCharacters.get(scriptCode);
            if (chars == null) {
                chars = new UnicodeSet();
                scriptCodeToCharacters.put(scriptCode, chars);
            }
            chars.add(string);
        }
        for (Map.Entry entry : scriptCodeToCharacters.entrySet()) {
            Integer scriptCode = (Integer)entry.getKey();
            String scriptName = UScript.getShortName(scriptCode);
            if (!Recommended.contains(scriptName)) continue;
            UnicodeSet cldr = ((UnicodeSet)entry.getValue()).freeze();
            UnicodeSet scriptSet = new UnicodeSet().applyIntPropertyValue(4106, scriptCode).freeze();
            UnicodeSet scriptAllowed = new UnicodeSet(scriptSet).retainAll(IdAllowed).freeze();
            CompareExemplars.show(scriptName, "\u2795CLDR\t\u2796Allowed", new UnicodeSet(cldr).removeAll(scriptAllowed), charactersToLocales);
            CompareExemplars.show(scriptName, "\u2796CLDR\t\u2795Allowed", new UnicodeSet(scriptAllowed).removeAll(cldr), null);
            CompareExemplars.show(scriptName, "\u2795CLDR\t\u2795Allowed", new UnicodeSet(cldr).retainAll(scriptAllowed), charactersToLocales);
        }
    }

    public static void show(String scriptName, String title, UnicodeSet allowed, UnicodeRelation<String> charactersToLocales) {
        if (!allowed.isEmpty()) {
            int allowedSize;
            String pattern = allowed.toPattern(false);
            System.out.println(scriptName + "\t" + title + "\t" + allowedSize + "\t" + (String)((allowedSize = allowed.size()) < 20000 ? pattern : pattern.substring(0, 500) + "\u2026") + "\t" + CompareExemplars.showLocales(allowed, charactersToLocales));
        }
    }

    private static String showLocales(UnicodeSet allowed, UnicodeRelation<String> charactersToLocales) {
        StringBuilder temp = new StringBuilder();
        LinkedHashMap<CallSite, UnicodeSet> compact = new LinkedHashMap<CallSite, UnicodeSet>();
        for (String string : allowed) {
            try {
                Set<String> locales = charactersToLocales.get(string);
                String set = locales.size() > 10 ? "(" + locales.size() + ")" : "[" + Joiner.on(" ").join(charactersToLocales.get(string)) + "]";
                UnicodeSet us = (UnicodeSet)compact.get(set);
                if (us == null) {
                    us = new UnicodeSet();
                    compact.put((CallSite)((Object)set), us);
                }
                us.add(string);
            }
            catch (Exception e) {
                boolean bl = false;
            }
        }
        for (Map.Entry entry : compact.entrySet()) {
            if (temp.length() != 0) {
                temp.append("; ");
            }
            temp.append(((UnicodeSet)entry.getValue()).toPattern(false) + "\u2b05\ufe0e" + (String)entry.getKey());
        }
        return temp.toString();
    }

    private static void gatherExemplars(String subdir, UnicodeRelation<String> results, UnicodeSet allExemplars) {
        Path aPath = CLDRConfig.getInstance().getCldrBaseDirectory().toPath().resolve(subdir);
        Factory factory = Factory.make(aPath.toString(), ".*");
        char lastLetter = '@';
        for (String locale : factory.getAvailable()) {
            CLDRFile cldrFile = factory.make(locale, false);
            UnicodeSet exemplars = cldrFile.getExemplarSet(CLDRFile.ExemplarType.main, CLDRFile.WinningChoice.WINNING);
            if (exemplars == null) continue;
            UnicodeSet aux = cldrFile.getExemplarSet(CLDRFile.ExemplarType.auxiliary, CLDRFile.WinningChoice.WINNING);
            if (aux != null && !aux.isEmpty()) {
                exemplars = new UnicodeSet(exemplars).addAll(aux);
            }
            if (locale.charAt(0) != lastLetter) {
                System.out.println(locale);
                lastLetter = locale.charAt(0);
            }
            results.addAll(exemplars, locale);
            allExemplars.addAll(CompareExemplars.flatten(exemplars));
        }
    }

    private static UnicodeSet flatten(UnicodeSet exemplars) {
        Collection<String> strings = exemplars.strings();
        if (strings == null || strings.isEmpty()) {
            return exemplars;
        }
        for (String s2 : ImmutableSet.copyOf(strings)) {
            exemplars.addAll(s2);
        }
        return new UnicodeSet(exemplars).removeAll(strings);
    }
}

