/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class DiffCldr {
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();

    public static void main(String[] args) {
        MyOptions.parse(args, true);
        String localeBase = MyOptions.filter.option.getValue();
        String dirBase = CLDRPaths.COMMON_DIRECTORY;
        PathHeader.Factory phf = PathHeader.getFactory(CONFIG.getEnglish());
        ChainedMap.M3<PathHeader, String, String> data = ChainedMap.of(new TreeMap(), new TreeMap(), String.class);
        Counter<String> localeCounter = new Counter<String>();
        Counter<PathHeader> pathHeaderCounter = new Counter<PathHeader>();
        int total = 0;
        Output<String> pathWhereFound = new Output<String>();
        Output<String> localeWhereFound = new Output<String>();
        TreeMultimap<String, String> extras = TreeMultimap.create();
        for (String dir : DtdType.ldml.directories) {
            Iterator factory = SimpleFactory.make(dirBase + dir, ".*");
            Set<String> available = ((Factory)((Object)factory)).getAvailable();
            LinkedHashSet<String> locales = new LinkedHashSet<String>();
            if (!available.contains(localeBase)) continue;
            locales.add(localeBase);
            for (String locale : available) {
                if (!DiffCldr.hasAncestor(locale, localeBase)) continue;
                locales.add(locale);
            }
            for (String locale : locales) {
                if (locale.equals("en_WS")) {
                    boolean bl = false;
                }
                boolean isBase = locale.equals(localeBase);
                CLDRFile cldrFile = ((Factory)((Object)factory)).make(locale, isBase);
                DtdData dtdData = cldrFile.getDtdData();
                CLDRFile cldrFileResolved = ((Factory)((Object)factory)).make(locale, true);
                for (String distinguishedPath : With.in(cldrFile.iterator())) {
                    String path = cldrFile.getFullXPath(distinguishedPath);
                    XPathParts pathPlain = XPathParts.getFrozenInstance(path);
                    if (dtdData.isMetadata(pathPlain) || pathPlain.getElement(1).equals("identity")) continue;
                    String value = cldrFile.getStringValue(distinguishedPath);
                    String bailey = cldrFileResolved.getBaileyValue(distinguishedPath, pathWhereFound, localeWhereFound);
                    Set<String> pathForValues = dtdData.getRegularizedPaths(pathPlain, extras);
                    if (pathForValues != null && (isBase || !value.equals(bailey))) {
                        for (String string : pathForValues) {
                            PathHeader ph = phf.fromPath(string);
                            Splitter splitter = DtdData.getValueSplitter(pathPlain);
                            String cleanedValue = DiffCldr.joinValues(pathPlain, splitter.splitToList(value));
                            total = DiffCldr.addValue(data, locale, ph, cleanedValue, total, localeCounter, pathHeaderCounter);
                        }
                    }
                    for (Map.Entry entry : extras.asMap().entrySet()) {
                        String extraPath = (String)entry.getKey();
                        PathHeader ph = phf.fromPath(extraPath);
                        Collection extraValues = (Collection)entry.getValue();
                        String cleanedValue = DiffCldr.joinValues(pathPlain, extraValues);
                        total = DiffCldr.addValue(data, locale, ph, cleanedValue, total, localeCounter, pathHeaderCounter);
                    }
                    if (pathForValues != null || value.isEmpty()) continue;
                    System.err.println("Shouldn't happen");
                }
            }
        }
        Set localeList = localeCounter.getKeysetSortedByCount(false);
        TreeSet<String> currentValues = new TreeSet<String>();
        System.out.print("\u2116\tSection\tPage\tHeader\tCode\tCount");
        for (String locale : localeList) {
            System.out.print("\t" + locale);
        }
        System.out.println();
        System.out.print("\t\t\t\tCount\t" + total);
        for (String locale : localeList) {
            System.out.print("\t" + localeCounter.get(locale));
        }
        System.out.println();
        int sort = 0;
        for (PathHeader ph : data.keySet()) {
            Object firstValue = null;
            currentValues.clear();
            Map localeToValue = data.get(ph);
            currentValues.addAll(localeToValue.values());
            if (currentValues.size() <= 1) continue;
            System.out.print(++sort + "\t" + ph + "\t" + pathHeaderCounter.get(ph));
            for (String locale : localeList) {
                System.out.print("\t" + CldrUtility.ifNull(localeToValue.get(locale), ""));
            }
            System.out.println();
        }
    }

    private static boolean hasAncestor(String locale, String localeBase) {
        while (locale != null) {
            if (locale.equals(localeBase)) {
                return true;
            }
            locale = LocaleIDParser.getParent(locale);
        }
        return false;
    }

    private static int addValue(ChainedMap.M3<PathHeader, String, String> data, String locale, PathHeader ph, String value, int total, Counter<String> localeCounter, Counter<PathHeader> pathHeaderCounter) {
        if (value.isEmpty()) {
            return 0;
        }
        String old = data.get(ph, locale);
        if (old != null) {
            return 0;
        }
        data.put(ph, locale, value);
        localeCounter.add(locale, 1L);
        pathHeaderCounter.add(ph, 1L);
        return ++total;
    }

    private static String joinValues(XPathParts pathPlain, Collection<String> values) {
        LinkedHashSet<String> cleanedValues = new LinkedHashSet<String>();
        for (String item : values) {
            if (DtdData.isComment(pathPlain, item)) continue;
            cleanedValues.add(item);
        }
        return Joiner.on(" \u240d ").join(DtdData.CR_SPLITTER.split(Joiner.on(" \u240d ").join(values)));
    }

    static enum MyOptions {
        filter(".*", "en_001", "locale ancestor");

        final Option option;
        static Option.Options myOptions;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = new Option(this, argumentPattern, defaultArgument, helpText);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

