/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.HelpMessages;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.tool.ToolUtilities;
import org.unicode.cldr.util.ArrayComparator;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;

public class FormattedFileWriter
extends Writer {
    public static final String CHART_TARGET_DIR = CLDRPaths.CHART_DIRECTORY + "/supplemental/";
    public static final Collator COL = Collator.getInstance(ULocale.ROOT).setStrength2(15);
    public static final ArrayComparator PC = new ArrayComparator(COL);
    private Anchors localeAnchors;
    private String dir;
    private String title;
    private String filename;
    private String indexLink = "index.html";
    private String indexTitle = "Index";
    private String explanation;
    private boolean showDate = true;
    private StringWriter out = new StringWriter();

    protected StringWriter getStringWriter() {
        return this.out;
    }

    public FormattedFileWriter(String baseFileName, String title, String explanation, Anchors anchors) throws IOException {
        if (baseFileName == null) {
            baseFileName = FileUtilities.anchorize(title);
        }
        this.dir = CHART_TARGET_DIR;
        this.filename = baseFileName;
        this.title = title;
        this.explanation = explanation;
        this.localeAnchors = anchors;
    }

    public String getBaseFileName() {
        return this.filename;
    }

    public String getDir() {
        return this.dir;
    }

    public FormattedFileWriter setDirectory(String dir) {
        this.dir = dir;
        return this;
    }

    public FormattedFileWriter setShowDate(boolean showDate) {
        this.showDate = showDate;
        return this;
    }

    @Override
    public void close() {
        Object contents = this.out.toString();
        if (((String)contents).isEmpty()) {
            return;
        }
        if (this.explanation == null) {
            this.explanation = HelpMessages.getChartMessages(this.filename);
        }
        if (this.explanation != null) {
            contents = this.explanation + (String)contents;
        }
        String targetFileName = this.filename + ".html";
        if (this.localeAnchors != null) {
            this.localeAnchors.add(this.title, targetFileName, null);
        }
        String templateFileName = "chart-template.html";
        String[] replacements = new String[]{"%header%", "", "%title%", this.title, "%index%", this.indexLink, "%index-title%", this.indexTitle, "%body%", contents, "%analytics%", Chart.AnalyticsID.CLDR.getScript()};
        FormattedFileWriter.writeTargetWithReplacements(this.dir, targetFileName, "chart-template.html", replacements);
    }

    public static void writeTargetWithReplacements(String targetdir, String targetFileName, String templateFileName, String[] replacements) {
        try {
            PrintWriter pw2 = FileUtilities.openUTF8Writer(targetdir, targetFileName);
            System.err.println("Writing: " + Paths.get(targetdir, targetFileName));
            FileUtilities.appendBufferedReader(ToolUtilities.getUTF8Data(templateFileName), pw2, replacements);
            pw2.close();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static void copyIncludeHtmls(String targetDirectory) {
        FormattedFileWriter.copyIncludeHtmls(targetDirectory, false);
    }

    public static void copyIncludeHtmls(String targetDirectory, boolean addPrevVersion) {
        String[] replacements = new String[]{"%version%", ToolConstants.CHART_DISPLAY_VERSION + (String)(addPrevVersion ? " \u2013 " + ToolConstants.PREV_CHART_VERSION_WITH0 : ""), "%date%", CldrUtility.isoFormatDateOnly(new Date())};
        FormattedFileWriter.writeTargetWithReplacements(targetDirectory, "include-date.html", "include-date.html", replacements);
        FormattedFileWriter.writeTargetWithReplacements(targetDirectory, "include-version.html", "include-version.html", replacements);
    }

    private String getDateValue() {
        return this.showDate ? CldrUtility.isoFormatDateOnly(new Date()) : "";
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public FormattedFileWriter setIndex(String indexTitle_, String indexLink_) {
        this.indexLink = indexLink_;
        this.indexTitle = indexTitle_;
        return this;
    }

    public static class Anchors {
        boolean hasExplanations = false;
        private Set<String[]> anchors = new TreeSet<String[]>(PC);

        public String toString() {
            StringBuffer contents = new StringBuffer("<div id='chits'>" + Chart.LS);
            ArrayList<String[]> anchorList = new ArrayList<String[]>(this.anchors);
            for (String[] item : anchorList) {
                String title = item[0];
                String fileName = item[1];
                String explanation = item[2];
                contents.append("\t<div class='chit'><a name='" + FileUtilities.anchorize(title) + "' href='" + fileName + "'>" + title + "</a></div>" + Chart.LS);
                if (!this.hasExplanations) continue;
                contents.append("\t<div class='chit'>" + explanation + "</div>" + Chart.LS);
            }
            contents.append("</div>" + Chart.LS);
            return contents.toString();
        }

        public void add(String title, String fileName, String explanation) {
            this.anchors.add(new String[]{title, fileName, explanation});
            if (explanation != null) {
                this.hasExplanations = true;
            }
        }
    }
}

